/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.json;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface JSONValue {
    public static JSONValue parse(String s) {
        return new JSONParser().parse(s);
    }

    default public int size() {
        throw new IllegalStateException("Size operation unsupported");
    }

    default public String asString() {
        throw new IllegalStateException("Unsupported conversion to String");
    }

    default public JSONArray asArray() {
        throw new IllegalStateException("Unsupported conversion to array");
    }

    default public JSONObject asObject() {
        throw new IllegalStateException("Unsupported conversion to object");
    }

    default public JSONValue get(String field) {
        return this.asObject().get(field);
    }

    public static class JSONParser {
        private int pos = 0;
        private String input;

        JSONParser() {
        }

        private IllegalStateException failure(String message) {
            return new IllegalStateException(String.format("[%d]: %s : %s", this.pos, message, this.input));
        }

        private char current() {
            return this.input.charAt(this.pos);
        }

        private void advance() {
            ++this.pos;
        }

        private boolean hasInput() {
            return this.pos < this.input.length();
        }

        private void expectMoreInput(String message) {
            if (!this.hasInput()) {
                throw this.failure(message);
            }
        }

        private char next(String message) {
            this.advance();
            if (!this.hasInput()) {
                throw this.failure(message);
            }
            return this.current();
        }

        private void expect(char c) {
            String msg = String.format("Expected character %c", Character.valueOf(c));
            char n = this.next(msg);
            if (n != c) {
                throw this.failure(msg);
            }
        }

        private JSONString parseBoolean() {
            if (this.current() == 't') {
                this.expect('r');
                this.expect('u');
                this.expect('e');
                this.advance();
                return new JSONString("true");
            }
            if (this.current() == 'f') {
                this.expect('a');
                this.expect('l');
                this.expect('s');
                this.expect('e');
                this.advance();
                return new JSONString("false");
            }
            throw this.failure("a boolean can only be 'true' or 'false'");
        }

        private JSONValue parseNumber() {
            boolean isInteger = true;
            StringBuilder builder = new StringBuilder();
            if (this.current() == '-') {
                builder.append(this.current());
                this.advance();
                this.expectMoreInput("a number cannot consist of only '-'");
            }
            if (this.current() == '0') {
                builder.append(this.current());
                this.advance();
                if (this.hasInput() && this.current() == '.') {
                    isInteger = false;
                    builder.append(this.current());
                    this.advance();
                    this.expectMoreInput("a number cannot end with '.'");
                    if (!this.isDigit(this.current())) {
                        throw this.failure("must be at least one digit after '.'");
                    }
                    while (this.hasInput() && this.isDigit(this.current())) {
                        builder.append(this.current());
                        this.advance();
                    }
                }
            } else {
                while (this.hasInput() && this.isDigit(this.current())) {
                    builder.append(this.current());
                    this.advance();
                }
                if (this.hasInput() && this.current() == '.') {
                    isInteger = false;
                    builder.append(this.current());
                    this.advance();
                    this.expectMoreInput("a number cannot end with '.'");
                    if (!this.isDigit(this.current())) {
                        throw this.failure("must be at least one digit after '.'");
                    }
                    while (this.hasInput() && this.isDigit(this.current())) {
                        builder.append(this.current());
                        this.advance();
                    }
                }
            }
            if (this.hasInput() && (this.current() == 'e' || this.current() == 'E')) {
                isInteger = false;
                builder.append(this.current());
                this.advance();
                this.expectMoreInput("a number cannot end with 'e' or 'E'");
                if (this.current() == '+' || this.current() == '-') {
                    builder.append(this.current());
                    this.advance();
                }
                if (!this.isDigit(this.current())) {
                    throw this.failure("a digit must follow {'e','E'}{'+','-'}");
                }
                while (this.hasInput() && this.isDigit(this.current())) {
                    builder.append(this.current());
                    this.advance();
                }
            }
            String value = builder.toString();
            if (isInteger) {
                new BigInteger(value);
                return new JSONString(value);
            }
            Double.parseDouble(value);
            return new JSONString(value);
        }

        private JSONString parseString() {
            String missingEndChar = "string is not terminated with '\"'";
            StringBuilder builder = new StringBuilder();
            char c = this.next(missingEndChar);
            while (c != '\"') {
                if (c == '\\') {
                    char n = this.next(missingEndChar);
                    switch (n) {
                        case '\"': {
                            builder.append("\"");
                            break;
                        }
                        case '\\': {
                            builder.append("\\");
                            break;
                        }
                        case '/': {
                            builder.append("/");
                            break;
                        }
                        case 'b': {
                            builder.append("\b");
                            break;
                        }
                        case 'f': {
                            builder.append("\f");
                            break;
                        }
                        case 'n': {
                            builder.append("\n");
                            break;
                        }
                        case 'r': {
                            builder.append("\r");
                            break;
                        }
                        case 't': {
                            builder.append("\t");
                            break;
                        }
                        case 'u': {
                            char u1 = this.next(missingEndChar);
                            char u2 = this.next(missingEndChar);
                            char u3 = this.next(missingEndChar);
                            char u4 = this.next(missingEndChar);
                            int cp = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf(u1), Character.valueOf(u2), Character.valueOf(u3), Character.valueOf(u4)), 16);
                            builder.append(new String(new int[]{cp}, 0, 1));
                            break;
                        }
                        default: {
                            throw this.failure(String.format("Unexpected escaped character '%c'", Character.valueOf(n)));
                        }
                    }
                } else {
                    builder.append(c);
                }
                c = this.next(missingEndChar);
            }
            this.advance();
            return new JSONString(builder.toString());
        }

        private JSONArray parseArray() {
            String error = "array is not terminated with ']'";
            ArrayList<JSONValue> list = new ArrayList<JSONValue>();
            this.advance();
            this.consumeWhitespace();
            this.expectMoreInput(error);
            while (this.current() != ']') {
                JSONValue val = this.parseValue();
                list.add(val);
                this.expectMoreInput(error);
                if (this.current() == ',') {
                    this.advance();
                }
                this.expectMoreInput(error);
            }
            this.advance();
            return new JSONArray(list);
        }

        public JSONString parseNull() {
            this.expect('u');
            this.expect('l');
            this.expect('l');
            this.advance();
            return new JSONString(null);
        }

        public JSONObject parseObject() {
            String error = "object is not terminated with '}'";
            HashMap<String, JSONValue> map = new HashMap<String, JSONValue>();
            this.advance();
            this.consumeWhitespace();
            this.expectMoreInput(error);
            while (this.current() != '}') {
                JSONValue key = this.parseValue();
                if (!(key instanceof JSONString)) {
                    throw this.failure("a field must of type string");
                }
                if (!this.hasInput() || this.current() != ':') {
                    throw this.failure("a field must be followed by ':'");
                }
                this.advance();
                JSONValue val = this.parseValue();
                map.put(key.asString(), val);
                this.expectMoreInput(error);
                if (this.current() == ',') {
                    this.advance();
                }
                this.expectMoreInput(error);
            }
            this.advance();
            return new JSONObject(map);
        }

        private boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        private boolean isStartOfNumber(char c) {
            return this.isDigit(c) || c == '-';
        }

        private boolean isStartOfString(char c) {
            return c == '\"';
        }

        private boolean isStartOfBoolean(char c) {
            return c == 't' || c == 'f';
        }

        private boolean isStartOfArray(char c) {
            return c == '[';
        }

        private boolean isStartOfNull(char c) {
            return c == 'n';
        }

        private boolean isWhitespace(char c) {
            return c == '\r' || c == '\n' || c == '\t' || c == ' ';
        }

        private boolean isStartOfObject(char c) {
            return c == '{';
        }

        private void consumeWhitespace() {
            while (this.hasInput() && this.isWhitespace(this.current())) {
                this.advance();
            }
        }

        public JSONValue parseValue() {
            JSONValue ret = null;
            this.consumeWhitespace();
            if (this.hasInput()) {
                char c = this.current();
                if (this.isStartOfNumber(c)) {
                    ret = this.parseNumber();
                } else if (this.isStartOfString(c)) {
                    ret = this.parseString();
                } else if (this.isStartOfBoolean(c)) {
                    ret = this.parseBoolean();
                } else if (this.isStartOfArray(c)) {
                    ret = this.parseArray();
                } else if (this.isStartOfNull(c)) {
                    ret = this.parseNull();
                } else if (this.isStartOfObject(c)) {
                    ret = this.parseObject();
                } else {
                    throw this.failure("not a valid start of a JSON value");
                }
            }
            this.consumeWhitespace();
            return ret;
        }

        public JSONValue parse(String s) {
            if (s == null || s.equals("")) {
                return null;
            }
            this.pos = 0;
            this.input = s;
            JSONValue result = this.parseValue();
            if (this.hasInput()) {
                throw this.failure("can only have one top-level JSON value");
            }
            return result;
        }
    }

    public static final class JSONObject
    implements JSONValue {
        private final Map<String, JSONValue> value;

        public JSONObject(Map<String, JSONValue> value) {
            this.value = value;
        }

        @Override
        public JSONObject asObject() {
            return this;
        }

        @Override
        public JSONValue get(String k) {
            return this.value.get(k);
        }

        @Override
        public int size() {
            return this.value.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (String key : this.value.keySet()) {
                builder.append("\"");
                builder.append(key);
                builder.append("\":");
                builder.append(this.value.get(key).toString());
                builder.append(",");
            }
            int end = builder.length() - 1;
            if (builder.charAt(end) == ',') {
                builder.deleteCharAt(end);
            }
            builder.append("}");
            return builder.toString();
        }
    }

    public static final class JSONArray
    implements JSONValue,
    Iterable<JSONValue> {
        private final List<JSONValue> values;

        public JSONArray(List<JSONValue> array) {
            this.values = array;
        }

        @Override
        public JSONArray asArray() {
            return this;
        }

        public JSONValue get(int i) {
            return this.values.get(i);
        }

        @Override
        public int size() {
            return this.values.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                builder.append(this.get(i).toString());
                if (i == this.size() - 1) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public Iterator<JSONValue> iterator() {
            return this.values.iterator();
        }
    }

    public static final class JSONString
    implements JSONValue {
        private final String value;

        public JSONString(String value) {
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value;
        }

        public String toString() {
            if (this.value == null) {
                return "null";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("\"");
            block10: for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                switch (c) {
                    case '\"': {
                        builder.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        builder.append("\\\\");
                        continue block10;
                    }
                    case '/': {
                        builder.append("\\/");
                        continue block10;
                    }
                    case '\b': {
                        builder.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        builder.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        builder.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        builder.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        builder.append("\\t");
                        continue block10;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            builder.append("\"");
            return builder.toString();
        }
    }
}

