/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class JavacBenchApp {
    List<SourceFile> sources;
    static final String imports = "import java.lang.*;\nimport java.util.*;\n";
    static final String testClassBody = "// Some comments\nstatic long x;\nstatic final long y;\nstatic {\n    y = System.currentTimeMillis();\n}\n/* More comments */\n@Deprecated\nString func() { return \"String \" + this + y; }\npublic static void main(String args[]) {\n    try {\n        x = Long.parseLong(args[0]);\n    } catch (Throwable t) {\n        t.printStackTrace();\n    }\n    doit(() -> {\n        System.out.println(\"Hello Lambda\");\n        Thread.dumpStack();\n    });\n}\nstatic List<String> list = List.of(\"1\", \"2\");\nclass InnerClass1 {\n    static final long yy = y;\n}\nstatic void doit(Runnable r) {\n    for (var x : list) {\n        r.run();\n    }\n}\nstatic String patternMatch(String arg, Object o) {\n    if (o instanceof String s) {\n        return \"1234\";\n    }\n    final String b = \"B\";\n    return switch (arg) {\n        case \"A\" -> \"a\";\n        case b   -> \"b\";\n        default  -> \"c\";\n    };\n}\npublic sealed class SealedInnerClass {}\npublic final class Foo extends SealedInnerClass {}\nenum Expression {\n    ADDITION,\n    SUBTRACTION,\n    MULTIPLICATION,\n    DIVISION\n}\npublic record Point(int x, int y) {\n    public Point(int x) {\n        this(x, 0);\n    }\n}\n";
    String sanitySource = "public class Sanity implements java.util.concurrent.Callable<String> {\n    public String call() {\n        return \"this is a test\";\n    }\n}\n";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, byte[]> compile() {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector ds = new DiagnosticCollector();
        List<SourceFile> sourceFiles = this.sources;
        try (FileManager fileManager = new FileManager(compiler.getStandardFileManager(ds, null, null));){
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, null, null, sourceFiles);
            if (task.call().booleanValue()) {
                Map<String, byte[]> map = fileManager.getCompiledClasses();
                return map;
            }
            Iterator iterator = ds.getDiagnostics().iterator();
            while (iterator.hasNext()) {
                Diagnostic d = iterator.next();
                System.out.format("Line: %d, %s in %s", d.getLineNumber(), d.getMessage(null), ((JavaFileObject)d.getSource()).getName());
            }
            throw new InternalError("compilation failure");
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    void setup(int count) {
        this.sources = new ArrayList<SourceFile>(count);
        for (int i = 0; i < count; ++i) {
            String source = "import java.lang.*;\nimport java.util.*;\npublic class Test" + i + " {// Some comments\nstatic long x;\nstatic final long y;\nstatic {\n    y = System.currentTimeMillis();\n}\n/* More comments */\n@Deprecated\nString func() { return \"String \" + this + y; }\npublic static void main(String args[]) {\n    try {\n        x = Long.parseLong(args[0]);\n    } catch (Throwable t) {\n        t.printStackTrace();\n    }\n    doit(() -> {\n        System.out.println(\"Hello Lambda\");\n        Thread.dumpStack();\n    });\n}\nstatic List<String> list = List.of(\"1\", \"2\");\nclass InnerClass1 {\n    static final long yy = y;\n}\nstatic void doit(Runnable r) {\n    for (var x : list) {\n        r.run();\n    }\n}\nstatic String patternMatch(String arg, Object o) {\n    if (o instanceof String s) {\n        return \"1234\";\n    }\n    final String b = \"B\";\n    return switch (arg) {\n        case \"A\" -> \"a\";\n        case b   -> \"b\";\n        default  -> \"c\";\n    };\n}\npublic sealed class SealedInnerClass {}\npublic final class Foo extends SealedInnerClass {}\nenum Expression {\n    ADDITION,\n    SUBTRACTION,\n    MULTIPLICATION,\n    DIVISION\n}\npublic record Point(int x, int y) {\n    public Point(int x) {\n        this(x, 0);\n    }\n}\n}";
            this.sources.add(new SourceFile("Test" + i, source));
        }
        this.sources.add(new SourceFile("Sanity", this.sanitySource));
    }

    static void validate(byte[] sanityClassFile) throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> cls = lookup.defineClass(sanityClassFile);
        Callable obj = (Callable)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String s = (String)obj.call();
        if (!s.equals("this is a test")) {
            throw new RuntimeException("Expected \"this is a test\", but got \"" + s + "\"");
        }
    }

    public static void main(String[] args) throws Throwable {
        long started = System.currentTimeMillis();
        JavacBenchApp bench = new JavacBenchApp();
        int count = 0;
        if (args.length > 0 && (count = Integer.parseInt(args[0])) >= 0) {
            bench.setup(count);
            Map<String, byte[]> allClasses = bench.compile();
            JavacBenchApp.validate(allClasses.get("Sanity"));
        }
        if (System.getProperty("JavacBenchApp.silent") == null) {
            long elapsed = System.currentTimeMillis() - started;
            System.out.println("Generated source code for " + bench.sources.size() + " classes and compiled them in " + elapsed + " ms");
        }
    }

    static class FileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private Map<String, ClassFile> classesMap = new HashMap<String, ClassFile>();

        protected FileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public ClassFile getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject source) {
            ClassFile classFile = new ClassFile(name);
            this.classesMap.put(name, classFile);
            return classFile;
        }

        public Map<String, byte[]> getCompiledClasses() {
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            for (Map.Entry<String, ClassFile> entry : this.classesMap.entrySet()) {
                result.put(entry.getKey(), entry.getValue().toByteArray());
            }
            return result;
        }
    }

    static class SourceFile
    extends SimpleJavaFileObject {
        private CharSequence sourceCode;

        public SourceFile(String name, CharSequence sourceCode) {
            super(URI.create("memo:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.sourceCode = sourceCode;
        }

        @Override
        public CharSequence getCharContent(boolean ignore) {
            return this.sourceCode;
        }
    }

    static class ClassFile
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        protected ClassFile(String name) {
            super(URI.create("memo:///" + name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
        }

        @Override
        public ByteArrayOutputStream openOutputStream() {
            return this.baos;
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }
}

