/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.docker;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import jdk.test.lib.Container;
import jdk.test.lib.Utils;
import jdk.test.lib.containers.docker.DockerRunOptions;
import jdk.test.lib.containers.docker.DockerfileConfig;
import jdk.test.lib.process.OutputAnalyzer;
import jtreg.SkippedException;

public class DockerTestUtils {
    private static boolean isDockerEngineAvailable = false;
    private static boolean wasDockerEngineChecked = false;
    private static final int MAX_LINES_TO_COPY_FOR_CHILD_STDOUT = 100;
    public static final boolean RETAIN_IMAGE_AFTER_TEST = Boolean.getBoolean("jdk.test.docker.retain.image");
    public static final String JDK_UNDER_TEST = System.getProperty("jdk.test.docker.jdk", Utils.TEST_JDK);

    public static boolean isDockerEngineAvailable() throws Exception {
        if (wasDockerEngineChecked) {
            return isDockerEngineAvailable;
        }
        isDockerEngineAvailable = DockerTestUtils.isDockerEngineAvailableCheck();
        wasDockerEngineChecked = true;
        return isDockerEngineAvailable;
    }

    public static boolean canTestDocker() throws Exception {
        if (DockerTestUtils.isDockerEngineAvailable()) {
            return true;
        }
        throw new SkippedException("Docker engine is not available on this system");
    }

    private static boolean isDockerEngineAvailableCheck() throws Exception {
        try {
            DockerTestUtils.execute(Container.ENGINE_COMMAND, "ps").shouldHaveExitValue(0).shouldContain("CONTAINER").shouldContain("IMAGE");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void buildJdkContainerImage(String imageName) throws Exception {
        DockerTestUtils.buildJdkContainerImage(imageName, null);
    }

    public static void buildJdkContainerImage(String imageName, String dockerfileContent) throws Exception {
        String imageDirName = imageName.replace(":", "-");
        Path buildDir = Paths.get(imageDirName, new String[0]);
        if (Files.exists(buildDir, new LinkOption[0])) {
            throw new RuntimeException("The docker build directory already exists: " + String.valueOf(buildDir));
        }
        Files.createDirectories(buildDir, new FileAttribute[0]);
        if (dockerfileContent != null) {
            Files.writeString(buildDir.resolve("Dockerfile"), (CharSequence)dockerfileContent, new OpenOption[0]);
        } else {
            DockerTestUtils.generateDockerFile(buildDir.resolve("Dockerfile"), DockerfileConfig.getBaseImageName(), DockerfileConfig.getBaseImageVersion());
        }
        Path jdkSrcDir = Paths.get(JDK_UNDER_TEST, new String[0]);
        Path jdkDstDir = buildDir.resolve("jdk");
        Files.createDirectories(jdkDstDir, new FileAttribute[0]);
        Files.walkFileTree(jdkSrcDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new CopyFileVisitor(jdkSrcDir, jdkDstDir));
        DockerTestUtils.buildImage(imageName, buildDir);
    }

    private static void buildImage(String imageName, Path buildDir) throws Exception {
        try {
            DockerTestUtils.execute(Container.ENGINE_COMMAND, "build", "--no-cache", "--tag", imageName, buildDir.toString()).shouldHaveExitValue(0);
        }
        catch (Exception e) {
            throw new SkippedException("Building docker image failed. Details: \n" + e.getMessage());
        }
    }

    public static List<String> buildJavaCommand(DockerRunOptions opts) throws Exception {
        List<String> cmd = DockerTestUtils.buildContainerCommand();
        cmd.add("run");
        if (opts.tty) {
            cmd.add("--tty=true");
        }
        if (opts.removeContainerAfterUse) {
            cmd.add("--rm");
        }
        cmd.addAll(opts.dockerOpts);
        cmd.add(opts.imageNameAndTag);
        cmd.add(opts.command);
        cmd.addAll(opts.javaOpts);
        if (opts.appendTestJavaOptions) {
            Collections.addAll(cmd, Utils.getTestJavaOpts());
        }
        cmd.addAll(opts.javaOptsAppended);
        cmd.add(opts.classToRun);
        cmd.addAll(opts.classParams);
        return cmd;
    }

    public static List<String> buildContainerCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Container.ENGINE_COMMAND);
        return cmd;
    }

    public static OutputAnalyzer dockerRunJava(DockerRunOptions opts) throws Exception {
        return DockerTestUtils.execute(DockerTestUtils.buildJavaCommand(opts));
    }

    public static void removeDockerImage(String imageNameAndTag) throws Exception {
        DockerTestUtils.execute(Container.ENGINE_COMMAND, "rmi", "--force", imageNameAndTag);
    }

    public static OutputAnalyzer execute(List<String> command) throws Exception {
        return DockerTestUtils.execute(command.toArray(new String[command.size()]));
    }

    public static OutputAnalyzer execute(String ... command) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(command);
        System.out.println("[COMMAND]\n" + Utils.getCommandLine(pb));
        long started = System.currentTimeMillis();
        Process p = pb.start();
        long pid = p.pid();
        OutputAnalyzer output = new OutputAnalyzer(p);
        int max = 100;
        String stdout = output.getStdout();
        String stdoutLimited = DockerTestUtils.limitLines(stdout, max);
        System.out.println("[ELAPSED: " + (System.currentTimeMillis() - started) + " ms]");
        System.out.println("[STDERR]\n" + output.getStderr());
        System.out.println("[STDOUT]\n" + stdoutLimited);
        if (!stdout.equals(stdoutLimited)) {
            System.out.printf("Child process STDOUT is limited to %d lines\n", max);
        }
        String stdoutLogFile = String.format("docker-stdout-%d.log", pid);
        DockerTestUtils.writeOutputToFile(stdout, stdoutLogFile);
        System.out.println("Full child process STDOUT was saved to " + stdoutLogFile);
        return output;
    }

    private static void writeOutputToFile(String output, String fileName) throws Exception {
        try (FileWriter fw = new FileWriter(fileName);){
            fw.write(output, 0, output.length());
        }
    }

    private static String limitLines(String buffer, int nrOfLines) {
        List<String> l = Arrays.asList(buffer.split("\\R"));
        if (l.size() < nrOfLines) {
            return buffer;
        }
        return String.join((CharSequence)"\n", l.subList(0, nrOfLines));
    }

    private static void generateDockerFile(Path dockerfile, String baseImage, String baseImageVersion) throws Exception {
        Object template = "FROM %s:%s\n";
        if (baseImage.contains("ubuntu") && DockerfileConfig.isUbsan()) {
            template = (String)template + "RUN apt-get update && apt-get install -y libubsan1\n";
        }
        template = (String)template + "COPY /jdk /jdk\nENV JAVA_HOME=/jdk\nCMD [\"/bin/bash\"]\n";
        String dockerFileStr = String.format((String)template, baseImage, baseImageVersion);
        Files.writeString(dockerfile, (CharSequence)dockerFileStr, new OpenOption[0]);
    }

    private static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path src;
        private final Path dst;

        public CopyFileVisitor(Path src, Path dst) {
            this.src = src;
            this.dst = dst;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
            Path dstDir = this.dst.resolve(this.src.relativize(file));
            if (!dstDir.toFile().exists()) {
                Files.createDirectories(dstDir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!file.toFile().isFile()) {
                return FileVisitResult.CONTINUE;
            }
            Path dstFile = this.dst.resolve(this.src.relativize(file));
            Files.copy(file, dstFile, StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }
    }
}

