/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import jdk.test.lib.hprof.model.AbstractJavaHeapObjectVisitor;
import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaField;
import jdk.test.lib.hprof.model.JavaHeapObject;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.ReachableExcludes;
import jdk.test.lib.hprof.util.ArraySorter;
import jdk.test.lib.hprof.util.Comparer;

public class ReachableObjects {
    private JavaHeapObject root;
    private JavaThing[] reachables;
    private String[] excludedFields;
    private String[] usedFields;
    private long totalSize;

    public ReachableObjects(JavaHeapObject root, final ReachableExcludes excludes) {
        this.root = root;
        final Hashtable bag = new Hashtable();
        final Hashtable fieldsExcluded = new Hashtable();
        final Hashtable fieldsUsed = new Hashtable();
        AbstractJavaHeapObjectVisitor visitor = new AbstractJavaHeapObjectVisitor(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void visit(JavaHeapObject t) {
                if (t != null && t.getSize() > 0L && bag.get(t) == null) {
                    bag.put(t, t);
                    t.visitReferencedObjects(this);
                }
            }

            @Override
            public boolean mightExclude() {
                return excludes != null;
            }

            @Override
            public boolean exclude(JavaClass clazz, JavaField f) {
                if (excludes == null) {
                    return false;
                }
                String nm = clazz.getName() + "." + f.getName();
                if (excludes.isExcluded(nm)) {
                    fieldsExcluded.put(nm, nm);
                    return true;
                }
                fieldsUsed.put(nm, nm);
                return false;
            }
        };
        visitor.visit(root);
        bag.remove(root);
        Object[] things = new JavaThing[bag.size()];
        int i = 0;
        Enumeration e = bag.elements();
        while (e.hasMoreElements()) {
            things[i++] = (JavaThing)e.nextElement();
        }
        ArraySorter.sort(things, new Comparer(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(Object lhs, Object rhs) {
                JavaThing left = (JavaThing)lhs;
                JavaThing right = (JavaThing)rhs;
                long diff = right.getSize() - left.getSize();
                if (diff != 0L) {
                    return Long.signum(diff);
                }
                return left.compareTo(right);
            }
        });
        this.reachables = things;
        this.totalSize = root.getSize();
        for (i = 0; i < things.length; ++i) {
            this.totalSize += ((JavaThing)things[i]).getSize();
        }
        this.excludedFields = this.getElements(fieldsExcluded);
        this.usedFields = this.getElements(fieldsUsed);
    }

    public JavaHeapObject getRoot() {
        return this.root;
    }

    public JavaThing[] getReachables() {
        return this.reachables;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public String[] getExcludedFields() {
        return this.excludedFields;
    }

    public String[] getUsedFields() {
        return this.usedFields;
    }

    private String[] getElements(Hashtable<?, ?> ht) {
        Object[] keys = ht.keySet().toArray();
        int len = keys.length;
        Object[] res = new String[len];
        System.arraycopy(keys, 0, res, 0, len);
        ArraySorter.sortArrayOfStrings(res);
        return res;
    }
}

