/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Enabled;
import jdk.jfr.Event;
import jdk.jfr.Name;
import jdk.jfr.Period;
import jdk.jfr.SettingControl;
import jdk.jfr.SettingDefinition;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.events.ActiveSettingEvent;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.Cutoff;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.settings.CutoffSetting;
import jdk.jfr.internal.settings.EnabledSetting;
import jdk.jfr.internal.settings.PeriodSetting;
import jdk.jfr.internal.settings.StackTraceSetting;
import jdk.jfr.internal.settings.ThresholdSetting;

public final class EventControl {
    static final String FIELD_SETTING_PREFIX = "setting";
    private static final Type TYPE_ENABLED = TypeLibrary.createType(EnabledSetting.class);
    private static final Type TYPE_THRESHOLD = TypeLibrary.createType(ThresholdSetting.class);
    private static final Type TYPE_STACK_TRACE = TypeLibrary.createType(StackTraceSetting.class);
    private static final Type TYPE_PERIOD = TypeLibrary.createType(PeriodSetting.class);
    private static final Type TYPE_CUTOFF = TypeLibrary.createType(CutoffSetting.class);
    private final List<EventInstrumentation.SettingInfo> settingInfos = new ArrayList<EventInstrumentation.SettingInfo>();
    private final Map<String, Control> eventControls = new HashMap<String, Control>(5);
    private final PlatformEventType type;
    private final String idName;

    EventControl(PlatformEventType platformEventType) {
        this.eventControls.put("enabled", EventControl.defineEnabled(platformEventType));
        if (platformEventType.hasDuration()) {
            this.eventControls.put("threshold", EventControl.defineThreshold(platformEventType));
        }
        if (platformEventType.hasStackTrace()) {
            this.eventControls.put("stackTrace", EventControl.defineStackTrace(platformEventType));
        }
        if (platformEventType.hasPeriod()) {
            this.eventControls.put("period", EventControl.definePeriod(platformEventType));
        }
        if (platformEventType.hasCutoff()) {
            this.eventControls.put("cutoff", EventControl.defineCutoff(platformEventType));
        }
        ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>(platformEventType.getAnnotationElements());
        EventControl.remove(platformEventType, arrayList, Threshold.class);
        EventControl.remove(platformEventType, arrayList, Period.class);
        EventControl.remove(platformEventType, arrayList, Enabled.class);
        EventControl.remove(platformEventType, arrayList, StackTrace.class);
        EventControl.remove(platformEventType, arrayList, Cutoff.class);
        arrayList.trimToSize();
        platformEventType.setAnnotations(arrayList);
        this.type = platformEventType;
        this.idName = String.valueOf(platformEventType.getId());
    }

    static void remove(PlatformEventType platformEventType, List<AnnotationElement> list, Class<? extends Annotation> clazz) {
        long l = Type.getTypeId(clazz);
        for (AnnotationElement annotationElement : platformEventType.getAnnotationElements()) {
            if (annotationElement.getTypeId() != l || !annotationElement.getTypeName().equals(clazz.getName())) continue;
            list.remove(annotationElement);
        }
    }

    EventControl(PlatformEventType platformEventType, Class<? extends Event> clazz) {
        this(platformEventType);
        this.defineSettings(clazz);
    }

    private void defineSettings(Class<?> clazz) {
        boolean bl = true;
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                Class<?> clazz2;
                SettingDefinition settingDefinition;
                boolean bl2 = Modifier.isPrivate(method.getModifiers());
                if (method.getReturnType() != Boolean.TYPE || method.getParameterCount() != 1 || bl2 && !bl || (settingDefinition = method.getDeclaredAnnotation(SettingDefinition.class)) == null || Modifier.isAbstract((clazz2 = method.getParameters()[0].getType()).getModifiers()) || !SettingControl.class.isAssignableFrom(clazz2)) continue;
                String string = method.getName();
                Name name = method.getAnnotation(Name.class);
                if (name != null) {
                    string = name.value();
                }
                if (this.eventControls.containsKey(string)) continue;
                this.defineSetting(clazz2, method, this.type, string);
            }
            clazz = clazz.getSuperclass();
            bl = false;
        }
    }

    private void defineSetting(Class<? extends SettingControl> clazz, Method method, PlatformEventType platformEventType, String string) {
        try {
            int n = this.settingInfos.size();
            EventInstrumentation.SettingInfo settingInfo = new EventInstrumentation.SettingInfo(FIELD_SETTING_PREFIX + n, n);
            SettingControl settingControl = settingInfo.settingControl = this.instantiateSettingControl(clazz);
            settingControl.setDefault();
            String string2 = settingControl.getValueSafe();
            if (string2 != null) {
                Type type = TypeLibrary.createType(clazz);
                ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>();
                for (Annotation annotation : method.getDeclaredAnnotations()) {
                    AnnotationElement annotationElement = TypeLibrary.createAnnotation(annotation);
                    if (annotationElement == null) continue;
                    arrayList.add(annotationElement);
                }
                arrayList.trimToSize();
                this.eventControls.put(string, settingInfo.settingControl);
                platformEventType.add(PrivateAccess.getInstance().newSettingDescriptor(type, string, string2, arrayList));
                this.settingInfos.add(settingInfo);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError("Could not instantiate setting " + clazz.getName() + " for event " + platformEventType.getLogName() + ". " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError("Could not access setting " + clazz.getName() + " for event " + platformEventType.getLogName() + ". " + illegalAccessException.getMessage());
        }
    }

    private SettingControl instantiateSettingControl(Class<? extends SettingControl> clazz) throws IllegalAccessException, InstantiationException {
        Constructor<?> constructor;
        SecuritySupport.makeVisibleToJFR(clazz);
        try {
            constructor = clazz.getDeclaredConstructors()[0];
        }
        catch (Exception exception) {
            throw (Error)new InternalError("Could not get constructor for " + clazz.getName()).initCause(exception);
        }
        SecuritySupport.setAccessible(constructor);
        try {
            return (SettingControl)constructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | InvocationTargetException exception) {
            throw new InternalError("Could not instantiate setting for class " + clazz.getName());
        }
    }

    private static Control defineEnabled(PlatformEventType platformEventType) {
        String string;
        Enabled enabled = (Enabled)platformEventType.getAnnotation(Enabled.class);
        String string2 = string = platformEventType.isJVM() ? "false" : "true";
        if (enabled != null) {
            string = Boolean.toString(enabled.value());
        }
        platformEventType.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_ENABLED, "enabled", string, Collections.emptyList()));
        return new EnabledSetting(platformEventType, string);
    }

    private static Control defineThreshold(PlatformEventType platformEventType) {
        Threshold threshold = (Threshold)platformEventType.getAnnotation(Threshold.class);
        String string = "0 ns";
        if (threshold != null) {
            string = threshold.value();
        }
        platformEventType.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_THRESHOLD, "threshold", string, Collections.emptyList()));
        return new ThresholdSetting(platformEventType, string);
    }

    private static Control defineStackTrace(PlatformEventType platformEventType) {
        StackTrace stackTrace = (StackTrace)platformEventType.getAnnotation(StackTrace.class);
        String string = "true";
        if (stackTrace != null) {
            string = Boolean.toString(stackTrace.value());
        }
        platformEventType.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_STACK_TRACE, "stackTrace", string, Collections.emptyList()));
        return new StackTraceSetting(platformEventType, string);
    }

    private static Control defineCutoff(PlatformEventType platformEventType) {
        Cutoff cutoff = (Cutoff)platformEventType.getAnnotation(Cutoff.class);
        String string = "infinity";
        if (cutoff != null) {
            string = cutoff.value();
        }
        platformEventType.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_CUTOFF, "cutoff", string, Collections.emptyList()));
        return new CutoffSetting(platformEventType, string);
    }

    private static Control definePeriod(PlatformEventType platformEventType) {
        Period period = (Period)platformEventType.getAnnotation(Period.class);
        String string = "everyChunk";
        if (period != null) {
            string = period.value();
        }
        platformEventType.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_PERIOD, "period", string, Collections.emptyList()));
        return new PeriodSetting(platformEventType, string);
    }

    void disable() {
        for (Control control : this.eventControls.values()) {
            if (!(control instanceof EnabledSetting)) continue;
            control.setValueSafe("false");
            return;
        }
    }

    void writeActiveSettingEvent() {
        if (!this.type.isRegistered()) {
            return;
        }
        for (Map.Entry<String, Control> entry : this.eventControls.entrySet()) {
            Control control = entry.getValue();
            if (!Utils.isSettingVisible(control, this.type.hasEventHook())) continue;
            String string = control.getLastValue();
            if (string == null) {
                string = control.getDefaultValue();
            }
            ActiveSettingEvent activeSettingEvent = new ActiveSettingEvent();
            activeSettingEvent.id = this.type.getId();
            activeSettingEvent.name = entry.getKey();
            activeSettingEvent.value = string;
            activeSettingEvent.commit();
        }
    }

    public Set<Map.Entry<String, Control>> getEntries() {
        return this.eventControls.entrySet();
    }

    public PlatformEventType getEventType() {
        return this.type;
    }

    public String getSettingsId() {
        return this.idName;
    }

    public List<EventInstrumentation.SettingInfo> getSettingInfos() {
        return this.settingInfos;
    }
}

