/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.MachineDescriptionIntelX86;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.dummy.DummyDebugger;
import sun.jvm.hotspot.ui.Annotation;
import sun.jvm.hotspot.ui.GraphicsUtilities;
import sun.jvm.hotspot.ui.HighPrecisionJScrollBar;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.Interval;
import sun.jvm.hotspot.utilities.IntervalNode;
import sun.jvm.hotspot.utilities.IntervalTree;

public class AnnotatedMemoryPanel
extends JPanel {
    private boolean is64Bit;
    private Debugger debugger;
    private long addressSize;
    private HighPrecisionJScrollBar scrollBar;
    private Font font;
    private int bytesPerLine;
    private int paintCount;
    private String unmappedAddrString;
    private IntervalTree annotations = new IntervalTree(new Comparator(){

        public int compare(Object o1, Object o2) {
            Address a1 = (Address)o1;
            Address a2 = (Address)o2;
            if (a1 == null && a2 == null) {
                return 0;
            }
            if (a1 == null) {
                return -1;
            }
            if (a2 == null) {
                return 1;
            }
            if (a1.equals(a2)) {
                return 0;
            }
            if (a1.lessThan(a2)) {
                return -1;
            }
            return 1;
        }
    });
    private Address lastStartAddr;
    private List visibleAnnotations;
    private static Color[] colors = new Color[]{new Color(0.0f, 0.0f, 0.6f), new Color(0.6f, 0.0f, 0.6f), new Color(0.0f, 0.8f, 0.0f), new Color(0.8f, 0.3f, 0.0f), new Color(0.0f, 0.6f, 0.8f), new Color(0.2f, 0.2f, 0.2f)};

    public AnnotatedMemoryPanel(Debugger debugger) {
        this(debugger, false);
    }

    public AnnotatedMemoryPanel(Debugger debugger, boolean is64Bit, Address addrValue, Address addrLow, Address addrHigh) {
        this.init(debugger, is64Bit, this.addressToBigInt(addrValue), this.addressToBigInt(addrLow), this.addressToBigInt(addrHigh));
    }

    public AnnotatedMemoryPanel(Debugger debugger, boolean is64Bit) {
        this.init(debugger, is64Bit, AnnotatedMemoryPanel.defaultMemoryLocation(is64Bit), AnnotatedMemoryPanel.defaultMemoryLow(is64Bit), AnnotatedMemoryPanel.defaultMemoryHigh(is64Bit));
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        BigInteger offsetVal;
        BigInteger endVal;
        super.paintComponent(g);
        g = g.create();
        g.setFont(this.font);
        g.setColor(Color.black);
        Rectangle rect = new Rectangle();
        this.getBounds(rect);
        Object firstAddressString = null;
        Rectangle2D bounds = GraphicsUtilities.getStringBounds(this.unmappedAddrString, g);
        int lineHeight = (int)bounds.getHeight();
        int addrWidth = (int)bounds.getWidth();
        int addrX = (int)(0.25 * (double)addrWidth);
        int dataX = (int)((double)addrX + 1.5 * (double)addrWidth);
        int lineStartX = dataX + addrWidth + 5;
        int annoStartX = (int)((double)lineStartX + 0.75 * (double)addrWidth);
        int numLines = rect.height / lineHeight;
        BigInteger startVal = this.scrollBar.getValueHP();
        BigInteger perLine = new BigInteger(Integer.toString((int)this.addressSize));
        BigInteger lineCount = new BigInteger(Integer.toString(numLines - 1));
        BigInteger maxLines = this.scrollBar.getMaximumHP().subtract(this.scrollBar.getMinimumHP()).divide(perLine);
        if (lineCount.compareTo(maxLines) > 0) {
            lineCount = maxLines;
        }
        if ((endVal = startVal.add(offsetVal = lineCount.multiply(perLine))).compareTo(this.scrollBar.getMaximumHP()) > 0) {
            startVal = this.scrollBar.getMaximumHP().subtract(offsetVal);
            endVal = this.scrollBar.getMaximumHP();
            this.scrollBar.setValueHP(startVal);
        }
        this.scrollBar.setVisibleAmountHP(offsetVal.add(perLine));
        this.scrollBar.setBlockIncrementHP(offsetVal);
        Address startAddr = this.bigIntToAddress(startVal);
        Address endAddr = this.bigIntToAddress(endVal);
        int scrollOffset = 0;
        if (this.lastStartAddr != null) {
            scrollOffset = (int)this.lastStartAddr.minus(startAddr);
        } else if (startAddr != null) {
            scrollOffset = (int)(-1L * startAddr.minus(this.lastStartAddr));
        }
        scrollOffset = scrollOffset * lineHeight / (int)this.addressSize;
        this.scrollAnnotations(scrollOffset);
        this.lastStartAddr = startAddr;
        int curY = lineHeight;
        Address curAddr = startAddr;
        for (int i = 0; i < numLines; ++i) {
            String s = this.bigIntToHexString(startVal);
            g.drawString(s, addrX, curY);
            try {
                s = this.addressToString(startAddr.getAddressAt((long)i * this.addressSize));
            }
            catch (UnmappedAddressException e) {
                s = this.unmappedAddrString;
            }
            g.drawString(s, dataX, curY);
            curY += lineHeight;
            startVal = startVal.add(perLine);
        }
        List va = this.annotations.findAllNodesIntersecting(new Interval(startAddr.addOffsetTo(-this.addressSize), endAddr.addOffsetTo(2L * this.addressSize)));
        int curLineX = lineStartX;
        int curTextX = annoStartX;
        int curColorIdx = 0;
        if (g instanceof Graphics2D) {
            BasicStroke stroke = new BasicStroke(3.0f);
            ((Graphics2D)g).setStroke(stroke);
        }
        Stack<AnnoX> drawStack = new Stack<AnnoX>();
        this.layoutAnnotations(va, g, curTextX, startAddr, lineHeight);
        for (Annotation anno : this.visibleAnnotations) {
            Interval interval = anno.getInterval();
            if (!drawStack.empty()) {
                boolean shouldContinue = true;
                do {
                    AnnoX annoX = (AnnoX)drawStack.peek();
                    if (annoX.highBound.lessThanOrEqual((Address)interval.getLowEndpoint())) {
                        curLineX = annoX.lineX;
                        drawStack.pop();
                        shouldContinue = !drawStack.empty();
                        continue;
                    }
                    shouldContinue = false;
                } while (shouldContinue);
            }
            Address lineStartAddr = (Address)interval.getLowEndpoint();
            int lineStartY = (int)(lineStartAddr.minus(startAddr) * (long)lineHeight / this.addressSize) + lineHeight / 3;
            Address lineEndAddr = (Address)interval.getHighEndpoint();
            drawStack.push(new AnnoX(curLineX, lineEndAddr));
            int lineEndY = (int)(lineEndAddr.minus(startAddr) * (long)lineHeight / this.addressSize);
            g.setColor(anno.getColor());
            g.drawLine(curLineX, lineStartY, curLineX, lineEndY);
            g.drawLine(curLineX, lineStartY, curTextX - 10, anno.getY() - lineHeight / 2);
            curLineX += 8;
            anno.draw(g);
            ++curColorIdx;
        }
    }

    public synchronized void addAnnotation(Annotation annotation) {
        this.annotations.insert(annotation.getInterval(), annotation);
    }

    public synchronized void makeVisible(Address addr) {
        BigInteger bi = this.addressToBigInt(addr);
        this.scrollBar.setValueHP(bi);
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        this.annotations.printOn(tty);
    }

    private void init(Debugger debugger, boolean is64Bit, BigInteger addrValue, BigInteger addrLow, BigInteger addrHigh) {
        this.is64Bit = is64Bit;
        this.debugger = debugger;
        if (is64Bit) {
            this.addressSize = 8L;
            this.unmappedAddrString = "??????????????????";
        } else {
            this.addressSize = 4L;
            this.unmappedAddrString = "??????????";
        }
        this.setLayout(new BorderLayout());
        this.setupScrollBar(addrValue, addrLow, addrHigh);
        this.add((Component)this.scrollBar, "East");
        this.visibleAnnotations = new ArrayList();
        this.setBackground(Color.white);
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
            }
        });
        if (this.font == null) {
            this.font = GraphicsUtilities.lookupFont("Courier");
        }
        if (this.font == null) {
            throw new RuntimeException("Error looking up monospace font Courier");
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), "PageDown");
        this.getActionMap().put("PageDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotatedMemoryPanel.this.scrollBar.setValueHP(AnnotatedMemoryPanel.this.scrollBar.getValueHP().add(AnnotatedMemoryPanel.this.scrollBar.getBlockIncrementHP()));
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), "PageUp");
        this.getActionMap().put("PageUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotatedMemoryPanel.this.scrollBar.setValueHP(AnnotatedMemoryPanel.this.scrollBar.getValueHP().subtract(AnnotatedMemoryPanel.this.scrollBar.getBlockIncrementHP()));
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(40, 0), "Down");
        this.getActionMap().put("Down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotatedMemoryPanel.this.scrollBar.setValueHP(AnnotatedMemoryPanel.this.scrollBar.getValueHP().add(AnnotatedMemoryPanel.this.scrollBar.getUnitIncrementHP()));
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 0), "Up");
        this.getActionMap().put("Up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotatedMemoryPanel.this.scrollBar.setValueHP(AnnotatedMemoryPanel.this.scrollBar.getValueHP().subtract(AnnotatedMemoryPanel.this.scrollBar.getUnitIncrementHP()));
            }
        });
        this.setEnabled(true);
    }

    private void setupScrollBar(BigInteger value, BigInteger min, BigInteger max) {
        this.scrollBar = new HighPrecisionJScrollBar(1, value, min, max);
        if (this.is64Bit) {
            this.bytesPerLine = 8;
            this.scrollBar.setUnitIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 8}));
            this.scrollBar.setBlockIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 64}));
        } else {
            this.bytesPerLine = 4;
            this.scrollBar.setUnitIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 4}));
            this.scrollBar.setBlockIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 32}));
        }
        this.scrollBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HighPrecisionJScrollBar h = (HighPrecisionJScrollBar)e.getSource();
                AnnotatedMemoryPanel.this.repaint();
            }
        });
    }

    private static BigInteger defaultMemoryLocation(boolean is64Bit) {
        if (is64Bit) {
            return new BigInteger(1, new byte[]{-128, 0, 0, 0, 0, 0, 0, 0});
        }
        return new BigInteger(1, new byte[]{-128, 0, 0, 0});
    }

    private static BigInteger defaultMemoryLow(boolean is64Bit) {
        if (is64Bit) {
            return new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        }
        return new BigInteger(1, new byte[]{0, 0, 0, 0});
    }

    private static BigInteger defaultMemoryHigh(boolean is64Bit) {
        if (is64Bit) {
            return new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -4});
        }
        return new BigInteger(1, new byte[]{-1, -1, -1, -4});
    }

    private void setupScrollBar() {
        this.setupScrollBar(AnnotatedMemoryPanel.defaultMemoryLocation(this.is64Bit), AnnotatedMemoryPanel.defaultMemoryLow(this.is64Bit), AnnotatedMemoryPanel.defaultMemoryHigh(this.is64Bit));
    }

    private String bigIntToHexString(BigInteger bi) {
        StringBuffer buf = new StringBuffer();
        buf.append("0x");
        String val = bi.toString(16);
        int i = 0;
        while ((long)i < 2L * this.addressSize - (long)val.length()) {
            buf.append('0');
            ++i;
        }
        buf.append(val);
        return buf.toString();
    }

    private Address bigIntToAddress(BigInteger i) {
        String s = this.bigIntToHexString(i);
        return this.debugger.parseAddress(s);
    }

    private BigInteger addressToBigInt(Address a) {
        String s = this.addressToString(a);
        if (!s.startsWith("0x")) {
            throw new NumberFormatException(s);
        }
        return new BigInteger(s.substring(2), 16);
    }

    private String addressToString(Address a) {
        if (a == null) {
            if (this.is64Bit) {
                return "0x0000000000000000";
            }
            return "0x00000000";
        }
        return a.toString();
    }

    private void scrollAnnotations(int y) {
        for (Annotation anno : this.visibleAnnotations) {
            anno.setY(anno.getY() + y);
        }
    }

    private void layoutAnnotations(List va, Graphics g, int x, Address startAddr, int lineHeight) {
        Annotation anno2;
        if (va.size() == 0) {
            this.visibleAnnotations.clear();
            return;
        }
        int deferredIndex = -1;
        Annotation constraintAnnotation = null;
        Annotation firstConstraintAnnotation = null;
        int searchIndex = 0;
        ArrayList<Annotation> newAnnos = new ArrayList<Annotation>();
        Iterator iter = va.iterator();
        while (iter.hasNext()) {
            Annotation el;
            anno2 = (Annotation)((IntervalNode)iter.next()).getData();
            boolean found = false;
            for (int i = searchIndex; i < this.visibleAnnotations.size() && !(el = (Annotation)this.visibleAnnotations.get(i)).getLowAddress().greaterThan(anno2.getLowAddress()); ++i) {
                if (el != anno2) continue;
                found = true;
                searchIndex = i;
                constraintAnnotation = anno2;
                if (firstConstraintAnnotation != null) break;
                firstConstraintAnnotation = constraintAnnotation;
                break;
            }
            if (!found) {
                if (constraintAnnotation != null) {
                    this.layoutAfter(anno2, constraintAnnotation, g, x, startAddr, lineHeight);
                    constraintAnnotation = anno2;
                } else {
                    ++deferredIndex;
                }
            }
            newAnnos.add(anno2);
        }
        if (firstConstraintAnnotation != null) {
            for (int i = deferredIndex; i >= 0; --i) {
                anno2 = (Annotation)newAnnos.get(i);
                this.layoutBefore(anno2, firstConstraintAnnotation, g, x, startAddr, lineHeight);
                firstConstraintAnnotation = anno2;
            }
        } else {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(constraintAnnotation == null, "logic error in layout code");
            }
            for (Annotation anno2 : newAnnos) {
                this.layoutAfter(anno2, constraintAnnotation, g, x, startAddr, lineHeight);
                constraintAnnotation = anno2;
            }
        }
        this.visibleAnnotations = newAnnos;
    }

    private void layoutBefore(Annotation anno, Annotation constraintAnno, Graphics g, int x, Address startAddr, int lineHeight) {
        anno.computeWidthAndHeight(g);
        if (constraintAnno != null) {
            anno.setColor(this.prevColor(constraintAnno.getColor()));
        } else {
            anno.setColor(colors[0]);
        }
        anno.setX(x);
        anno.setY((int)(((Address)anno.getInterval().getLowEndpoint()).minus(startAddr) * (long)lineHeight / this.addressSize) + 5 * lineHeight / 6);
        if (constraintAnno != null && anno.getY() + anno.getHeight() > constraintAnno.getY()) {
            anno.setY(constraintAnno.getY() - anno.getHeight());
        }
    }

    private void layoutAfter(Annotation anno, Annotation constraintAnno, Graphics g, int x, Address startAddr, int lineHeight) {
        anno.computeWidthAndHeight(g);
        if (constraintAnno != null) {
            anno.setColor(this.nextColor(constraintAnno.getColor()));
        } else {
            anno.setColor(colors[0]);
        }
        anno.setX(x);
        anno.setY((int)(((Address)anno.getInterval().getLowEndpoint()).minus(startAddr) * (long)lineHeight / this.addressSize) + 5 * lineHeight / 6);
        if (constraintAnno != null && anno.getY() < constraintAnno.getY() + constraintAnno.getHeight()) {
            anno.setY(constraintAnno.getY() + constraintAnno.getHeight());
        }
    }

    private Color prevColor(Color c) {
        int i = this.findColorIndex(c);
        if (i == 0) {
            return colors[colors.length - 1];
        }
        return colors[i - 1];
    }

    private Color nextColor(Color c) {
        return colors[(this.findColorIndex(c) + 1) % colors.length];
    }

    private int findColorIndex(Color c) {
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] != c) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        DummyDebugger debugger = new DummyDebugger(new MachineDescriptionIntelX86());
        AnnotatedMemoryPanel anno = new AnnotatedMemoryPanel(debugger);
        frame.getContentPane().add(anno);
        anno.addAnnotation(new Annotation(debugger.parseAddress("0x80000000"), debugger.parseAddress("0x80000040"), "Stack Frame for \"foo\""));
        anno.addAnnotation(new Annotation(debugger.parseAddress("0x80000010"), debugger.parseAddress("0x80000020"), "Locals for \"foo\""));
        anno.addAnnotation(new Annotation(debugger.parseAddress("0x80000020"), debugger.parseAddress("0x80000030"), "Expression stack for \"foo\""));
        frame.setSize(400, 300);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    static class AnnoX {
        int lineX;
        Address highBound;

        public AnnoX(int lineX, Address highBound) {
            this.lineX = lineX;
            this.highBound = highBound;
        }
    }
}

