/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Certificate;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509CertificateResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(X509CertificateResolver.class);

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            Element[] elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509Certificate");
            if (elementArray == null || elementArray.length == 0) {
                Element element2 = XMLUtils.selectDsNode(element.getFirstChild(), "X509Data", 0);
                if (element2 != null) {
                    return this.engineLookupResolveX509Certificate(element2, string, storageResolver);
                }
                return null;
            }
            for (int i = 0; i < elementArray.length; ++i) {
                XMLX509Certificate xMLX509Certificate = new XMLX509Certificate(elementArray[i], string);
                X509Certificate x509Certificate = xMLX509Certificate.getX509Certificate();
                if (x509Certificate == null) continue;
                return x509Certificate;
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug("Security Exception", xMLSecurityException);
            throw new KeyResolverException(xMLSecurityException);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

