/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    protected String attrID;
    protected transient Vector<Object> values;
    protected boolean ordered = false;
    private static final long serialVersionUID = 6743528196119291326L;

    @Override
    public Object clone() {
        BasicAttribute basicAttribute;
        try {
            basicAttribute = (BasicAttribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            basicAttribute = new BasicAttribute(this.attrID, this.ordered);
        }
        basicAttribute.values = (Vector)this.values.clone();
        return basicAttribute;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Attribute) {
            int n;
            Attribute attribute = (Attribute)object;
            if (this.isOrdered() != attribute.isOrdered()) {
                return false;
            }
            if (this.attrID.equals(attribute.getID()) && (n = this.size()) == attribute.size()) {
                try {
                    if (this.isOrdered()) {
                        for (int i = 0; i < n; ++i) {
                            if (BasicAttribute.valueEquals(this.get(i), attribute.get(i))) continue;
                            return false;
                        }
                    } else {
                        NamingEnumeration<?> namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            if (this.find(namingEnumeration.nextElement()) >= 0) continue;
                            return false;
                        }
                    }
                }
                catch (NamingException namingException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.attrID.hashCode();
        int n2 = this.values.size();
        for (int i = 0; i < n2; ++i) {
            Object object = this.values.elementAt(i);
            if (object == null) continue;
            if (object.getClass().isArray()) {
                int n3 = Array.getLength(object);
                for (int j = 0; j < n3; ++j) {
                    Object object2 = Array.get(object, j);
                    if (object2 == null) continue;
                    n += object2.hashCode();
                }
                continue;
            }
            n += object.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.attrID + ": ");
        if (this.values.size() == 0) {
            stringBuffer.append("No values");
        } else {
            boolean bl = true;
            Enumeration<Object> enumeration = this.values.elements();
            while (enumeration.hasMoreElements()) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(enumeration.nextElement());
                bl = false;
            }
        }
        return stringBuffer.toString();
    }

    public BasicAttribute(String string) {
        this(string, false);
    }

    public BasicAttribute(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttribute(String string, boolean bl) {
        this.attrID = string;
        this.values = new Vector();
        this.ordered = bl;
    }

    public BasicAttribute(String string, Object object, boolean bl) {
        this(string, bl);
        this.values.addElement(object);
    }

    @Override
    public NamingEnumeration<?> getAll() throws NamingException {
        return new ValuesEnumImpl();
    }

    @Override
    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("Attribute " + this.getID() + " has no value");
        }
        return this.values.elementAt(0);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String getID() {
        return this.attrID;
    }

    @Override
    public boolean contains(Object object) {
        return this.find(object) >= 0;
    }

    private int find(Object object) {
        if (object == null) {
            int n = this.values.size();
            for (int i = 0; i < n; ++i) {
                if (this.values.elementAt(i) != null) continue;
                return i;
            }
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = this.values.size();
                for (int i = 0; i < n; ++i) {
                    Object object2 = this.values.elementAt(i);
                    if (object2 == null || clazz != object2.getClass() || !BasicAttribute.arrayEquals(object, object2)) continue;
                    return i;
                }
            } else {
                return this.values.indexOf(object, 0);
            }
        }
        return -1;
    }

    private static boolean valueEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            return BasicAttribute.arrayEquals(object, object2);
        }
        return object.equals(object2);
    }

    private static boolean arrayEquals(Object object, Object object2) {
        int n = Array.getLength(object);
        if (n != Array.getLength(object2)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object3 = Array.get(object, i);
            Object object4 = Array.get(object2, i);
            if (!(object3 == null || object4 == null ? object3 != object4 : !object3.equals(object4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Object object) {
        if (this.isOrdered() || this.find(object) < 0) {
            this.values.addElement(object);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.find(object);
        if (n >= 0) {
            this.values.removeElementAt(n);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.values.setSize(0);
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Object get(int n) throws NamingException {
        return this.values.elementAt(n);
    }

    @Override
    public Object remove(int n) {
        Object object = this.values.elementAt(n);
        this.values.removeElementAt(n);
        return object;
    }

    @Override
    public void add(int n, Object object) {
        if (!this.isOrdered() && this.contains(object)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        this.values.insertElementAt(object, n);
    }

    @Override
    public Object set(int n, Object object) {
        if (!this.isOrdered() && this.contains(object)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        Object object2 = this.values.elementAt(n);
        this.values.setElementAt(object, n);
        return object2;
    }

    @Override
    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute syntax");
    }

    @Override
    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute definition");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            objectOutputStream.writeObject(this.values.elementAt(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.values = new Vector(Math.min(1024, n));
        while (--n >= 0) {
            this.values.addElement(objectInputStream.readObject());
        }
    }

    class ValuesEnumImpl
    implements NamingEnumeration<Object> {
        Enumeration<Object> list;

        ValuesEnumImpl() {
            this.list = BasicAttribute.this.values.elements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.list.hasMoreElements();
        }

        @Override
        public Object nextElement() {
            return this.list.nextElement();
        }

        @Override
        public Object next() throws NamingException {
            return this.list.nextElement();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.list.hasMoreElements();
        }

        @Override
        public void close() throws NamingException {
            this.list = null;
        }
    }
}

