/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.oa.toa;

import com.sun.corba.se.impl.oa.toa.Element;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.orb.ORB;

public final class TransientObjectManager {
    private ORB orb;
    private int maxSize = 128;
    private Element[] elementArray;
    private Element freeList;

    void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public TransientObjectManager(ORB oRB) {
        this.orb = oRB;
        this.elementArray = new Element[this.maxSize];
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (int i = this.maxSize - 2; i >= 0; --i) {
            this.elementArray[i] = new Element(i, this.elementArray[i + 1]);
        }
        this.freeList = this.elementArray[0];
    }

    public synchronized byte[] storeServant(Object object, Object object2) {
        if (this.freeList == null) {
            this.doubleSize();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        byte[] byArray = element.getKey(object, object2);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("storeServant returns key for element " + element);
        }
        return byArray;
    }

    public synchronized Object lookupServant(byte[] byArray) {
        int n = ORBUtility.bytesToInt(byArray, 0);
        int n2 = ORBUtility.bytesToInt(byArray, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServant called with index=" + n + ", counter=" + n2);
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[n].servant;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    public synchronized Object lookupServantData(byte[] byArray) {
        int n = ORBUtility.bytesToInt(byArray, 0);
        int n2 = ORBUtility.bytesToInt(byArray, 4);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("lookupServantData called with index=" + n + ", counter=" + n2);
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            if (this.orb.transientObjectManagerDebugFlag) {
                this.dprint("\tcounter is valid");
            }
            return this.elementArray[n].servantData;
        }
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("\tcounter is invalid");
        }
        return null;
    }

    public synchronized void deleteServant(byte[] byArray) {
        int n = ORBUtility.bytesToInt(byArray, 0);
        if (this.orb.transientObjectManagerDebugFlag) {
            this.dprint("deleting servant at index=" + n);
        }
        this.elementArray[n].delete(this.freeList);
        this.freeList = this.elementArray[n];
    }

    public synchronized byte[] getKey(Object object) {
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.elementArray[i].valid || this.elementArray[i].servant != object) continue;
            return this.elementArray[i].toBytes();
        }
        return null;
    }

    private void doubleSize() {
        int n;
        Element[] elementArray = this.elementArray;
        int n2 = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        for (n = 0; n < n2; ++n) {
            this.elementArray[n] = elementArray[n];
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        for (n = this.maxSize - 2; n >= n2; --n) {
            this.elementArray[n] = new Element(n, this.elementArray[n + 1]);
        }
        this.freeList = this.elementArray[n2];
    }
}

