"use strict";
/*********************************************************************
 * Copyright (c) 2020 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.File = void 0;
const fs = require("fs");
const stream_1 = require("stream");
class File {
    get reader() {
        return this._duplex;
    }
    get writer() {
        return this._duplex;
    }
    constructor(fd) {
        this.fd = fd;
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        const _this = this;
        this._duplex = new stream_1.Duplex({
            read(size) {
                fs.read(fd, Buffer.alloc(size), 0, size, null, (err, bytesRead, buffer) => {
                    if (err) {
                        console.error(fd, err.message);
                        this.push(null);
                    }
                    else {
                        this.push(buffer.slice(0, bytesRead));
                    }
                });
            },
            write(chunk, encoding, callback) {
                const buffer = Buffer.isBuffer(chunk)
                    ? chunk
                    : Buffer.from(chunk, encoding);
                fs.write(fd, buffer, (err, _written, _buffer) => {
                    callback(err);
                });
            },
            destroy(err, callback) {
                fs.close(fd, callback);
                _this.fd = -1;
            },
        });
    }
    destroy() {
        this._duplex.destroy();
    }
}
exports.File = File;
//# sourceMappingURL=file.js.map