"use strict";
/*********************************************************************
 * Copyright (c) 2018 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const path = require("path");
const utils_1 = require("./utils");
const utils_2 = require("./utils");
// import { DebugProtocol } from '@vscode/debugprotocol';
describe('launch', function () {
    let dc;
    const emptyProgram1 = path.join(utils_1.testProgramsDir, 'empty1');
    const emptySrc1 = path.join(utils_1.testProgramsDir, 'empty1.c');
    const lineTags1 = {
        'STOP HERE': 0,
    };
    const emptyProgram2 = path.join(utils_1.testProgramsDir, 'empty2');
    const emptySrc2 = path.join(utils_1.testProgramsDir, 'empty2.c');
    const lineTags2 = {
        'STOP HERE': 0,
    };
    // const emptySpaceProgram = path.join(testProgramsDir, 'empty space');
    // const emptySpaceSrc = path.join(testProgramsDir, 'empty space.c');
    before(function () {
        (0, utils_1.resolveLineTagLocations)(emptySrc1, lineTags1);
        (0, utils_1.resolveLineTagLocations)(emptySrc2, lineTags2);
    });
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            dc = yield (0, utils_1.standardBeforeEach)();
        });
    });
    afterEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield dc.stop();
        });
    });
    // Move the timeout out of the way if the adapter is going to be debugged.
    if (process.env.INSPECT_DEBUG_ADAPTER) {
        this.timeout(9999999);
    }
    it('can launch and hit a breakpoint', function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield dc.hitBreakpoint({
                verbose: true,
                logFile: '/tmp/log/amalgamator.log',
                children: [
                    {
                        name: 'proc1',
                        debugAdapterRuntime: 'node',
                        debugAdapterExecutable: path.resolve(__dirname, '../../node_modules/cdt-gdb-adapter/dist/debugAdapter.js'),
                        arguments: {
                            verbose: true,
                            logFile: '/tmp/log/child1.log',
                            gdb: utils_2.gdbPath,
                            program: emptyProgram1,
                            openGdbConsole: utils_2.openGdbConsole,
                        },
                    },
                ],
            }, {
                path: emptySrc1,
                line: lineTags1['STOP HERE'],
            });
        });
    });
    it('can launch two children and hit a breakpoint', function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield dc.hitBreakpoints({
                verbose: true,
                logFile: '/tmp/log/amalgamator.log',
                children: [
                    {
                        name: 'proc1',
                        debugAdapterRuntime: 'node',
                        debugAdapterExecutable: path.resolve(__dirname, '../../node_modules/cdt-gdb-adapter/dist/debugAdapter.js'),
                        arguments: {
                            verbose: true,
                            logFile: '/tmp/log/child1.log',
                            gdb: utils_2.gdbPath,
                            program: emptyProgram1,
                            openGdbConsole: utils_2.openGdbConsole,
                        },
                    },
                    {
                        name: 'proc2',
                        debugAdapterRuntime: 'node',
                        debugAdapterExecutable: path.resolve(__dirname, '../../node_modules/cdt-gdb-adapter/dist/debugAdapter.js'),
                        arguments: {
                            verbose: true,
                            logFile: '/tmp/log/child2.log',
                            gdb: utils_2.gdbPath,
                            program: emptyProgram2,
                            openGdbConsole: utils_2.openGdbConsole,
                        },
                    },
                ],
            }, [
                {
                    path: emptySrc1,
                    line: lineTags1['STOP HERE'],
                },
                {
                    path: emptySrc2,
                    line: lineTags2['STOP HERE'],
                },
            ]);
        });
    });
    it('reports an error when child launch fails', function () {
        return __awaiter(this, void 0, void 0, function* () {
            const errorMessage = yield new Promise((resolve, reject) => {
                dc.launchRequest({
                    verbose: true,
                    logFile: '/tmp/log/amalgamator.log',
                    children: [
                        {
                            name: 'proc1',
                            debugAdapterRuntime: 'node',
                            debugAdapterExecutable: path.resolve(__dirname, '../../node_modules/cdt-gdb-adapter/dist/debugAdapter.js'),
                            arguments: {
                                verbose: false,
                                logFile: '/tmp/log/child1.log',
                                gdb: utils_2.gdbPath,
                                program: '/does/not/exist',
                                openGdbConsole: utils_2.openGdbConsole,
                            },
                        },
                    ],
                })
                    .then(reject)
                    .catch(resolve);
            });
            // When launching a remote test gdbserver generates the error which is not exactly the same
            // as GDB's error
            (0, chai_1.expect)(errorMessage.message).to.satisfy((msg) => msg.includes('/does/not/exist') &&
                (msg.includes('The system cannot find the path specified') ||
                    msg.includes('No such file or directory') ||
                    msg.includes('not found')));
        });
    });
    it('reports an error when child debug adapter fails to load - missing module', function () {
        return __awaiter(this, void 0, void 0, function* () {
            // TODO: This test fails because we use vscode-debugadapter-node/testSupport/src/debugClient.ts::start to start
            // the server and that doesn't really handle this case so we'll need something local
            const errorMessage = yield new Promise((resolve, reject) => {
                dc.launchRequest({
                    verbose: true,
                    logFile: '/tmp/log/amalgamator.log',
                    children: [
                        {
                            name: 'proc1',
                            debugAdapterRuntime: 'node',
                            debugAdapterExecutable: path.resolve(__dirname, '../../node_modules/cdt-gdb-adapter/dist/does/not/exist'),
                            arguments: {
                                verbose: false,
                                logFile: '/tmp/log/child1.log',
                                gdb: utils_2.gdbPath,
                                program: emptyProgram1,
                                openGdbConsole: utils_2.openGdbConsole,
                            },
                        },
                    ],
                })
                    .then(reject)
                    .catch(resolve);
            });
            // The specific error message isn't very important and subject
            // to change.
            (0, chai_1.expect)(errorMessage.message).to.contain('Child debug adapter exited');
            // There should be some kind of indication in the error message related back to the
            // failed launch
            (0, chai_1.expect)(errorMessage.message).to.contain('does/not/exist');
        });
    });
});
//# sourceMappingURL=launch.spec.js.map