import { IGDBBackend } from './types/gdb';
import { MIVarCreateResponse } from './mi/var';
export interface VarObjType {
    varname: string;
    expression: string;
    numchild: string;
    children: VarObjType[];
    value: string;
    type: string;
    isVar: boolean;
    isChild: boolean;
    varType: string;
}
export declare class VarManager {
    protected gdb: IGDBBackend;
    protected readonly variableMap: Map<string, VarObjType[]>;
    constructor(gdb: IGDBBackend);
    getKey(frameId: number, threadId: number, depth: number): string;
    getVars(frameId: number, threadId: number, depth: number): VarObjType[] | undefined;
    getVar(frameId: number, threadId: number, depth: number, expression: string, type?: string): VarObjType | undefined;
    getVarByName(frameId: number, threadId: number, depth: number, varname: string): VarObjType | undefined;
    addVar(frameId: number, threadId: number, depth: number, expression: string, isVar: boolean, isChild: boolean, varCreateResponse: MIVarCreateResponse, type?: string): VarObjType;
    removeVar(frameId: number, threadId: number, depth: number, varname: string): Promise<void>;
    updateVar(frameId: number, threadId: number, depth: number, varobj: VarObjType): Promise<VarObjType>;
}
