"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-scanoss_lib_browser_ai-scanoss-frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-code-scan-action.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-code-scan-action.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScanOSSDialog = exports.ScanOSSScanButtonAction = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// ***
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const scanoss_1 = __webpack_require__(/*! @theia/scanoss */ "../../node_modules/@theia/scanoss/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const react_dialog_1 = __webpack_require__(/*! @theia/core/lib/browser/dialogs/react-dialog */ "../../node_modules/@theia/core/lib/browser/dialogs/react-dialog.js");
const scanoss_preferences_1 = __webpack_require__(/*! @theia/scanoss/lib/browser/scanoss-preferences */ "../../node_modules/@theia/scanoss/lib/browser/scanoss-preferences.js");
const ai_scanoss_preferences_1 = __webpack_require__(/*! ./ai-scanoss-preferences */ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-preferences.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
function hasScanOSSResults(data) {
    return 'scanOSSResults' in data && data.scanOSSResults instanceof Map;
}
let ScanOSSScanButtonAction = class ScanOSSScanButtonAction {
    constructor() {
        this.priority = 0;
    }
    canRender(response, parentNode) {
        if (!hasScanOSSResults(parentNode.response.data)) {
            parentNode.response.data.scanOSSResults = new Map();
        }
        const results = parentNode.response.data
            .scanOSSResults;
        const scanOSSMode = this.preferenceService.get(ai_scanoss_preferences_1.SCANOSS_MODE_PREF, 'off');
        // we mark the code for manual scanning in case it was not handled yet and the mode is manual or off.
        // this prevents a possibly unexpected automatic scan of "old" snippets if automatic scan is later turned on.
        if (results.get(response.code) === undefined && (scanOSSMode === 'off' || scanOSSMode === 'manual')) {
            results.set(response.code, false);
        }
        return scanOSSMode !== 'off';
    }
    render(response, parentNode) {
        const scanOSSResults = parentNode.response.data
            .scanOSSResults;
        return (React.createElement(ScanOSSIntegration, { key: 'scanoss', code: response.code, scanService: this.scanService, scanOSSResults: scanOSSResults, preferenceService: this.preferenceService }));
    }
};
exports.ScanOSSScanButtonAction = ScanOSSScanButtonAction;
tslib_1.__decorate([
    (0, inversify_1.inject)(scanoss_1.ScanOSSService),
    tslib_1.__metadata("design:type", Object)
], ScanOSSScanButtonAction.prototype, "scanService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], ScanOSSScanButtonAction.prototype, "preferenceService", void 0);
exports.ScanOSSScanButtonAction = ScanOSSScanButtonAction = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ScanOSSScanButtonAction);
const ScanOSSIntegration = React.memo((props) => {
    const [automaticCheck] = React.useState(() => props.preferenceService.get(ai_scanoss_preferences_1.SCANOSS_MODE_PREF, 'off') === 'automatic');
    const [scanOSSResult, setScanOSSResult] = React.useState(props.scanOSSResults.get(props.code));
    const scanCode = React.useCallback(async () => {
        setScanOSSResult('pending');
        const result = await props.scanService.scanContent(props.code, props.preferenceService.get(scanoss_preferences_1.SCAN_OSS_API_KEY_PREF, undefined));
        setScanOSSResult(result);
        props.scanOSSResults.set(props.code, result);
        return result;
    }, [props.code, props.scanService]);
    React.useEffect(() => {
        if (scanOSSResult === undefined) {
            if (automaticCheck) {
                scanCode();
            }
            else {
                // sanity fallback. This codepath should already be handled via "canRender"
                props.scanOSSResults.set(props.code, false);
            }
        }
    }, []);
    const scanOSSClicked = React.useCallback(async () => {
        let scanResult = scanOSSResult;
        if (scanResult === 'pending') {
            return;
        }
        if (!scanResult || scanResult.type === 'error') {
            scanResult = await scanCode();
        }
        if (scanResult && scanResult.type === 'match') {
            const dialog = new ScanOSSDialog([scanResult]);
            dialog.open();
        }
    }, [scanOSSResult]);
    let title = 'SCANOSS - Perform scan';
    if (scanOSSResult) {
        if (scanOSSResult === 'pending') {
            title = core_1.nls.localize('theia/ai/scanoss/snippet/in-progress', 'SCANOSS - Performing scan...');
        }
        else if (scanOSSResult.type === 'error') {
            title = core_1.nls.localize('theia/ai/scanoss/snippet/errored', 'SCANOSS - Error - {0}', scanOSSResult.message);
        }
        else if (scanOSSResult.type === 'match') {
            title = core_1.nls.localize('theia/ai/scanoss/snippet/matched', 'SCANOSS - Found {0} match', scanOSSResult.matched);
        }
        else if (scanOSSResult.type === 'clean') {
            title = core_1.nls.localize('theia/ai/scanoss/snippet/no-match', 'SCANOSS - No match');
        }
    }
    return (React.createElement("div", { className: `button scanoss-icon icon-container ${scanOSSResult === 'pending'
            ? 'pending'
            : scanOSSResult
                ? scanOSSResult.type
                : ''}`, title: title, role: "button", onClick: scanOSSClicked }, scanOSSResult && scanOSSResult !== 'pending' && (React.createElement("span", { className: "status-icon" },
        scanOSSResult.type === 'clean' && React.createElement("span", { className: "codicon codicon-pass-filled" }),
        scanOSSResult.type === 'match' && React.createElement("span", { className: "codicon codicon-warning" }),
        scanOSSResult.type === 'error' && React.createElement("span", { className: "codicon codicon-error" })))));
});
class ScanOSSDialog extends react_dialog_1.ReactDialog {
    constructor(results) {
        super({
            title: core_1.nls.localize('theia/ai/scanoss/snippet/dialog-header', 'ScanOSS Results'),
        });
        this.results = results;
        this.appendAcceptButton(browser_1.Dialog.OK);
        this.update();
    }
    render() {
        return (React.createElement("div", { className: "scanoss-dialog-container" },
            this.renderHeader(),
            this.renderSummary(),
            this.renderContent()));
    }
    renderHeader() {
        return (React.createElement("div", { className: "scanoss-header" },
            React.createElement("div", { className: "scanoss-icon-container" },
                React.createElement("div", { className: "scanoss-icon" }),
                React.createElement("h2", null, "SCANOSS"))));
    }
    renderSummary() {
        return (React.createElement("div", { className: "scanoss-summary" },
            React.createElement("h3", null, core_1.nls.localize('theia/ai/scanoss/snippet/summary', 'Summary')),
            React.createElement("div", null, core_1.nls.localize('theia/ai/scanoss/snippet/match-count', 'Found {0} match(es)', this.results.length))));
    }
    renderContent() {
        return (React.createElement("div", { className: "scanoss-details" },
            React.createElement("h4", null, core_1.nls.localizeByDefault('Details')),
            this.results.map(result => React.createElement("div", { key: result.matched },
                result.file && React.createElement("h4", null, core_1.nls.localize('theia/ai/scanoss/snippet/file-name-heading', 'Match found in {0}', result.file)),
                React.createElement("a", { href: result.url, target: "_blank", rel: "noopener noreferrer" }, result.url),
                React.createElement("pre", null, JSON.stringify(result.raw, undefined, 2))))));
    }
    get value() {
        return undefined;
    }
}
exports.ScanOSSDialog = ScanOSSDialog;


/***/ }),

/***/ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-frontend-module.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-frontend-module.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
__webpack_require__(/*! ../../src/browser/style/index.css */ "../../node_modules/@theia/ai-scanoss/src/browser/style/index.css");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_scanoss_preferences_1 = __webpack_require__(/*! ./ai-scanoss-preferences */ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-preferences.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const ai_scanoss_code_scan_action_1 = __webpack_require__(/*! ./ai-scanoss-code-scan-action */ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-code-scan-action.js");
const chat_response_renderer_1 = __webpack_require__(/*! @theia/ai-chat-ui/lib/browser/chat-response-renderer */ "../../node_modules/@theia/ai-chat-ui/lib/browser/chat-response-renderer/index.js");
const change_set_action_service_1 = __webpack_require__(/*! @theia/ai-chat-ui/lib/browser/change-set-actions/change-set-action-service */ "../../node_modules/@theia/ai-chat-ui/lib/browser/change-set-actions/change-set-action-service.js");
const change_set_scan_action_1 = __webpack_require__(/*! ./change-set-scan-action/change-set-scan-action */ "../../node_modules/@theia/ai-scanoss/lib/browser/change-set-scan-action/change-set-scan-action.js");
const change_set_decorator_service_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/change-set-decorator-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-decorator-service.js");
const change_set_scan_decorator_1 = __webpack_require__(/*! ./change-set-scan-action/change-set-scan-decorator */ "../../node_modules/@theia/ai-scanoss/lib/browser/change-set-scan-action/change-set-scan-decorator.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: ai_scanoss_preferences_1.AIScanOSSPreferencesSchema });
    bind(ai_scanoss_code_scan_action_1.ScanOSSScanButtonAction).toSelf().inSingletonScope();
    bind(chat_response_renderer_1.CodePartRendererAction).toService(ai_scanoss_code_scan_action_1.ScanOSSScanButtonAction);
    bind(change_set_scan_action_1.ChangeSetScanActionRenderer).toSelf();
    bind(change_set_action_service_1.ChangeSetActionRenderer).toService(change_set_scan_action_1.ChangeSetScanActionRenderer);
    bind(change_set_scan_decorator_1.ChangeSetScanDecorator).toSelf().inSingletonScope();
    bind(change_set_decorator_service_1.ChangeSetDecorator).toService(change_set_scan_decorator_1.ChangeSetScanDecorator);
});


/***/ }),

/***/ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-preferences.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-preferences.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIScanOSSPreferencesSchema = exports.SCANOSS_MODE_PREF = void 0;
const ai_core_preferences_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/ai-core-preferences */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.SCANOSS_MODE_PREF = 'ai-features.SCANOSS.mode';
exports.AIScanOSSPreferencesSchema = {
    type: 'object',
    properties: {
        [exports.SCANOSS_MODE_PREF]: {
            type: 'string',
            enum: ['off', 'manual', 'automatic'],
            markdownEnumDescriptions: [
                core_1.nls.localize('theia/ai/scanoss/mode/off/description', 'Feature is turned off completely.'),
                core_1.nls.localize('theia/ai/scanoss/mode/manual/description', 'User can manually trigger the scan by clicking the SCANOSS item in the chat view.'),
                core_1.nls.localize('theia/ai/scanoss/mode/automatic/description', 'Enable automatic scan of code snippets in chat views.')
            ],
            markdownDescription: core_1.nls.localize('theia/ai/scanoss/mode/description', 'Configure the SCANOSS feature for analyzing code snippets in chat views. This will send a hash of suggested code snippets to the SCANOSS\n\
service hosted by the [Software Transparency foundation](https://www.softwaretransparency.org/osskb) for analysis.'),
            default: 'off',
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-scanoss/lib/browser/change-set-scan-action/change-set-scan-action.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/lib/browser/change-set-scan-action/change-set-scan-action.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSetScanActionRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
const scanoss_1 = __webpack_require__(/*! @theia/scanoss */ "../../node_modules/@theia/scanoss/lib/common/index.js");
const ai_scanoss_preferences_1 = __webpack_require__(/*! ../ai-scanoss-preferences */ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-preferences.js");
const scanoss_preferences_1 = __webpack_require__(/*! @theia/scanoss/lib/browser/scanoss-preferences */ "../../node_modules/@theia/scanoss/lib/browser/scanoss-preferences.js");
const change_set_file_element_1 = __webpack_require__(/*! @theia/ai-chat/lib/browser/change-set-file-element */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-element.js");
const ai_scanoss_code_scan_action_1 = __webpack_require__(/*! ../ai-scanoss-code-scan-action */ "../../node_modules/@theia/ai-scanoss/lib/browser/ai-scanoss-code-scan-action.js");
const standaloneServices_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices.js");
const diffProviderFactoryService_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/browser/widget/diffEditor/diffProviderFactoryService */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/browser/widget/diffEditor/diffProviderFactoryService.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const change_set_scan_decorator_1 = __webpack_require__(/*! ./change-set-scan-decorator */ "../../node_modules/@theia/ai-scanoss/lib/browser/change-set-scan-action/change-set-scan-decorator.js");
let ChangeSetScanActionRenderer = class ChangeSetScanActionRenderer {
    constructor() {
        this.id = 'change-set-scanoss';
        this.priority = 10;
        this.onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    init() {
        this.differ = standaloneServices_1.StandaloneServices.get(diffProviderFactoryService_1.IDiffProviderFactoryService).createDiffProvider({ diffAlgorithm: 'advanced' });
        this._scan = this.runScan.bind(this);
        this.preferenceService.onPreferenceChanged(e => e.affects(ai_scanoss_preferences_1.SCANOSS_MODE_PREF) && this.onDidChangeEmitter.fire());
    }
    canRender(_changeSet) {
        return true;
    }
    render(changeSet) {
        return (React.createElement(ChangeSetScanOSSIntegration, { changeSet: changeSet, decorator: this.scanChangeSetDecorator, scanOssMode: this.getPreferenceValues(), scanChangeSet: this._scan }));
    }
    getPreferenceValues() {
        return this.preferenceService.get(ai_scanoss_preferences_1.SCANOSS_MODE_PREF, 'off');
    }
    async runScan(changeSetElements, cache, userTriggered) {
        const apiKey = this.preferenceService.get(scanoss_preferences_1.SCAN_OSS_API_KEY_PREF, undefined);
        let notifiedError = false;
        const fileResults = await Promise.all(changeSetElements.map(async (fileChange) => {
            if (fileChange.targetState.trim().length === 0) {
                return { type: 'clean' };
            }
            const toScan = await this.getScanContent(fileChange);
            if (!toScan) {
                return { type: 'clean' };
            }
            const cached = cache.get(toScan);
            if (cached) {
                return cached;
            }
            const result = { ...await this.scanService.scanContent(toScan, apiKey), file: fileChange.uri.path.toString() };
            if (result.type !== 'error') {
                cache.set(toScan, result);
            }
            else if (!notifiedError && userTriggered) {
                notifiedError = true;
                this.messageService.warn(core_1.nls.localize('theia/ai/scanoss/changeSet/error-notification', 'ScanOSS error encountered: {0}.', result.message));
            }
            return result;
        }));
        return fileResults;
    }
    async getScanContent(fileChange) {
        if (fileChange.replacements) {
            return fileChange.replacements.map(({ newContent }) => newContent).join('\n\n').trim();
        }
        const textModels = await Promise.all([
            this.textModelService.createModelReference(fileChange.uri),
            this.textModelService.createModelReference(fileChange.changedUri)
        ]);
        const [original, changed] = textModels;
        const diff = await this.differ.computeDiff(original.object.textEditorModel, changed.object.textEditorModel, { maxComputationTimeMs: 5000, computeMoves: false, ignoreTrimWhitespace: true }, core_1.CancellationToken.None);
        if (diff.identical) {
            return '';
        }
        const insertions = diff.changes.filter(candidate => !candidate.modified.isEmpty);
        if (insertions.length === 0) {
            return '';
        }
        const changedLinesInSuggestion = insertions.map(change => {
            const range = change.modified.toInclusiveRange();
            return range ? changed.object.textEditorModel.getValueInRange(range) : ''; // In practice, we've filtered out cases where the range would be null already.
        }).join('\n\n');
        textModels.forEach(ref => ref.dispose());
        return changedLinesInSuggestion.trim();
    }
};
exports.ChangeSetScanActionRenderer = ChangeSetScanActionRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(scanoss_1.ScanOSSService),
    tslib_1.__metadata("design:type", Object)
], ChangeSetScanActionRenderer.prototype, "scanService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preferences_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], ChangeSetScanActionRenderer.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_text_model_service_1.MonacoTextModelService),
    tslib_1.__metadata("design:type", monaco_text_model_service_1.MonacoTextModelService)
], ChangeSetScanActionRenderer.prototype, "textModelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], ChangeSetScanActionRenderer.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_scan_decorator_1.ChangeSetScanDecorator),
    tslib_1.__metadata("design:type", change_set_scan_decorator_1.ChangeSetScanDecorator)
], ChangeSetScanActionRenderer.prototype, "scanChangeSetDecorator", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ChangeSetScanActionRenderer.prototype, "init", null);
exports.ChangeSetScanActionRenderer = ChangeSetScanActionRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChangeSetScanActionRenderer);
const ChangeSetScanOSSIntegration = React.memo(({ changeSet, decorator, scanOssMode, scanChangeSet }) => {
    const [scanOSSResult, setScanOSSResult] = React.useState(undefined);
    const cache = React.useRef(new Map());
    const [changeSetElements, setChangeSetElements] = React.useState(() => changeSet.getElements().filter(candidate => candidate instanceof change_set_file_element_1.ChangeSetFileElement));
    React.useEffect(() => {
        if (scanOSSResult === undefined) {
            if (scanOssMode === 'automatic' && scanOSSResult === undefined) {
                setScanOSSResult('pending');
                scanChangeSet(changeSetElements, cache.current, false).then(result => setScanOSSResult(result));
            }
        }
    }, [scanOssMode, scanOSSResult]);
    React.useEffect(() => {
        if (!Array.isArray(scanOSSResult)) {
            decorator.setScanResult([]);
            return;
        }
        decorator.setScanResult(scanOSSResult);
    }, [decorator, scanOSSResult]);
    React.useEffect(() => {
        const disposable = changeSet.onDidChange(() => {
            setChangeSetElements(changeSet.getElements().filter(candidate => candidate instanceof change_set_file_element_1.ChangeSetFileElement));
            setScanOSSResult(undefined);
        });
        return () => disposable.dispose();
    }, [changeSet]);
    const scanOSSClicked = React.useCallback(async () => {
        if (scanOSSResult === 'pending') {
            return;
        }
        else if (!scanOSSResult || scanOSSResult.some(candidate => candidate.type === 'error')) {
            setScanOSSResult('pending');
            scanChangeSet(changeSetElements, cache.current, true).then(result => setScanOSSResult(result));
        }
        else {
            const matches = scanOSSResult.filter((candidate) => candidate.type === 'match');
            if (matches.length === 0) {
                return;
            }
            const dialog = new ai_scanoss_code_scan_action_1.ScanOSSDialog(matches);
            dialog.open();
        }
    }, [scanOSSResult, changeSetElements]);
    const state = getResult(scanOSSResult);
    const title = `ScanOSS: ${getTitle(state)}`;
    const content = getContent(state);
    const icon = getIcon(state);
    if (scanOssMode === 'off' || changeSetElements.length === 0) {
        return undefined;
    }
    else if (state === 'clean' || state === 'pending') {
        return React.createElement("div", { className: 'theia-changeSet-scanOss readonly' },
            React.createElement("div", { className: `scanoss-icon icon-container ${state === 'pending'
                    ? 'pending'
                    : state
                        ? state
                        : ''}`, title: title }, icon));
    }
    else {
        return React.createElement("button", { className: `theia-button secondary theia-changeSet-scanOss ${state}`, title: title, onClick: scanOSSClicked },
            React.createElement("div", { className: `scanoss-icon icon-container ${state}`, title: title }, icon),
            content);
    }
});
function getResult(scanOSSResult) {
    switch (true) {
        case scanOSSResult === undefined: return 'none';
        case scanOSSResult === 'pending': return 'pending';
        case scanOSSResult.some(candidate => candidate.type === 'error'): return 'error';
        case scanOSSResult.some(candidate => candidate.type === 'match'): return 'match';
        default: return 'clean';
    }
}
function getTitle(result) {
    switch (result) {
        case 'none': return core_1.nls.localize('theia/ai/scanoss/changeSet/scan', 'Scan');
        case 'pending': return core_1.nls.localize('theia/ai/scanoss/changeSet/scanning', 'Scanning...');
        case 'error': return core_1.nls.localize('theia/ai/scanoss/changeSet/error', 'Error: Rerun');
        case 'match': return core_1.nls.localize('theia/ai/scanoss/changeSet/match', 'View Matches');
        case 'clean': return core_1.nls.localize('theia/ai/scanoss/changeSet/clean', 'No Matches');
        default: return '';
    }
}
function getContent(result) {
    switch (result) {
        case 'none': return getTitle(result);
        case 'pending': return getTitle(result);
        default: return '';
    }
}
function getIcon(result) {
    switch (result) {
        case 'clean': return (React.createElement("span", { className: "status-icon" },
            React.createElement("span", { className: "codicon codicon-pass-filled" })));
        case 'match': return (React.createElement("span", { className: "status-icon" },
            React.createElement("span", { className: "codicon codicon-warning" })));
        default: return undefined;
    }
}


/***/ }),

/***/ "../../node_modules/@theia/ai-scanoss/lib/browser/change-set-scan-action/change-set-scan-decorator.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/lib/browser/change-set-scan-action/change-set-scan-decorator.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSetScanDecorator = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let ChangeSetScanDecorator = class ChangeSetScanDecorator {
    constructor() {
        this.id = 'thei-change-set-scanoss-decorator';
        this.emitter = new core_1.Emitter();
        this.onDidChangeDecorations = this.emitter.event;
        this.scanResult = [];
    }
    setScanResult(results) {
        this.scanResult = results;
        this.emitter.fire();
    }
    decorate(element) {
        const match = this.scanResult.find(result => {
            if (result.type === 'match') {
                return result.file === element.uri.path.toString();
            }
            return false;
        });
        if (match) {
            return {
                additionalInfoSuffixIcon: ['additional-info-scanoss-icon', 'match', 'codicon', 'codicon-warning'],
            };
        }
        return undefined;
    }
};
exports.ChangeSetScanDecorator = ChangeSetScanDecorator;
exports.ChangeSetScanDecorator = ChangeSetScanDecorator = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChangeSetScanDecorator);


/***/ }),

/***/ "../../node_modules/@theia/ai-scanoss/src/browser/style/index.css":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/src/browser/style/index.css ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./index.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/ai-scanoss/src/browser/style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/@theia/ai-scanoss/src/browser/style/scanoss_logo_dark_theme.svg":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/src/browser/style/scanoss_logo_dark_theme.svg ***!
  \******************************************************************************************/
/***/ ((module) => {

module.exports = "data:image/svg+xml;base64,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";

/***/ }),

/***/ "../../node_modules/@theia/ai-scanoss/src/browser/style/scanoss_logo_light_theme.svg":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-scanoss/src/browser/style/scanoss_logo_light_theme.svg ***!
  \*******************************************************************************************/
/***/ ((module) => {

module.exports = "data:image/svg+xml;base64,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";

/***/ }),

/***/ "../../node_modules/@theia/scanoss/lib/browser/scanoss-preferences.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/scanoss/lib/browser/scanoss-preferences.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScanOSSPreferencesSchema = exports.SCAN_OSS_API_KEY_PREF = void 0;
exports.SCAN_OSS_API_KEY_PREF = 'SCANOSS.apiKey';
exports.ScanOSSPreferencesSchema = {
    type: 'object',
    properties: {
        [exports.SCAN_OSS_API_KEY_PREF]: {
            type: 'string',
            markdownDescription: 'Enter an API Key of your SCANOSS  Account. **Please note:** By using this preference the key will be stored in clear text\
            on the machine running Theia. Use the environment variable `SCANOSS_API_KEY` to set the key securely.',
            title: 'SCANOSS API Key'
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/scanoss/lib/common/index.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@theia/scanoss/lib/common/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
tslib_1.__exportStar(__webpack_require__(/*! ./scanoss-service */ "../../node_modules/@theia/scanoss/lib/common/scanoss-service.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/scanoss/lib/common/scanoss-service.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/scanoss/lib/common/scanoss-service.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScanOSSService = exports.SCANOSS_SERVICE_PATH = void 0;
exports.SCANOSS_SERVICE_PATH = '/services/scanoss/service';
exports.ScanOSSService = Symbol('ScanOSSService');


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/ai-scanoss/src/browser/style/index.css":
/*!******************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/ai-scanoss/src/browser/style/index.css ***!
  \******************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/getUrl.js */ "../../node_modules/css-loader/dist/runtime/getUrl.js");
/* harmony import */ var _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2__);
// Imports



var ___CSS_LOADER_URL_IMPORT_0___ = new URL(/* asset import */ __webpack_require__(/*! scanoss_logo_dark_theme.svg */ "../../node_modules/@theia/ai-scanoss/src/browser/style/scanoss_logo_dark_theme.svg"), __webpack_require__.b);
var ___CSS_LOADER_URL_IMPORT_1___ = new URL(/* asset import */ __webpack_require__(/*! scanoss_logo_light_theme.svg */ "../../node_modules/@theia/ai-scanoss/src/browser/style/scanoss_logo_light_theme.svg"), __webpack_require__.b);
var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_0___);
var ___CSS_LOADER_URL_REPLACEMENT_1___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_2___default()(___CSS_LOADER_URL_IMPORT_1___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.scanoss-icon::before {
  content: "";
  mask-image: url(${___CSS_LOADER_URL_REPLACEMENT_0___});
  mask-repeat: no-repeat;
  mask-position: 50% 50%;
  mask-size: inherit;
  height: inherit;
  width: inherit;
  display: inline-block;
  background: var(--theia-sideBar-foreground, var(--theia-foreground));
}

.vs-light .scanoss-icon::before,
.theia-light .scanoss-icon::before,
.light-theia .scanoss-icon::before {
  mask-image: url(${___CSS_LOADER_URL_REPLACEMENT_1___});
}

/* We need a more detailed selector to override the default button style */
.theia-CodePartRenderer-actions .scanoss-icon::before {
  transition: filter 0.3s;
}

.scanoss-icon.pending {
  pointer-events: none;
  cursor: default;
}
.scanoss-icon.pending::before {
  animation: scan-os-fade 3s infinite ease-in-out;
}

@keyframes scan-os-fade {
  0%,
  100% {
    opacity: 0;
  }
  50% {
    opacity: 1;
  }
}

/* Use a rounded background when not hovered  */
.theia-CodePartRenderer-actions .scanoss-icon:not(:hover) {
  border-radius: 50%;
}

.scanoss-icon.match::before,
.scanoss-icon.clean::before,
.scanoss-icon.error::before {
  background-color: var(--theia-disabledForeground);
}

.icon-container {
  position: relative;
  display: inline-block;
  width: 16px;
  height: 16px;
}

.icon-container.scanoss-icon::before {
  width: 16px;
  height: 16px;
  mask-size: 16px;
}

.icon-container.scanoss-icon.clean,
.icon-container.scanoss-icon.match,
.icon-container.scanoss-icon.error {
  margin-right: 12px;
}

/* The placeholder is used to align with the remaining actions, however it should not be visible*/
.scanoss-icon .placeholder {
  visibility: hidden;
}

/* The status icon is used to display the result of the scan on the top right */
.scanoss-icon .status-icon {
  position: absolute;
  font-size: 14px;
  transform: translate(-4px, -2px);
}

.scanoss-icon.clean .status-icon {
  color: var(--theia-successBackground);
}
.scanoss-icon.match .status-icon,
.additional-info-scanoss-icon.match {
  color: var(--theia-problemsWarningIcon-foreground);
}
.scanoss-icon.error .status-icon {
  color: var(--theia-problemsErrorIcon-foreground);
}

/* Disable the button when it's in the clean state */
.theia-CodePartRenderer-actions .scanoss-icon.clean {
  pointer-events: none;
  cursor: default;
}

.scanoss-dialog-container .scanoss-header {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-bottom: 20px;
}

.scanoss-dialog-container .scanoss-icon-container {
  display: flex;
  flex-direction: row;
  align-items: center;
  gap: 10px;
}

.scanoss-dialog-container .scanoss-icon {
  width: 40px;
  height: 40px;
  mask-size: 40px;
}

.scanoss-dialog-container .scanoss-icon-container h2 {
  font-size: 1.8em;
  margin: 0;
}

.scanoss-dialog-container .scanoss-summary {
  padding: 15px;
  border-radius: 4px;
  margin-bottom: 20px;
}

.scanoss-dialog-container .scanoss-summary h3 {
  margin-top: 0;
  font-size: 1.4em;
  margin-bottom: 10px;
}

.scanoss-dialog-container .scanoss-details {
  padding: 15px;
  border-radius: 4px;
  border: 1px solid var(--theia-sideBarSectionHeader-border);
}

.scanoss-dialog-container .scanoss-details h4 {
  margin-top: 0;
  font-size: 1.2em;
  margin-bottom: 10px;
}

.scanoss-dialog-container .scanoss-details pre {
  background: var(--theia-editor-background);
  padding: 10px;
  border-radius: 4px;
  overflow: auto;
  font-size: 0.9em;
}

/* ####### Change Set ####### */

.theia-changeSet-scanOss {
  display: flex;
  flex-flow: row nowrap;
  align-items: center;
  justify-content: center;
  gap: var(--theia-ui-padding);
}

.theia-changeSet-scanOss.readonly {
  margin-right: 10px;
  height: 100%;
}

.theia-changeSet-Action .theia-button.secondary {
  background: none;
}

.theia-changeSet-Action .theia-button.secondary:hover {
  background: var(--theia-toolbar-hoverBackground);
}

.theia-changeSet-scanOss.clean,
.theia-changeSet-scanOss.pending {
  cursor: default;
}

.theia-changeSet-scanOss.clean:hover,
.theia-changeSet-scanOss.pending:hover {
  background-color: var(--theia-button-background);
}

.theia-changeSet-scanOss .scanoss-icon.clean,
.theia-changeSet-scanOss .scanoss-icon.match,
.theia-changeSet-scanOss .scanoss-icon.error {
  margin-right: 0px;
}

.theia-changeSet-scanOss .status-icon {
  height: 16px;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/ai-scanoss/src/browser/style/index.css"],"names":[],"mappings":"AAAA;EACE,WAAW;EACX,mDAA8C;EAC9C,sBAAsB;EACtB,sBAAsB;EACtB,kBAAkB;EAClB,eAAe;EACf,cAAc;EACd,qBAAqB;EACrB,oEAAoE;AACtE;;AAEA;;;EAGE,mDAA+C;AACjD;;AAEA,0EAA0E;AAC1E;EACE,uBAAuB;AACzB;;AAEA;EACE,oBAAoB;EACpB,eAAe;AACjB;AACA;EACE,+CAA+C;AACjD;;AAEA;EACE;;IAEE,UAAU;EACZ;EACA;IACE,UAAU;EACZ;AACF;;AAEA,+CAA+C;AAC/C;EACE,kBAAkB;AACpB;;AAEA;;;EAGE,iDAAiD;AACnD;;AAEA;EACE,kBAAkB;EAClB,qBAAqB;EACrB,WAAW;EACX,YAAY;AACd;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,eAAe;AACjB;;AAEA;;;EAGE,kBAAkB;AACpB;;AAEA,iGAAiG;AACjG;EACE,kBAAkB;AACpB;;AAEA,+EAA+E;AAC/E;EACE,kBAAkB;EAClB,eAAe;EACf,gCAAgC;AAClC;;AAEA;EACE,qCAAqC;AACvC;AACA;;EAEE,kDAAkD;AACpD;AACA;EACE,gDAAgD;AAClD;;AAEA,oDAAoD;AACpD;EACE,oBAAoB;EACpB,eAAe;AACjB;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,mBAAmB;EACnB,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,mBAAmB;EACnB,SAAS;AACX;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,eAAe;AACjB;;AAEA;EACE,gBAAgB;EAChB,SAAS;AACX;;AAEA;EACE,aAAa;EACb,kBAAkB;EAClB,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,gBAAgB;EAChB,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,kBAAkB;EAClB,0DAA0D;AAC5D;;AAEA;EACE,aAAa;EACb,gBAAgB;EAChB,mBAAmB;AACrB;;AAEA;EACE,0CAA0C;EAC1C,aAAa;EACb,kBAAkB;EAClB,cAAc;EACd,gBAAgB;AAClB;;AAEA,+BAA+B;;AAE/B;EACE,aAAa;EACb,qBAAqB;EACrB,mBAAmB;EACnB,uBAAuB;EACvB,4BAA4B;AAC9B;;AAEA;EACE,kBAAkB;EAClB,YAAY;AACd;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,gDAAgD;AAClD;;AAEA;;EAEE,eAAe;AACjB;;AAEA;;EAEE,gDAAgD;AAClD;;AAEA;;;EAGE,iBAAiB;AACnB;;AAEA;EACE,YAAY;AACd","sourcesContent":[".scanoss-icon::before {\n  content: \"\";\n  mask-image: url(\"scanoss_logo_dark_theme.svg\");\n  mask-repeat: no-repeat;\n  mask-position: 50% 50%;\n  mask-size: inherit;\n  height: inherit;\n  width: inherit;\n  display: inline-block;\n  background: var(--theia-sideBar-foreground, var(--theia-foreground));\n}\n\n.vs-light .scanoss-icon::before,\n.theia-light .scanoss-icon::before,\n.light-theia .scanoss-icon::before {\n  mask-image: url(\"scanoss_logo_light_theme.svg\");\n}\n\n/* We need a more detailed selector to override the default button style */\n.theia-CodePartRenderer-actions .scanoss-icon::before {\n  transition: filter 0.3s;\n}\n\n.scanoss-icon.pending {\n  pointer-events: none;\n  cursor: default;\n}\n.scanoss-icon.pending::before {\n  animation: scan-os-fade 3s infinite ease-in-out;\n}\n\n@keyframes scan-os-fade {\n  0%,\n  100% {\n    opacity: 0;\n  }\n  50% {\n    opacity: 1;\n  }\n}\n\n/* Use a rounded background when not hovered  */\n.theia-CodePartRenderer-actions .scanoss-icon:not(:hover) {\n  border-radius: 50%;\n}\n\n.scanoss-icon.match::before,\n.scanoss-icon.clean::before,\n.scanoss-icon.error::before {\n  background-color: var(--theia-disabledForeground);\n}\n\n.icon-container {\n  position: relative;\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n}\n\n.icon-container.scanoss-icon::before {\n  width: 16px;\n  height: 16px;\n  mask-size: 16px;\n}\n\n.icon-container.scanoss-icon.clean,\n.icon-container.scanoss-icon.match,\n.icon-container.scanoss-icon.error {\n  margin-right: 12px;\n}\n\n/* The placeholder is used to align with the remaining actions, however it should not be visible*/\n.scanoss-icon .placeholder {\n  visibility: hidden;\n}\n\n/* The status icon is used to display the result of the scan on the top right */\n.scanoss-icon .status-icon {\n  position: absolute;\n  font-size: 14px;\n  transform: translate(-4px, -2px);\n}\n\n.scanoss-icon.clean .status-icon {\n  color: var(--theia-successBackground);\n}\n.scanoss-icon.match .status-icon,\n.additional-info-scanoss-icon.match {\n  color: var(--theia-problemsWarningIcon-foreground);\n}\n.scanoss-icon.error .status-icon {\n  color: var(--theia-problemsErrorIcon-foreground);\n}\n\n/* Disable the button when it's in the clean state */\n.theia-CodePartRenderer-actions .scanoss-icon.clean {\n  pointer-events: none;\n  cursor: default;\n}\n\n.scanoss-dialog-container .scanoss-header {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  margin-bottom: 20px;\n}\n\n.scanoss-dialog-container .scanoss-icon-container {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  gap: 10px;\n}\n\n.scanoss-dialog-container .scanoss-icon {\n  width: 40px;\n  height: 40px;\n  mask-size: 40px;\n}\n\n.scanoss-dialog-container .scanoss-icon-container h2 {\n  font-size: 1.8em;\n  margin: 0;\n}\n\n.scanoss-dialog-container .scanoss-summary {\n  padding: 15px;\n  border-radius: 4px;\n  margin-bottom: 20px;\n}\n\n.scanoss-dialog-container .scanoss-summary h3 {\n  margin-top: 0;\n  font-size: 1.4em;\n  margin-bottom: 10px;\n}\n\n.scanoss-dialog-container .scanoss-details {\n  padding: 15px;\n  border-radius: 4px;\n  border: 1px solid var(--theia-sideBarSectionHeader-border);\n}\n\n.scanoss-dialog-container .scanoss-details h4 {\n  margin-top: 0;\n  font-size: 1.2em;\n  margin-bottom: 10px;\n}\n\n.scanoss-dialog-container .scanoss-details pre {\n  background: var(--theia-editor-background);\n  padding: 10px;\n  border-radius: 4px;\n  overflow: auto;\n  font-size: 0.9em;\n}\n\n/* ####### Change Set ####### */\n\n.theia-changeSet-scanOss {\n  display: flex;\n  flex-flow: row nowrap;\n  align-items: center;\n  justify-content: center;\n  gap: var(--theia-ui-padding);\n}\n\n.theia-changeSet-scanOss.readonly {\n  margin-right: 10px;\n  height: 100%;\n}\n\n.theia-changeSet-Action .theia-button.secondary {\n  background: none;\n}\n\n.theia-changeSet-Action .theia-button.secondary:hover {\n  background: var(--theia-toolbar-hoverBackground);\n}\n\n.theia-changeSet-scanOss.clean,\n.theia-changeSet-scanOss.pending {\n  cursor: default;\n}\n\n.theia-changeSet-scanOss.clean:hover,\n.theia-changeSet-scanOss.pending:hover {\n  background-color: var(--theia-button-background);\n}\n\n.theia-changeSet-scanOss .scanoss-icon.clean,\n.theia-changeSet-scanOss .scanoss-icon.match,\n.theia-changeSet-scanOss .scanoss-icon.error {\n  margin-right: 0px;\n}\n\n.theia-changeSet-scanOss .status-icon {\n  height: 16px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-scanoss_lib_browser_ai-scanoss-frontend-module_js.js.map