"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["node_modules_theia_userstorage_lib_browser_user-storage-frontend-module_js"],{

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserStorageContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
const delegating_file_system_provider_1 = __webpack_require__(/*! @theia/filesystem/lib/common/delegating-file-system-provider */ "../../node_modules/@theia/filesystem/lib/common/delegating-file-system-provider.js");
const user_storage_uri_1 = __webpack_require__(/*! ./user-storage-uri */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js");
let UserStorageContribution = class UserStorageContribution {
    registerFileSystemProviders(service) {
        service.onWillActivateFileSystemProvider(event => {
            if (event.scheme === user_storage_uri_1.UserStorageUri.scheme) {
                event.waitUntil((async () => {
                    const provider = await this.createProvider(service);
                    service.registerProvider(user_storage_uri_1.UserStorageUri.scheme, provider);
                })());
            }
        });
    }
    getDelegate(service) {
        return service.activateProvider('file');
    }
    async getCongigDirUri() {
        return new uri_1.default(await this.environments.getConfigDirUri());
    }
    async createProvider(service) {
        const delegate = await this.getDelegate(service);
        const configDirUri = await this.getCongigDirUri();
        return new delegating_file_system_provider_1.DelegatingFileSystemProvider(delegate, {
            uriConverter: {
                to: resource => {
                    const relativePath = user_storage_uri_1.UserStorageUri.relative(resource);
                    if (relativePath) {
                        return configDirUri.resolve(relativePath).normalizePath();
                    }
                    return undefined;
                },
                from: resource => {
                    const relativePath = configDirUri.relative(resource);
                    if (relativePath) {
                        return user_storage_uri_1.UserStorageUri.resolve(relativePath);
                    }
                    return undefined;
                }
            }
        }, new disposable_1.DisposableCollection(delegate.watch(configDirUri, { excludes: [], recursive: true })));
    }
};
exports.UserStorageContribution = UserStorageContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    tslib_1.__metadata("design:type", Object)
], UserStorageContribution.prototype, "environments", void 0);
exports.UserStorageContribution = UserStorageContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], UserStorageContribution);


/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-frontend-module.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-frontend-module.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const user_storage_contribution_1 = __webpack_require__(/*! ./user-storage-contribution */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(user_storage_contribution_1.UserStorageContribution).toSelf().inSingletonScope();
    bind(file_service_1.FileServiceContribution).toService(user_storage_contribution_1.UserStorageContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserStorageUri = void 0;
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
exports.UserStorageUri = new uri_1.default('user-storage:/user');


/***/ })

}]);
//# sourceMappingURL=node_modules_theia_userstorage_lib_browser_user-storage-frontend-module_js.js.map