/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.PropertyOrigin;

public abstract class StringBuildOption<T>
extends AbstractBuildOption<T, CommandLineOptionConfiguration> {
    public StringBuildOption(String property) {
        super(property);
    }

    public StringBuildOption(String property, PropertyOrigin propertyOrigin) {
        super(property, propertyOrigin);
    }

    public StringBuildOption(String property, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(property, commandLineOptionConfigurations);
    }

    @Override
    public void applyFromProperty(Map<String, String> properties, T settings) {
        String value = properties.get(this.property);
        if (value != null) {
            this.applyTo(value, settings, this.propertyOrigin.toOrigin(this.property));
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.isDeprecated(), config.isIncubating()).hasArgument();
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (!options.hasOption(config.getLongOption())) continue;
            String value = options.option(config.getLongOption()).getValue();
            this.applyTo(value, settings, Origin.forCommandLine(config.getLongOption()));
        }
    }

    public abstract void applyTo(String var1, T var2, Origin var3);
}

