/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.gradle;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.StatusCode;
import com.microsoft.java.bs.core.Launcher;
import com.microsoft.java.bs.core.internal.gradle.Utils;
import com.microsoft.java.bs.core.internal.managers.PreferenceManager;
import com.microsoft.java.bs.core.internal.reporter.CompileProgressReporter;
import com.microsoft.java.bs.core.internal.reporter.DefaultProgressReporter;
import com.microsoft.java.bs.core.internal.reporter.ProgressReporter;
import com.microsoft.java.bs.core.internal.reporter.TestReportReporter;
import com.microsoft.java.bs.gradle.model.GradleSourceSets;
import com.microsoft.java.bs.gradle.model.actions.GetSourceSetsAction;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;

public class GradleApiConnector {
    private final Map<File, GradleConnector> connectors;
    private final PreferenceManager preferenceManager;

    public GradleApiConnector(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.connectors = new HashMap<File, GradleConnector>();
    }

    public String getGradleVersion(URI projectUri) {
        String string;
        block8: {
            ProjectConnection connection = this.getGradleConnector(projectUri).connect();
            try {
                string = this.getGradleVersion(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BuildException e) {
                    Launcher.LOGGER.severe("Failed to get Gradle version: " + e.getMessage());
                    return "";
                }
            }
            connection.close();
        }
        return string;
    }

    private String getGradleVersion(ProjectConnection connection) {
        BuildEnvironment model = (BuildEnvironment)connection.model(BuildEnvironment.class).get();
        return model.getGradle().getGradleVersion();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public GradleSourceSets getGradleSourceSets(URI projectUri, BuildClient client) {
        File initScript = Utils.getInitScriptFile();
        if (!initScript.exists()) {
            throw new IllegalStateException("Failed to get init script file.");
        }
        DefaultProgressReporter reporter = new DefaultProgressReporter(client);
        ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
        try (ProjectConnection connection = this.getGradleConnector(projectUri).connect();){
            DefaultGradleSourceSets defaultGradleSourceSets;
            block17: {
                ByteArrayOutputStream byteArrayOutputStream = errorOut;
                try {
                    BuildActionExecuter buildExecutor = Utils.getBuildActionExecuter(connection, this.preferenceManager.getPreferences(), new GetSourceSetsAction());
                    ((BuildActionExecuter)((BuildActionExecuter)buildExecutor.addProgressListener((ProgressListener)reporter, new OperationType[]{OperationType.FILE_DOWNLOAD, OperationType.PROJECT_CONFIGURATION})).setStandardError((OutputStream)errorOut)).addArguments(new String[]{"--init-script", initScript.getAbsolutePath()});
                    if (Boolean.getBoolean("bsp.plugin.debug.enabled")) {
                        buildExecutor.addJvmArguments(new String[]{"-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005"});
                    }
                    buildExecutor.addJvmArguments(new String[]{"-Dbsp.gradle.supportedLanguages=" + String.join((CharSequence)",", this.preferenceManager.getClientSupportedLanguages())});
                    defaultGradleSourceSets = new DefaultGradleSourceSets((GradleSourceSets)buildExecutor.run());
                    if (byteArrayOutputStream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                byteArrayOutputStream.close();
            }
            return defaultGradleSourceSets;
        }
        catch (IOException | IllegalStateException | GradleConnectionException e) {
            Object summary = e.getMessage();
            if (errorOut.size() > 0) {
                summary = (String)summary + "\n" + errorOut;
            }
            reporter.sendError((String)summary);
            throw new IllegalStateException(e);
        }
    }

    public StatusCode runTasks(URI projectUri, ProgressReporter reporter, String ... tasks) {
        ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
        StatusCode statusCode = StatusCode.OK;
        try (ProjectConnection connection = this.getGradleConnector(projectUri).connect();
             ByteArrayOutputStream byteArrayOutputStream = errorOut;){
            BuildLauncher launcher = Utils.getBuildLauncher(connection, this.preferenceManager.getPreferences());
            ((BuildLauncher)((BuildLauncher)launcher.addProgressListener((ProgressListener)reporter, new OperationType[]{OperationType.TASK})).setStandardError((OutputStream)errorOut)).forTasks(tasks).run();
        }
        catch (IOException e) {
            Launcher.LOGGER.severe(e.getMessage());
        }
        catch (BuildException e) {
            Object summary = e.getMessage();
            if (errorOut.size() > 0) {
                summary = (String)summary + "\n" + errorOut;
            }
            reporter.sendError((String)summary);
            statusCode = StatusCode.ERROR;
        }
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode runTests(URI projectUri, Map<BuildTargetIdentifier, Map<String, Set<String>>> testClassesMethodsMap, List<String> jvmOptions, List<String> args, Map<String, String> envVars, BuildClient client, String originId, CompileProgressReporter compileProgressReporter) {
        StatusCode statusCode;
        block28: {
            statusCode = StatusCode.OK;
            DefaultProgressReporter reporter = new DefaultProgressReporter(client);
            try (ProjectConnection connection = this.getGradleConnector(projectUri).connect();){
                String gradleVersion = this.getGradleVersion(connection);
                if (GradleVersion.version((String)gradleVersion).compareTo(GradleVersion.version((String)"2.6")) < 0) {
                    reporter.sendError("Error running test classes: Gradle version " + gradleVersion + " must be >= 2.6");
                    break block28;
                }
                if (envVars != null && !envVars.isEmpty() && GradleVersion.version((String)gradleVersion).compareTo(GradleVersion.version((String)"3.5")) < 0) {
                    reporter.sendError("Error running test classes With Environment Variables: Gradle version " + gradleVersion + " must be >= 3.5");
                    break block28;
                }
                for (Map.Entry<BuildTargetIdentifier, Map<String, Set<String>>> entry : testClassesMethodsMap.entrySet()) {
                    TestReportReporter testReportReporter = new TestReportReporter(entry.getKey(), client, originId);
                    ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = errorOut;
                        try {
                            TestLauncher launcher = (TestLauncher)((TestLauncher)Utils.getTestLauncher(connection, this.preferenceManager.getPreferences()).setStandardError((OutputStream)errorOut)).addProgressListener((ProgressListener)testReportReporter, new OperationType[]{OperationType.TEST});
                            if (compileProgressReporter != null) {
                                launcher.addProgressListener((ProgressListener)compileProgressReporter, new OperationType[]{OperationType.TASK});
                            }
                            for (Map.Entry<String, Set<String>> classesMethods : entry.getValue().entrySet()) {
                                if (classesMethods.getValue() != null && !classesMethods.getValue().isEmpty()) {
                                    launcher.withJvmTestMethods(classesMethods.getKey() + "*", (Iterable)classesMethods.getValue());
                                    continue;
                                }
                                launcher.withJvmTestClasses(new String[]{classesMethods.getKey() + "*"});
                            }
                            launcher.withArguments(args);
                            launcher.setJvmArguments(jvmOptions);
                            if (envVars != null) {
                                HashMap<String, String> allEnvVars = new HashMap<String, String>(System.getenv());
                                allEnvVars.putAll(envVars);
                                launcher.setEnvironmentVariables(allEnvVars);
                            }
                            launcher.run();
                        }
                        finally {
                            if (byteArrayOutputStream == null) continue;
                            byteArrayOutputStream.close();
                        }
                    }
                    catch (IOException e) {
                        Launcher.LOGGER.severe(e.getMessage());
                    }
                    catch (IllegalStateException | GradleConnectionException e) {
                        Object message = String.join((CharSequence)"\n", ExceptionUtils.getRootCauseStackTraceList((Throwable)e));
                        if (errorOut.size() > 0) {
                            message = (String)message + "\n" + errorOut;
                        }
                        testReportReporter.addException((String)message);
                        statusCode = StatusCode.ERROR;
                    }
                    finally {
                        testReportReporter.sendResult();
                    }
                }
            }
            catch (IllegalStateException | GradleConnectionException e) {
                reporter.sendError("Error running test classes: " + e.getMessage());
                statusCode = StatusCode.ERROR;
            }
        }
        return statusCode;
    }

    public void shutdown() {
        this.connectors.values().forEach(GradleConnector::disconnect);
    }

    private GradleConnector getGradleConnector(URI projectUri) {
        return this.getGradleConnector(new File(projectUri));
    }

    private GradleConnector getGradleConnector(File project) {
        return this.connectors.computeIfAbsent(project, p -> Utils.getProjectConnector(p, this.preferenceManager.getPreferences()));
    }
}

