/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.IGenericMethod;
import org.eclipse.jdt.internal.compiler.util.Util;

public interface IBinaryMethod
extends IGenericMethod {
    public IBinaryAnnotation[] getAnnotations();

    public Object getDefaultValue();

    public char[][] getExceptionTypeNames();

    public char[] getGenericSignature();

    public char[] getMethodDescriptor();

    public IBinaryAnnotation[] getParameterAnnotations(int var1, char[] var2);

    public int getAnnotatedParametersCount();

    public char[] getSelector();

    public long getTagBits();

    public boolean isClinit();

    public IBinaryTypeAnnotation[] getTypeAnnotations();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public int getParameterCount() {
        char[] methodSignature = this.getMethodDescriptor();
        try {
            int count = 0;
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                return -1;
            }
            ++i;
            while (true) {
                if (methodSignature[i] == ')') {
                    return count;
                }
                int e = Util.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    return -1;
                }
                i = e + 1;
                ++count;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }
}

