/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.BaseJDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.LanguageServerApplication;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.services.LanguageServer;

public final class ParentProcessWatcher
implements Runnable,
Function<MessageConsumer, MessageConsumer> {
    private static final long INACTIVITY_DELAY_SECS = 30000L;
    private static final boolean isJava1x = System.getProperty("java.version").startsWith("1.");
    private static final int POLL_DELAY_SECS = 10;
    private volatile long lastActivityTime;
    private final LanguageServerApplication server;
    private ScheduledFuture<?> task;
    private ScheduledExecutorService service;

    public ParentProcessWatcher(LanguageServerApplication server) {
        this.server = server;
        if (ProcessHandle.current().parent().isPresent()) {
            this.server.setParentProcessId(ProcessHandle.current().parent().get().pid());
        }
        this.service = Executors.newScheduledThreadPool(1);
        this.task = this.service.scheduleWithFixedDelay(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (!this.parentProcessStillRunning()) {
            BaseJDTLanguageServer baseJDTLanguageServer;
            JavaLanguageServerPlugin.logInfo("Parent process stopped running, forcing server exit");
            this.task.cancel(true);
            if (JavaLanguageServerPlugin.getInstance() != null && (baseJDTLanguageServer = JavaLanguageServerPlugin.getInstance().getProtocol()) instanceof LanguageServer) {
                LanguageServer languageServer = (LanguageServer)baseJDTLanguageServer;
                languageServer.exit();
            } else {
                this.server.exit();
                Executors.newSingleThreadScheduledExecutor().schedule(() -> {
                    JavaLanguageServerPlugin.logInfo("Forcing exit after 1 min.");
                    System.exit(1);
                }, 1L, TimeUnit.MINUTES);
            }
        }
    }

    private boolean parentProcessStillRunning() {
        long pid = this.server.getParentProcessId();
        if (pid == 0L || this.lastActivityTime > System.currentTimeMillis() - 30000L) {
            return true;
        }
        try {
            return ProcessHandle.of(pid).isPresent();
        }
        catch (SecurityException | UnsupportedOperationException e) {
            JavaLanguageServerPlugin.logException("Unable to determine process state, fallback behaviour", e);
            String command = "win32".equals(Platform.getOS()) ? String.format("cmd /c \"tasklist /FI \"PID eq %1$d\" | findstr %1$d\"", pid) : String.format("kill -0 %d", pid);
            Process process = null;
            boolean finished = false;
            try {
                process = Runtime.getRuntime().exec(command);
                finished = process.waitFor(10L, TimeUnit.SECONDS);
                if (!finished) {
                    process.destroy();
                    finished = process.waitFor(10L, TimeUnit.SECONDS);
                }
                if ("win32".equals(Platform.getOS()) && finished && process.exitValue() > 1) {
                    JavaLanguageServerPlugin.logInfo("The tasklist command: '" + command + "' returns " + process.exitValue());
                    return true;
                }
                boolean bl = !finished || process.exitValue() == 0;
                return bl;
            }
            catch (IOException | InterruptedException e2) {
                JavaLanguageServerPlugin.logException(e2.getMessage(), e2);
                return true;
            }
            finally {
                if (process != null) {
                    if (!finished) {
                        process.destroyForcibly();
                    }
                    if ("win32".equals(Platform.getOS())) {
                        if (!isJava1x) {
                            Closeables.closeQuietly((InputStream)process.getInputStream());
                            Closeables.closeQuietly((InputStream)process.getErrorStream());
                            try {
                                Closeables.close((Closeable)process.getOutputStream(), (boolean)false);
                            }
                            catch (IOException iOException) {}
                        }
                        System.gc();
                    }
                }
            }
        }
    }

    @Override
    public MessageConsumer apply(MessageConsumer consumer) {
        return message -> {
            this.lastActivityTime = System.currentTimeMillis();
            consumer.consume(message);
        };
    }
}

