/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.Messages;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class SourceAttachmentCommand {
    public static SourceAttachmentResult resolveSourceAttachment(List<Object> arguments, IProgressMonitor monitor) {
        if (arguments == null || arguments.isEmpty()) {
            return new SourceAttachmentResult("The parameter is missing.", null);
        }
        try {
            SourceAttachmentRequest request = JSONUtility.toModel(arguments.get(0), SourceAttachmentRequest.class);
            IPackageFragmentRoot root = SourceAttachmentCommand.getPackageFragmentRoot(request.classFileUri);
            return SourceAttachmentCommand.resolveSourceAttachment(root, monitor);
        }
        catch (JsonSyntaxException ex1) {
            JavaLanguageServerPlugin.logException("Converting the source attachment parameter ", ex1);
            return new SourceAttachmentResult("Invalid parameter to resolve source attachment.", null);
        }
        catch (CoreException ex2) {
            JavaLanguageServerPlugin.logException("Resolving the source attachment ", ex2);
            return new SourceAttachmentResult(ex2.getMessage(), null);
        }
    }

    public static SourceAttachmentResult updateSourceAttachment(List<Object> arguments, IProgressMonitor monitor) {
        if (arguments == null || arguments.isEmpty()) {
            return new SourceAttachmentResult("The parameter is missing.", null);
        }
        try {
            SourceAttachmentRequest request = JSONUtility.toModel(arguments.get(0), SourceAttachmentRequest.class);
            IPackageFragmentRoot root = SourceAttachmentCommand.getPackageFragmentRoot(request.classFileUri);
            return SourceAttachmentCommand.updateSourceAttachment(root, request.attributes, monitor);
        }
        catch (JsonSyntaxException ex1) {
            JavaLanguageServerPlugin.logException("Converting the source attachment parameter ", ex1);
            return new SourceAttachmentResult("Invalid parameter to update source attachment.", null);
        }
        catch (CoreException ex2) {
            JavaLanguageServerPlugin.logException("Updating the source attachment ", ex2);
            return new SourceAttachmentResult(ex2.getMessage(), null);
        }
    }

    public static SourceAttachmentResult resolveSourceAttachment(IPackageFragmentRoot root, IProgressMonitor monitor) {
        ClasspathEntryWrapper entryWrapper = null;
        try {
            entryWrapper = SourceAttachmentCommand.getClasspathEntry(root);
        }
        catch (CoreException e) {
            return new SourceAttachmentResult(e.getMessage(), null);
        }
        IResource jarResource = null;
        try {
            jarResource = root.getUnderlyingResource();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        String jarPath = jarResource != null ? jarResource.getLocation().toOSString() : entryWrapper.original.getPath().toOSString();
        String sourceAttachmentPath = entryWrapper.original.getSourceAttachmentPath() != null ? entryWrapper.original.getSourceAttachmentPath().toOSString() : null;
        String sourceAttachmentEncoding = SourceAttachmentCommand.getSourceAttachmentEncoding(entryWrapper.original);
        return new SourceAttachmentResult(null, new SourceAttachmentAttribute(jarPath, sourceAttachmentPath, sourceAttachmentEncoding, entryWrapper.canEditEncoding));
    }

    public static SourceAttachmentResult updateSourceAttachment(IPackageFragmentRoot root, SourceAttachmentAttribute changedAttributes, IProgressMonitor monitor) {
        ClasspathEntryWrapper entryWrapper = null;
        try {
            entryWrapper = SourceAttachmentCommand.getClasspathEntry(root);
        }
        catch (Exception e) {
            return new SourceAttachmentResult(e.getMessage(), null);
        }
        IJavaProject javaProject = root.getJavaProject();
        IClasspathEntry newClasspathEntry = SourceAttachmentCommand.newClasspathEntry(entryWrapper.original, changedAttributes, javaProject.getProject());
        if (newClasspathEntry != null && !entryWrapper.original.equals(newClasspathEntry)) {
            try {
                if (entryWrapper.containerPath != null) {
                    SourceAttachmentCommand.updateContainerClasspath(javaProject, entryWrapper.containerPath, newClasspathEntry);
                } else if (entryWrapper.original.getReferencingEntry() != null) {
                    SourceAttachmentCommand.updateReferencedClasspathEntry(javaProject, newClasspathEntry, monitor);
                } else {
                    SourceAttachmentCommand.updateProjectClasspath(javaProject, newClasspathEntry, monitor);
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Updating the project ClasspathEntry ", e);
                return new SourceAttachmentResult("Update the ClasspathEntry to the project failure. Reason: \"" + e.getMessage() + "\"", null);
            }
        }
        return new SourceAttachmentResult(null, null);
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(String classFileUri) throws CoreException {
        IClassFile classFile = JDTUtils.resolveClassFile(classFileUri);
        if (classFile == null) {
            throw SourceAttachmentCommand.constructCoreException("Cannot find the class file " + classFileUri);
        }
        IPackageFragmentRoot root = SourceAttachmentCommand.getPackageFragmentRoot(classFile);
        if (root == null) {
            throw SourceAttachmentCommand.constructCoreException("Cannot find the JAR containing this class file " + classFileUri);
        }
        return root;
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IClassFile file) {
        IJavaElement element = file.getParent();
        while (element != null && element.getElementType() != 3) {
            element = element.getParent();
        }
        return (IPackageFragmentRoot)element;
    }

    private static String getSourceAttachmentEncoding(IClasspathEntry entry) {
        if (entry != null && entry.getExtraAttributes() != null) {
            IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attribute = iClasspathAttributeArray[n2];
                if ("source_encoding".equals(attribute.getName())) {
                    return attribute.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    private static ClasspathEntryWrapper getClasspathEntry(IPackageFragmentRoot root) throws CoreException {
        IClasspathEntry entry = null;
        IPath containerPath = null;
        boolean canEditEncoding = true;
        try {
            entry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)root);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("getting ClasspathEntry from the PackageFragmentRoot ", e);
            throw SourceAttachmentCommand.constructCoreException(Messages.format((String)"Cannot find the ClasspathEntry for the JAR '{0}' of this class file", (Object)BasicElementLabels.getPathLabel((IPath)root.getPath(), (boolean)true)), (Exception)((Object)e));
        }
        try {
            if (root.getKind() != 2) {
                throw SourceAttachmentCommand.constructCoreException(Messages.format((String)"The JAR '{0}' of this class file contains non binary files which does not support the attachment.", (Object)BasicElementLabels.getPathLabel((IPath)root.getPath(), (boolean)true)));
            }
            if (entry.getEntryKind() == 5) {
                IJavaProject javaProject = root.getJavaProject();
                containerPath = entry.getPath();
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
                if (initializer == null || container == null) {
                    throw SourceAttachmentCommand.constructCoreException(Messages.format((String)"The JAR of this class file belongs to container '{0}' can not be configured.", (Object)BasicElementLabels.getPathLabel((IPath)containerPath, (boolean)false)));
                }
                String containerName = container.getDescription();
                IStatus status = initializer.getSourceAttachmentStatus(containerPath, javaProject);
                if (status.getCode() == 1) {
                    throw SourceAttachmentCommand.constructCoreException(Messages.format((String)"The JAR of this class file belongs to container '{0}' which does not support the attachment of sources to its entries.", (Object)containerName));
                }
                if (status.getCode() == 2) {
                    throw SourceAttachmentCommand.constructCoreException(Messages.format((String)"The JAR of this class file belongs to container '{0}' which does not allow modifications to source attachments on its entries.", (Object)containerName));
                }
                IStatus attributeStatus = initializer.getAttributeStatus(containerPath, javaProject, "source_encoding");
                canEditEncoding = attributeStatus.getCode() != 1 && attributeStatus.getCode() != 2;
                entry = JavaModelUtil.findEntryInContainer((IClasspathContainer)container, (IPath)root.getPath());
                if (entry == null) {
                    throw SourceAttachmentCommand.constructCoreException(Messages.format((String)"Cannot find the ClasspathEntry from container '{0}'.", (Object)containerName));
                }
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Exception getting the ClasspathEntry for the packageFragmentRoot ", e);
            throw SourceAttachmentCommand.constructCoreException(Messages.format((String)"Cannot find the ClasspathEntry for the JAR '{0}' of this class file", (Object)BasicElementLabels.getPathLabel((IPath)root.getPath(), (boolean)true)), (Exception)((Object)e));
        }
        return new ClasspathEntryWrapper(entry, containerPath, canEditEncoding);
    }

    private static IClasspathEntry newClasspathEntry(IClasspathEntry entry, SourceAttachmentAttribute changedAttributes, IProject project) {
        IPath sourceFilePath = StringUtils.isNotBlank((CharSequence)changedAttributes.sourceAttachmentPath) ? Path.fromOSString((String)changedAttributes.sourceAttachmentPath).makeAbsolute() : null;
        IPath projectLocation = project.getLocation();
        if (sourceFilePath != null && projectLocation.isPrefixOf(sourceFilePath)) {
            IPath relativeFilePath = sourceFilePath.makeRelativeTo(projectLocation);
            sourceFilePath = project.findMember(relativeFilePath).getFullPath();
        }
        IPath sourceAttachmentPath = sourceFilePath == null || sourceFilePath.isEmpty() ? null : sourceFilePath;
        IClasspathAttribute newSourceEncodingAttribute = StringUtils.isNotBlank((CharSequence)changedAttributes.sourceAttachmentEncoding) ? JavaCore.newClasspathAttribute((String)"source_encoding", (String)changedAttributes.sourceAttachmentEncoding) : null;
        List<IClasspathAttribute> newAttributes = SourceAttachmentCommand.updateElements(entry.getExtraAttributes(), newSourceEncodingAttribute, attribute -> {
            if (attribute.getName() == "source_encoding") {
                return true;
            }
            return false;
        });
        switch (entry.getEntryKind()) {
            case 1: {
                return JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)sourceAttachmentPath, null, (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttributes.toArray(new IClasspathAttribute[0]), (boolean)entry.isExported());
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttributes.toArray(new IClasspathAttribute[0]), (boolean)entry.isExported());
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)entry.getPath(), (IPath)sourceAttachmentPath, null, (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])newAttributes.toArray(new IClasspathAttribute[0]), (boolean)entry.isExported());
            }
        }
        return null;
    }

    private static void updateContainerClasspath(IJavaProject javaProject, IPath containerPath, IClasspathEntry newEntry) throws CoreException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
        List<IClasspathEntry> newEntries = SourceAttachmentCommand.updateElements(container.getClasspathEntries(), newEntry, entry -> {
            if (entry.getEntryKind() == newEntry.getEntryKind() && entry.getPath().equals((Object)newEntry.getPath())) {
                return true;
            }
            return false;
        });
        UpdatedClasspathContainer updatedContainer = new UpdatedClasspathContainer(container, newEntries.toArray(new IClasspathEntry[0]));
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            initializer.requestClasspathContainerUpdate(containerPath, javaProject, (IClasspathContainer)updatedContainer);
        }
    }

    private static void updateReferencedClasspathEntry(IJavaProject javaProject, IClasspathEntry newEntry, IProgressMonitor monitor) throws JavaModelException {
        List<IClasspathEntry> newEntries = SourceAttachmentCommand.updateElements(javaProject.getReferencedClasspathEntries(), newEntry, entry -> {
            if (entry.getEntryKind() == newEntry.getEntryKind() && entry.getPath().equals((Object)newEntry.getPath())) {
                return true;
            }
            return false;
        });
        javaProject.setRawClasspath(javaProject.getRawClasspath(), newEntries.toArray(new IClasspathEntry[0]), javaProject.getOutputLocation(), monitor);
    }

    private static void updateProjectClasspath(IJavaProject javaProject, IClasspathEntry newEntry, IProgressMonitor monitor) throws JavaModelException {
        List<IClasspathEntry> newEntries = SourceAttachmentCommand.updateElements(javaProject.getRawClasspath(), newEntry, entry -> {
            if (entry.getEntryKind() == newEntry.getEntryKind() && entry.getPath().equals((Object)newEntry.getPath())) {
                return true;
            }
            return false;
        });
        JavaLanguageServerPlugin.logInfo("Update source attachment " + (newEntry.getSourceAttachmentPath() == null ? null : newEntry.getSourceAttachmentPath().toOSString()) + " to the file " + newEntry.getPath().toOSString());
        javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[0]), monitor);
    }

    private static <T> List<T> updateElements(T[] elements, T newElement, Function<T, Boolean> compare) {
        ArrayList<T> newElements = new ArrayList<T>();
        boolean found = false;
        if (elements != null && elements.length > 0) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T element = TArray[n2];
                if (compare.apply(element).booleanValue()) {
                    if (newElement != null) {
                        newElements.add(newElement);
                    }
                    found = true;
                } else {
                    newElements.add(element);
                }
                ++n2;
            }
        }
        if (!found && newElement != null) {
            newElements.add(newElement);
        }
        return newElements;
    }

    private static CoreException constructCoreException(String message) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", message));
    }

    private static CoreException constructCoreException(String message, Exception original) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", message, (Throwable)original));
    }

    private static class ClasspathEntryWrapper {
        IClasspathEntry original;
        IPath containerPath;
        boolean canEditEncoding;

        public ClasspathEntryWrapper(IClasspathEntry original, IPath containerPath, boolean canEditEncoding) {
            this.original = original;
            this.containerPath = containerPath;
            this.canEditEncoding = canEditEncoding;
        }
    }

    public static class SourceAttachmentAttribute {
        public String jarPath;
        public String sourceAttachmentPath;
        public String sourceAttachmentEncoding;
        public boolean canEditEncoding = true;

        public SourceAttachmentAttribute(String jarPath, String sourceAttachmentPath, String sourceAttachmentEncoding) {
            this.jarPath = jarPath;
            this.sourceAttachmentPath = sourceAttachmentPath;
            this.sourceAttachmentEncoding = sourceAttachmentEncoding;
        }

        public SourceAttachmentAttribute(String jarPath, String sourceAttachmentPath, String sourceAttachmentEncoding, boolean canEditEncoding) {
            this(jarPath, sourceAttachmentPath, sourceAttachmentEncoding);
            this.canEditEncoding = canEditEncoding;
        }
    }

    public static class SourceAttachmentRequest {
        public String classFileUri;
        public SourceAttachmentAttribute attributes;

        public SourceAttachmentRequest(String classFileUri, SourceAttachmentAttribute attributes) {
            this.classFileUri = classFileUri;
            this.attributes = attributes;
        }
    }

    public static class SourceAttachmentResult {
        public String errorMessage;
        public SourceAttachmentAttribute attributes;

        public SourceAttachmentResult(String errorMessage, SourceAttachmentAttribute attributes) {
            this.errorMessage = errorMessage;
            this.attributes = attributes;
        }
    }

    private static class UpdatedClasspathContainer
    implements IClasspathContainer {
        private IClasspathEntry[] fNewEntries;
        private IClasspathContainer fOriginal;

        public UpdatedClasspathContainer(IClasspathContainer original, IClasspathEntry[] newEntries) {
            this.fNewEntries = newEntries;
            this.fOriginal = original;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fNewEntries;
        }

        public String getDescription() {
            return this.fOriginal.getDescription();
        }

        public int getKind() {
            return this.fOriginal.getKind();
        }

        public IPath getPath() {
            return this.fOriginal.getPath();
        }
    }
}

