/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;

public class NodeSetWrapper {
    private MatchingNodeSet wrapped;
    private Set<ASTNode> possibleASTNodes = new LinkedHashSet<ASTNode>();
    public final Map<ASTNode, Integer> trustedASTNodeLevels = new LinkedHashMap<ASTNode, Integer>();

    public NodeSetWrapper(MatchingNodeSet set) {
        this.wrapped = set;
    }

    public MatchingNodeSet getWrapped() {
        return this.wrapped;
    }

    public int addMatch(ASTNode node, int matchLevel) {
        int maskedLevel = matchLevel & 0xF;
        switch (maskedLevel) {
            case 1: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, 1 + (matchLevel & 0xFFFFFFF0));
                    break;
                }
                this.addTrustedMatch(node, MatchingNodeSet.POTENTIAL_MATCH);
                break;
            }
            case 2: {
                this.addPossibleMatch(node);
                break;
            }
            case 4: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, 16 + (matchLevel & 0xFFFFFFF0));
                    break;
                }
                this.addTrustedMatch(node, MatchingNodeSet.ERASURE_MATCH);
                break;
            }
            case 3: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, 0 + (matchLevel & 0xFFFFFFF0));
                    break;
                }
                this.addTrustedMatch(node, MatchingNodeSet.EXACT_MATCH);
            }
        }
        return matchLevel;
    }

    public void addPossibleMatch(ASTNode node) {
        this.possibleASTNodes.add(node);
    }

    public void addTrustedMatch(ASTNode node, boolean isExact) {
        this.addTrustedMatch(node, isExact ? MatchingNodeSet.EXACT_MATCH : MatchingNodeSet.POTENTIAL_MATCH);
    }

    void addTrustedMatch(ASTNode node, Integer level) {
        this.trustedASTNodeLevels.put(node, level);
    }
}

