/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModularClassFile;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class CoreJavaDocLocations {
    private static final String JAR_PROTOCOL = "jar";
    public static final String ARCHIVE_PREFIX = "jar:";
    private static final QualifiedName PROJECT_JAVADOC = new QualifiedName("org.eclipse.jdt.ui", "project_javadoc_location");

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        try {
            String location = url != null ? url.toExternalForm() : null;
            CoreJavaDocLocations.setProjectJavadocLocation(project, location);
        }
        catch (CoreException e) {
            JavaManipulationPlugin.log(e);
        }
    }

    private static void setProjectJavadocLocation(IJavaProject project, String url) throws CoreException {
        project.getProject().setPersistentProperty(PROJECT_JAVADOC, url);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        String prop;
        block4: {
            if (!project.getProject().isAccessible()) {
                return null;
            }
            try {
                prop = project.getProject().getPersistentProperty(PROJECT_JAVADOC);
                if (prop != null) break block4;
                return null;
            }
            catch (CoreException e) {
                JavaManipulationPlugin.log(e);
                return null;
            }
        }
        return CoreJavaDocLocations.parseURL(prop);
    }

    public static URL getLibraryJavadocLocation(IClasspathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int kind = entry.getEntryKind();
        if (kind != 1 && kind != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attrib = iClasspathAttributeArray[n2];
            if ("javadoc_location".equals(attrib.getName())) {
                return CoreJavaDocLocations.parseURL(attrib.getValue());
            }
            ++n2;
        }
        return null;
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        if (element.getElementType() == 2) {
            return CoreJavaDocLocations.getProjectJavadocLocation((IJavaProject)element);
        }
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            IClasspathEntry entry = root.getResolvedClasspathEntry();
            URL javadocLocation = CoreJavaDocLocations.getLibraryJavadocLocation(entry);
            if (javadocLocation != null) {
                return CoreJavaDocLocations.getLibraryJavadocLocation(entry);
            }
            entry = root.getRawClasspathEntry();
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    return CoreJavaDocLocations.getLibraryJavadocLocation(entry);
                }
            }
            return null;
        }
        return CoreJavaDocLocations.getProjectJavadocLocation(root.getJavaProject());
    }

    public static URL getJavadocLocation(IJavaElement element, boolean includeMemberReference) throws JavaModelException {
        URL baseLocation = CoreJavaDocLocations.getJavadocBaseLocation(element);
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer urlBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            urlBuffer.append('/');
        }
        StringBuffer pathBuffer = new StringBuffer();
        StringBuffer fragmentBuffer = new StringBuffer();
        switch (element.getElementType()) {
            case 4: {
                CoreJavaDocLocations.appendPackageSummaryPath((IPackageFragment)element, pathBuffer);
                break;
            }
            case 2: 
            case 3: {
                CoreJavaDocLocations.appendIndexPath(pathBuffer);
                break;
            }
            case 12: {
                element = element.getParent();
            }
            case 5: {
                IType mainType = ((ICompilationUnit)element).findPrimaryType();
                if (mainType == null) {
                    return null;
                }
                CoreJavaDocLocations.appendTypePath(mainType, pathBuffer);
                break;
            }
            case 6: {
                if (element instanceof IModularClassFile) {
                    try {
                        CoreJavaDocLocations.appendModuleSummaryPath(((IModularClassFile)element).getModule(), pathBuffer);
                        break;
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                }
                CoreJavaDocLocations.appendTypePath(((IOrdinaryClassFile)element).getType(), pathBuffer);
                break;
            }
            case 7: {
                CoreJavaDocLocations.appendTypePath((IType)element, pathBuffer);
                break;
            }
            case 8: {
                IField field = (IField)element;
                CoreJavaDocLocations.appendTypePath(field.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                CoreJavaDocLocations.appendFieldReference(field, fragmentBuffer);
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                CoreJavaDocLocations.appendTypePath(method.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                CoreJavaDocLocations.appendMethodReference(method, fragmentBuffer);
                break;
            }
            case 10: {
                CoreJavaDocLocations.appendTypePath(((IMember)element).getDeclaringType(), pathBuffer);
                break;
            }
            case 13: {
                IImportDeclaration decl = (IImportDeclaration)element;
                if (decl.isOnDemand()) {
                    IJavaElement cont = JavaModelUtil.findTypeContainer(element.getJavaProject(), Signature.getQualifier((String)decl.getElementName()));
                    if (cont instanceof IType) {
                        CoreJavaDocLocations.appendTypePath((IType)cont, pathBuffer);
                        break;
                    }
                    if (!(cont instanceof IPackageFragment)) break;
                    CoreJavaDocLocations.appendPackageSummaryPath((IPackageFragment)cont, pathBuffer);
                    break;
                }
                IType imp = element.getJavaProject().findType(decl.getElementName());
                CoreJavaDocLocations.appendTypePath(imp, pathBuffer);
                break;
            }
            case 11: {
                IJavaElement pack = element.getAncestor(4);
                if (pack != null) {
                    CoreJavaDocLocations.appendPackageSummaryPath((IPackageFragment)pack, pathBuffer);
                    break;
                }
                return null;
            }
            case 17: {
                IModuleDescription module = (IModuleDescription)element;
                CoreJavaDocLocations.appendModuleSummaryPath(module, pathBuffer);
                break;
            }
            default: {
                return null;
            }
        }
        return CoreJavaDocLocations.getURL(urlBuffer, pathBuffer, fragmentBuffer);
    }

    private static URL getURL(StringBuffer urlBuffer, StringBuffer pathBuffer, StringBuffer fragmentBuffer) {
        try {
            String fragment = fragmentBuffer.length() == 0 ? null : fragmentBuffer.toString();
            try {
                URI relativeURI = new URI(null, null, pathBuffer.toString(), fragment);
                urlBuffer.append(relativeURI.toString());
                return new URL(urlBuffer.toString());
            }
            catch (URISyntaxException e) {
                JavaManipulationPlugin.log(e);
                return new URL(urlBuffer.append(pathBuffer).toString());
            }
        }
        catch (MalformedURLException e) {
            JavaManipulationPlugin.log(e);
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment pack, StringBuffer buf) {
        CoreJavaDocLocations.appendModulePath(pack, buf);
        String packPath = pack.getElementName().replace('.', '/');
        buf.append(packPath);
        buf.append("/package-summary.html");
    }

    private static void appendModuleSummaryPath(IModuleDescription module, StringBuffer buf) {
        String moduleName = module.getElementName();
        buf.append(moduleName);
        buf.append("/module-summary.html");
    }

    private static void appendIndexPath(StringBuffer buf) {
        buf.append("index.html");
    }

    private static void appendTypePath(IType type, StringBuffer buf) {
        IPackageFragment pack = type.getPackageFragment();
        CoreJavaDocLocations.appendModulePath(pack, buf);
        String packPath = pack.getElementName().replace('.', '/');
        String typePath = type.getTypeQualifiedName('.');
        if (packPath.length() > 0) {
            buf.append(packPath);
            buf.append('/');
        }
        buf.append(typePath);
        buf.append(".html");
    }

    private static void appendModulePath(IPackageFragment pack, StringBuffer buf) {
        String moduleName;
        IModuleDescription moduleDescription = CoreJavaDocLocations.getModuleDescription(pack);
        if (moduleDescription != null && (moduleName = moduleDescription.getElementName()) != null && moduleName.length() > 0) {
            buf.append(moduleName);
            buf.append('/');
        }
    }

    private static IModuleDescription getModuleDescription(IPackageFragment pack) {
        if (pack == null) {
            return null;
        }
        IModuleDescription moduleDescription = null;
        IJavaProject javaProject = pack.getJavaProject();
        if (javaProject != null && CoreJavaDocLocations.is11OrHigher(javaProject)) {
            if (pack.isReadOnly()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getAncestor(3);
                if (root != null) {
                    moduleDescription = root.getModuleDescription();
                }
            } else {
                try {
                    moduleDescription = javaProject.getModuleDescription();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return moduleDescription;
    }

    private static boolean is11OrHigher(IJavaProject javaProject) {
        boolean is11orHigher = false;
        if (javaProject != null) {
            try {
                IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                if (install instanceof AbstractVMInstall) {
                    String vmver = ((AbstractVMInstall)install).getJavaVersion();
                    is11orHigher = JavaModelUtil.is11OrHigher(vmver);
                } else {
                    is11orHigher = JavaModelUtil.is11OrHigher(javaProject);
                }
            }
            catch (CoreException e) {
                is11orHigher = JavaModelUtil.is11OrHigher(javaProject);
            }
        }
        return is11orHigher;
    }

    private static boolean is10OrHigher(IJavaProject javaProject) {
        boolean is10orHigher = false;
        if (javaProject != null) {
            try {
                IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                if (install instanceof AbstractVMInstall) {
                    String vmver = ((AbstractVMInstall)install).getJavaVersion();
                    is10orHigher = JavaModelUtil.is10OrHigher(vmver);
                } else {
                    is10orHigher = JavaModelUtil.is10OrHigher(javaProject);
                }
            }
            catch (CoreException e) {
                is10orHigher = JavaModelUtil.is10OrHigher(javaProject);
            }
        }
        return is10orHigher;
    }

    private static boolean is1d8Or9(IJavaProject javaProject) {
        boolean is1d8Or9 = false;
        String compliance = JavaModelUtil.getSourceCompliance(javaProject);
        if (javaProject != null) {
            try {
                String vmver;
                IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                is1d8Or9 = install instanceof AbstractVMInstall ? !JavaModelUtil.is10OrHigher(vmver = ((AbstractVMInstall)install).getJavaVersion()) : JavaCore.compareJavaVersions((String)compliance, (String)"1.8") == 0 || JavaCore.compareJavaVersions((String)compliance, (String)"9") == 0;
            }
            catch (CoreException e) {
                is1d8Or9 = JavaCore.compareJavaVersions((String)compliance, (String)"1.8") == 0 || JavaCore.compareJavaVersions((String)compliance, (String)"9") == 0;
            }
        }
        return is1d8Or9;
    }

    private static void appendFieldReference(IField field, StringBuffer buf) {
        buf.append(field.getElementName());
    }

    private static void appendMethodReference(IMethod meth, StringBuffer buf) throws JavaModelException {
        buf.append(meth.getElementName());
        IJavaProject javaProject = meth.getJavaProject();
        boolean is1d8Or9 = CoreJavaDocLocations.is1d8Or9(javaProject);
        boolean is10OrHigher = CoreJavaDocLocations.is10OrHigher(javaProject);
        buf.append(is1d8Or9 ? (char)'-' : '(');
        String[] params = meth.getParameterTypes();
        IType declaringType = meth.getDeclaringType();
        boolean isVararg = Flags.isVarargs((int)meth.getFlags());
        int lastParam = params.length - 1;
        int i = 0;
        while (i <= lastParam) {
            String curr;
            String fullName;
            if (i != 0) {
                String paramDelim = is1d8Or9 ? "-" : (is10OrHigher ? "," : ", ");
                buf.append(paramDelim);
            }
            if ((fullName = JavaModelUtil.getResolvedTypeName(curr = Signature.getTypeErasure((String)params[i]), declaringType)) == null) {
                fullName = Signature.toString((String)Signature.getElementType((String)curr));
            }
            if (fullName != null) {
                buf.append(fullName);
                int dim = Signature.getArrayCount((String)curr);
                if (i == lastParam && isVararg) {
                    --dim;
                }
                while (dim > 0) {
                    buf.append(is1d8Or9 ? ":A" : "[]");
                    --dim;
                }
                if (i == lastParam && isVararg) {
                    buf.append("...");
                }
            }
            ++i;
        }
        buf.append(is1d8Or9 ? (char)'-' : ')');
    }

    public static String getBaseURL(IJavaElement element, boolean isBinary, LocationResolver callback) throws JavaModelException {
        if (isBinary) {
            URL baseURL = CoreJavaDocLocations.getJavadocLocation(element, false);
            if (baseURL != null) {
                if (JAR_PROTOCOL.equals(baseURL.getProtocol())) {
                    URL baseURL2;
                    URL uRL = baseURL2 = callback == null ? null : callback.resolve(baseURL);
                    if (baseURL2 != null) {
                        baseURL = baseURL2;
                    }
                }
                return baseURL.toExternalForm();
            }
        } else {
            IPath location;
            IResource resource = element.getResource();
            if (resource != null && (location = resource.getLocation()) != null) {
                return location.toFile().toURI().toString();
            }
        }
        return null;
    }

    public static String getExplanationForMissingJavadoc(IJavaElement element, IPackageFragmentRoot root) {
        String message = null;
        try {
            boolean isBinary;
            boolean bl = isBinary = root.exists() && root.getKind() == 2;
            if (isBinary) {
                boolean hasSource;
                boolean hasAttachedJavadoc = CoreJavaDocLocations.getJavadocBaseLocation(element) != null;
                boolean hasAttachedSource = root.getSourceAttachmentPath() != null;
                IOpenable openable = element.getOpenable();
                boolean bl2 = hasSource = openable.getBuffer() != null;
                if (!hasAttachedSource && !hasAttachedJavadoc) {
                    message = CorextMessages.JavaDocLocations_noAttachments;
                } else if (!hasAttachedJavadoc && !hasSource) {
                    message = CorextMessages.JavaDocLocations_noAttachedJavadoc;
                } else if (!hasAttachedSource) {
                    message = CorextMessages.JavaDocLocations_noAttachedSource;
                } else if (!hasSource) {
                    message = CorextMessages.JavaDocLocations_noInformation;
                }
            }
        }
        catch (JavaModelException e) {
            message = CorextMessages.JavaDocLocations_error_gettingJavadoc;
            JavaManipulationPlugin.log(e);
        }
        return message;
    }

    public static String handleFailedJavadocFetch(CoreException e) {
        IStatus status = e.getStatus();
        if ("org.eclipse.jdt.core".equals(status.getPlugin())) {
            Throwable cause = e.getCause();
            int code = status.getCode();
            if (code == 1012 || code == 1008 && (cause instanceof FileNotFoundException || cause instanceof SocketException || cause instanceof UnknownHostException || cause instanceof ProtocolException)) {
                return CorextMessages.JavaDocLocations_error_gettingAttachedJavadoc;
            }
        }
        JavaManipulationPlugin.log(e);
        return CorextMessages.JavaDocLocations_error_gettingJavadoc;
    }

    public static URL parseURL(String url) {
        try {
            try {
                return new URI(url).toURL();
            }
            catch (URISyntaxException e) {
                try {
                    if (url.startsWith("file:/")) {
                        return new URI("file", null, url.substring(5), null).toURL();
                    }
                    return URIUtil.fromString((String)url).toURL();
                }
                catch (URISyntaxException e1) {
                    JavaManipulationPlugin.log(e);
                    return new URL(url);
                }
            }
        }
        catch (MalformedURLException e) {
            JavaManipulationPlugin.log(e);
            return null;
        }
    }

    public static File toFile(URL url) {
        try {
            return URIUtil.toFile((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            JavaManipulationPlugin.log(e);
            return new File(url.getFile());
        }
    }

    private CoreJavaDocLocations() {
    }

    public static interface LocationResolver {
        public URL resolve(URL var1);
    }
}

