/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.handlers;

import com.github.badsyntax.gradle.ByteBufferOutputStream;
import com.github.badsyntax.gradle.Cancelled;
import com.github.badsyntax.gradle.DependencyItem;
import com.github.badsyntax.gradle.Environment;
import com.github.badsyntax.gradle.ErrorMessageBuilder;
import com.github.badsyntax.gradle.GetBuildReply;
import com.github.badsyntax.gradle.GetBuildRequest;
import com.github.badsyntax.gradle.GetBuildResult;
import com.github.badsyntax.gradle.GradleBuild;
import com.github.badsyntax.gradle.GradleBuildCancellation;
import com.github.badsyntax.gradle.GradleEnvironment;
import com.github.badsyntax.gradle.GradleProject;
import com.github.badsyntax.gradle.GradleProjectConnector;
import com.github.badsyntax.gradle.GradleTask;
import com.github.badsyntax.gradle.GrpcGradleClosure;
import com.github.badsyntax.gradle.GrpcGradleField;
import com.github.badsyntax.gradle.GrpcGradleMethod;
import com.github.badsyntax.gradle.JavaEnvironment;
import com.github.badsyntax.gradle.Output;
import com.github.badsyntax.gradle.Progress;
import com.github.badsyntax.gradle.utils.PluginUtils;
import com.github.badsyntax.gradle.utils.Utils;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.microsoft.gradle.api.GradleClosure;
import com.microsoft.gradle.api.GradleDependencyNode;
import com.microsoft.gradle.api.GradleField;
import com.microsoft.gradle.api.GradleMethod;
import com.microsoft.gradle.api.GradleModelAction;
import com.microsoft.gradle.api.GradleProjectModel;
import io.github.g00fy2.versioncompare.Version;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBuildHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)GetBuildHandler.class.getName());
    private GetBuildRequest req;
    private StreamObserver<GetBuildReply> responseObserver;
    private ProgressListener progressListener;
    private ByteBufferOutputStream standardOutputListener;
    private ByteBufferOutputStream standardErrorListener;
    private Environment environment;

    public GetBuildHandler(GetBuildRequest req, StreamObserver<GetBuildReply> responseObserver) {
        this.req = req;
        this.responseObserver = responseObserver;
        this.progressListener = event -> {
            Class<GetBuildHandler> clazz = GetBuildHandler.class;
            synchronized (GetBuildHandler.class) {
                this.replyWithProgress(event);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
        this.standardOutputListener = new ByteBufferOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFlush(byte[] bytes) {
                Class<GetBuildHandler> clazz = GetBuildHandler.class;
                synchronized (GetBuildHandler.class) {
                    GetBuildHandler.this.replyWithStandardOutput(bytes);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        this.standardErrorListener = new ByteBufferOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFlush(byte[] bytes) {
                Class<GetBuildHandler> clazz = GetBuildHandler.class;
                synchronized (GetBuildHandler.class) {
                    GetBuildHandler.this.replyWithStandardError(bytes);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GradleConnector gradleConnector = GradleProjectConnector.build(this.req.getProjectDir(), this.req.getGradleConfig());
        try (ProjectConnection connection = gradleConnector.connect();){
            String jvmArguments;
            File initScript;
            this.environment = this.buildEnvironment(connection);
            this.replyWithBuildEnvironment(this.environment);
            BuildActionExecuter<GradleProjectModel> action = connection.action(new GradleModelAction());
            if (action == null) {
                this.responseObserver.onCompleted();
                return;
            }
            ArrayList<String> arguments = new ArrayList<String>();
            String debugPlugin = System.getenv("VSCODE_DEBUG_PLUGIN");
            if ("true".equals(debugPlugin)) {
                arguments.add("-Dorg.gradle.debug=true");
            }
            if ((initScript = PluginUtils.getInitScript()) != null) {
                arguments.addAll(Arrays.asList("--init-script", initScript.getAbsolutePath()));
            }
            if (!Strings.isNullOrEmpty((String)(jvmArguments = this.req.getGradleConfig().getJvmArguments()))) {
                arguments.addAll(Arrays.stream(jvmArguments.split(" ")).filter(e -> e != null && !e.isEmpty()).collect(Collectors.toList()));
            }
            action.withArguments(arguments);
            CancellationToken cancellationToken = GradleBuildCancellation.buildToken(this.req.getCancellationKey());
            HashSet<OperationType> progressEvents = new HashSet<OperationType>();
            progressEvents.add(OperationType.PROJECT_CONFIGURATION);
            ((BuildActionExecuter)((BuildActionExecuter)((BuildActionExecuter)((BuildActionExecuter)action.withCancellationToken(cancellationToken)).addProgressListener(this.progressListener, progressEvents)).setStandardOutput(this.standardOutputListener)).setStandardError(this.standardErrorListener)).setColorOutput(this.req.getShowOutputColors());
            GradleProjectModel gradleModel = action.run();
            if (gradleModel == null) {
                throw new Exception("Error occurs in querying custom model.");
            }
            GradleProject project = this.getProjectData(gradleModel);
            this.replyWithProject(project);
        }
        catch (BuildCancelledException e2) {
            this.replyWithCancelled(e2);
        }
        catch (IllegalStateException | ServiceCreationException | GradleConnectionException e3) {
            boolean shouldCheckCompatibility;
            String javaExtensionVersion = this.req.getGradleConfig().getJavaExtensionVersion();
            boolean bl = shouldCheckCompatibility = javaExtensionVersion == null || !new Version(javaExtensionVersion).isAtLeast("1.3.0");
            if (shouldCheckCompatibility) {
                if (this.environment != null) {
                    Version javaVersion;
                    Version gradleVersion = new Version(this.environment.getGradleEnvironment().getGradleVersion());
                    if (Utils.hasCompatibilityError(gradleVersion, javaVersion = new Version(System.getProperty("java.version")))) {
                        this.replyWithCompatibilityCheckError(gradleVersion.getOriginalString(), javaVersion.getOriginalString());
                    }
                } else {
                    String rootCause = this.getRootCause(e3);
                    if (rootCause.contains("Could not determine java version")) {
                        this.replyWithCompatibilityCheckError();
                    }
                }
            }
            logger.error(e3.getMessage());
            this.replyWithError(e3);
        }
        catch (Exception e4) {
            this.replyWithError(e4);
        }
        finally {
            GradleBuildCancellation.clearToken(this.req.getCancellationKey());
        }
    }

    private String getRootCause(Throwable error) {
        Throwable cause;
        Throwable rootCause = error;
        while ((cause = rootCause.getCause()) != null && (cause.getMessage() != null || cause instanceof StackOverflowError)) {
            rootCause = cause;
        }
        return rootCause.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Environment buildEnvironment(ProjectConnection connection) {
        ModelBuilder<BuildEnvironment> buildEnvironment = connection.model(BuildEnvironment.class);
        HashSet<OperationType> progressEvents = new HashSet<OperationType>();
        progressEvents.add(OperationType.GENERIC);
        CancellationToken cancellationToken = GradleBuildCancellation.buildToken(this.req.getCancellationKey());
        ((ModelBuilder)((ModelBuilder)((ModelBuilder)((ModelBuilder)buildEnvironment.withCancellationToken(cancellationToken)).addProgressListener(this.progressListener, progressEvents)).setStandardOutput(this.standardOutputListener)).setStandardError(this.standardErrorListener)).setColorOutput(this.req.getShowOutputColors());
        String jvmArguments = this.req.getGradleConfig().getJvmArguments();
        if (!Strings.isNullOrEmpty((String)jvmArguments)) {
            buildEnvironment.setJvmArguments((String[])Arrays.stream(jvmArguments.split(" ")).filter(e -> e != null && !e.isEmpty()).toArray(String[]::new));
        }
        try {
            BuildEnvironment environment = buildEnvironment.get();
            org.gradle.tooling.model.build.GradleEnvironment gradleEnvironment = environment.getGradle();
            org.gradle.tooling.model.build.JavaEnvironment javaEnvironment = environment.getJava();
            Environment environment2 = Environment.newBuilder().setGradleEnvironment(GradleEnvironment.newBuilder().setGradleUserHome(gradleEnvironment.getGradleUserHome().getAbsolutePath()).setGradleVersion(gradleEnvironment.getGradleVersion())).setJavaEnvironment(JavaEnvironment.newBuilder().setJavaHome(javaEnvironment.getJavaHome().getAbsolutePath()).addAllJvmArgs(javaEnvironment.getJvmArguments())).build();
            return environment2;
        }
        finally {
            GradleBuildCancellation.clearToken(this.req.getCancellationKey());
        }
    }

    private GradleProject getProjectData(GradleProjectModel gradleModel) {
        GradleProject.Builder project = GradleProject.newBuilder();
        project.setIsRoot(gradleModel.getIsRoot());
        project.addAllTasks(this.getGradleTasks(gradleModel));
        ArrayList<GradleProject> subProjects = new ArrayList<GradleProject>();
        for (GradleProjectModel subProjectModel : gradleModel.getSubProjects()) {
            subProjects.add(this.getProjectData(subProjectModel));
        }
        project.addAllProjects(subProjects);
        project.setProjectPath(gradleModel.getProjectPath());
        project.setDependencyItem(this.getDependencyItem(gradleModel.getDependencyNode()));
        project.addAllPlugins(gradleModel.getPlugins());
        project.addAllPluginClosures(this.getPluginClosures(gradleModel));
        project.addAllScriptClasspaths(gradleModel.getScriptClasspaths());
        return project.build();
    }

    private List<GradleTask> getGradleTasks(GradleProjectModel model) {
        ArrayList<GradleTask> tasks = new ArrayList<GradleTask>();
        model.getTasks().forEach(task -> {
            String description;
            GradleTask.Builder builder = GradleTask.newBuilder();
            builder.setName(task.getName()).setPath(task.getPath()).setProject(task.getProject()).setBuildFile(task.getBuildFile()).setRootProject(task.getRootProject()).setDebuggable(task.getDebuggable());
            String group = task.getGroup();
            if (group != null) {
                builder.setGroup(group);
            }
            if ((description = task.getDescription()) != null) {
                builder.setDescription(description);
            }
            tasks.add(builder.build());
        });
        return tasks;
    }

    private DependencyItem getDependencyItem(GradleDependencyNode node) {
        DependencyItem.Builder item = DependencyItem.newBuilder();
        item.setName(node.getName());
        item.setTypeValue(node.getType().ordinal());
        if (node.getChildren() == null) {
            return item.build();
        }
        ArrayList<DependencyItem> children = new ArrayList<DependencyItem>();
        for (GradleDependencyNode child : node.getChildren()) {
            children.add(this.getDependencyItem(child));
        }
        item.addAllChildren(children);
        return item.build();
    }

    private List<GrpcGradleClosure> getPluginClosures(GradleProjectModel model) {
        ArrayList<GrpcGradleClosure> closures = new ArrayList<GrpcGradleClosure>();
        for (GradleClosure closure : model.getClosures()) {
            GrpcGradleClosure.Builder closureBuilder = GrpcGradleClosure.newBuilder();
            for (GradleMethod method : closure.getMethods()) {
                GrpcGradleMethod.Builder methodBuilder = GrpcGradleMethod.newBuilder();
                methodBuilder.setName(method.getName());
                methodBuilder.addAllParameterTypes(method.getParameterTypes());
                methodBuilder.setDeprecated(method.getDeprecated());
                closureBuilder.addMethods(methodBuilder.build());
            }
            closureBuilder.setName(closure.getName());
            for (GradleField field : closure.getFields()) {
                GrpcGradleField.Builder fieldBuilder = GrpcGradleField.newBuilder();
                fieldBuilder.setName(field.getName());
                fieldBuilder.setDeprecated(field.getDeprecated());
                closureBuilder.addFields(fieldBuilder.build());
            }
            closures.add(closureBuilder.build());
        }
        return closures;
    }

    private void replyWithProject(GradleProject gradleProject) {
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setGetBuildResult(GetBuildResult.newBuilder().setBuild(GradleBuild.newBuilder().setProject(gradleProject))).build());
        this.responseObserver.onCompleted();
    }

    private void replyWithCancelled(BuildCancelledException e) {
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setCancelled(Cancelled.newBuilder().setMessage(e.getMessage()).setProjectDir(this.req.getProjectDir())).build());
        this.responseObserver.onCompleted();
    }

    private void replyWithError(Exception e) {
        this.responseObserver.onError((Throwable)ErrorMessageBuilder.build(e));
    }

    private void replyWithBuildEnvironment(Environment environment) {
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setEnvironment(environment).build());
    }

    private void replyWithProgress(ProgressEvent progressEvent) {
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setProgress(Progress.newBuilder().setMessage(progressEvent.getDisplayName())).build());
    }

    private void replyWithStandardOutput(byte[] bytes) {
        ByteString byteString = ByteString.copyFrom((byte[])bytes);
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setOutput(Output.newBuilder().setOutputType(Output.OutputType.STDOUT).setOutputBytes(byteString)).build());
    }

    private void replyWithStandardError(byte[] bytes) {
        ByteString byteString = ByteString.copyFrom((byte[])bytes);
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setOutput(Output.newBuilder().setOutputType(Output.OutputType.STDERR).setOutputBytes(byteString)).build());
    }

    private void replyWithCompatibilityCheckError(String gradleVersion, String javaVersion) {
        String errorMessage = "Could not use Gradle version " + gradleVersion + " and Java version " + javaVersion + " to configure the build. Please consider either to change your Java Runtime or your Gradle settings.";
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setCompatibilityCheckError(errorMessage).build());
    }

    private void replyWithCompatibilityCheckError() {
        String errorMessage = "The current Gradle version requires Java 8 or lower. Please consider to change your Gradle settings.";
        this.responseObserver.onNext((Object)GetBuildReply.newBuilder().setCompatibilityCheckError(errorMessage).build());
    }
}

