/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;

public class DOMMethodLocator
extends DOMPatternLocator {
    private MethodLocator locator;

    public DOMMethodLocator(MethodLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    private IMethodBinding getDOMASTMethodBinding(ITypeBinding type, String methodName, ITypeBinding[] argumentTypes) {
        return Stream.of(type.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), methodName)).filter(method -> DOMMethodLocator.compatibleByErasure(method.getParameterTypes(), argumentTypes)).findAny().orElse(null);
    }

    private static boolean compatibleByErasure(ITypeBinding[] one, ITypeBinding[] other) {
        if (Objects.equals(one, other)) {
            return true;
        }
        if (one == null || other == null || one.length != other.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (Objects.equals(one[i].getErasure(), other[i].getErasure())) continue;
            return false;
        }
        return true;
    }

    @Override
    public LocatorResponse match(MethodDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!this.locator.pattern.findDeclarations) {
            return this.toResponse(0);
        }
        if (!this.locator.matchesName(this.locator.pattern.selector, node.getName().getIdentifier().toCharArray())) {
            return this.toResponse(0);
        }
        boolean resolve = this.locator.pattern.mustResolve;
        if (this.locator.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            List args = node.parameters();
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return this.toResponse(0);
            }
            for (int i = 0; i < argsLength; ++i) {
                SingleVariableDeclaration arg = (SingleVariableDeclaration)args.get(i);
                if (this.matchesTypeReference(this.locator.pattern.parameterSimpleNames[i], arg.getType(), arg.isVarargs())) continue;
                if (this.locator.mayBeGeneric) {
                    if (this.locator.pattern.mustResolve) continue;
                    nodeSet.setMustResolve(true);
                    resolve = true;
                    continue;
                }
                return this.toResponse(0);
            }
        }
        if (this.locator.pattern.hasMethodArguments() && (node.typeParameters() == null || node.typeParameters().size() != this.locator.pattern.methodArguments.length)) {
            return this.toResponse(0);
        }
        int level = nodeSet.addMatch((ASTNode)node, resolve ? 2 : 3);
        return this.toResponse(level, true);
    }

    private int matchReference(SimpleName name, List<?> args, NodeSetWrapper nodeSet) {
        if (!this.locator.pattern.findReferences) {
            return 0;
        }
        if (!this.locator.matchesName(this.locator.pattern.selector, name.getIdentifier().toCharArray())) {
            return 0;
        }
        if (this.locator.pattern.parameterSimpleNames != null && (!this.locator.pattern.varargs || DOMASTNodeUtils.insideDocComment((ASTNode)name))) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return 0;
            }
        }
        return this.locator.pattern.mustResolve ? 2 : 3;
    }

    @Override
    public LocatorResponse match(MethodInvocation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int level = this.matchReference(node.getName(), node.arguments(), nodeSet);
        if (level == 0) {
            return this.toResponse(0);
        }
        return this.toResponse(nodeSet.addMatch((ASTNode)node, level), true);
    }

    @Override
    public LocatorResponse match(Expression expression, NodeSetWrapper nodeSet, MatchLocator locator) {
        int level;
        if (expression instanceof SuperMethodInvocation) {
            SuperMethodInvocation node = (SuperMethodInvocation)expression;
            v0 = this.matchReference(node.getName(), node.arguments(), nodeSet);
        } else {
            v0 = level = 0;
        }
        if (level == 0) {
            return this.toResponse(0);
        }
        return this.toResponse(nodeSet.addMatch((ASTNode)expression, level), true);
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        String lastSegment;
        String name = node.toString();
        String[] segments = name.split("\\.");
        String string = lastSegment = segments == null || segments.length == 0 ? null : segments[segments.length - 1];
        boolean matchesLastSegment = this.locator.pattern.selector == null ? true : this.locator.matchesName(this.locator.pattern.selector, (lastSegment == null ? "" : lastSegment).toCharArray());
        boolean matchesPrefix = this.locator.pattern.declaringPackageName == null ? true : name.startsWith(new String(this.locator.pattern.declaringPackageName));
        int level = matchesLastSegment && matchesPrefix ? 2 : 0;
        return this.toResponse(level);
    }

    protected int matchMethod(IMethodBinding method, boolean skipImpossibleArg) {
        int parameterCount;
        int newLevel;
        if (!this.locator.matchesName(this.locator.pattern.selector, method.getName().toCharArray())) {
            return 0;
        }
        int level = 3;
        if (this.locator.pattern.declaringSimpleName == null && level > (newLevel = this.resolveLevelForType(this.locator.pattern.returnSimpleName, this.locator.pattern.returnQualification, method.getReturnType()))) {
            if (newLevel == 0) {
                return 0;
            }
            level = newLevel;
        }
        int n = parameterCount = this.locator.pattern.parameterSimpleNames == null ? -1 : this.locator.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.getParameterTypes() == null) {
                return 1;
            }
            if (parameterCount != method.getParameterTypes().length) {
                return 0;
            }
            if (method.isRecovered()) {
                return 1;
            }
            boolean foundTypeVariable = false;
            IMethodBinding focusMethodBinding = null;
            boolean checkedFocus = false;
            boolean isBinary = this.locator.pattern != null && this.locator.pattern.focus instanceof BinaryMethod;
            for (int i = 0; i < parameterCount; ++i) {
                ITypeBinding argType = method.getParameterTypes()[i];
                int newLevel2 = 0;
                boolean foundLevel = false;
                if (argType.isMember() || this.locator.pattern.parameterQualifications[i] != null) {
                    ITypeBinding[] parameters;
                    if (!checkedFocus) {
                        focusMethodBinding = this.getDOMASTMethodBinding(this.locator.pattern);
                        checkedFocus = true;
                    }
                    if (focusMethodBinding != null && (parameters = focusMethodBinding.getParameterTypes()).length >= parameterCount) {
                        foundLevel = true;
                    }
                } else {
                    newLevel2 = this.resolveLevelForType(this.locator.pattern.parameterSimpleNames[i], this.locator.pattern.parameterQualifications[i], argType);
                }
                if (level <= newLevel2) continue;
                if (newLevel2 == 0) {
                    if (skipImpossibleArg) {
                        if (!foundLevel) {
                            newLevel2 = level;
                        }
                    } else if (argType.isTypeVariable()) {
                        newLevel2 = level;
                        foundTypeVariable = true;
                    } else {
                        return 0;
                    }
                }
                level = newLevel2;
            }
            if (foundTypeVariable) {
                if (!Modifier.isStatic((int)method.getModifiers()) && !Modifier.isPrivate((int)method.getModifiers())) {
                    if (!checkedFocus) {
                        focusMethodBinding = this.getDOMASTMethodBinding(this.locator.pattern);
                    }
                    if (focusMethodBinding != null && (focusMethodBinding.overrides(method) || method.overrides(focusMethodBinding))) {
                        return 3;
                    }
                }
                return 0;
            }
        }
        return level;
    }

    public IMethodBinding getDOMASTMethodBinding(MethodPattern methodPattern) {
        return null;
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding instanceof IMethodBinding) {
            boolean subType;
            IMethodBinding method = (IMethodBinding)binding;
            boolean skipVerif = this.locator.pattern.findDeclarations && this.locator.mayBeGeneric;
            int methodLevel = this.matchMethod(method, skipVerif);
            if (methodLevel == 0) {
                if (method != method.getMethodDeclaration()) {
                    methodLevel = this.matchMethod(method.getMethodDeclaration(), skipVerif);
                }
                if (methodLevel == 0) {
                    return this.toResponse(0);
                }
                method = method.getMethodDeclaration();
            }
            if (node instanceof Name) {
                boolean patternHasTypeArgs;
                boolean bl = patternHasTypeArgs = this.locator.pattern.parameterSimpleNames != null && this.locator.pattern.parameterSimpleNames.length > 0 && this.locator.pattern.parameterSimpleNames[0] != null;
                if (patternHasTypeArgs) {
                    return this.toResponse(0);
                }
            }
            if (this.locator.pattern.declaringSimpleName == null && this.locator.pattern.declaringQualification == null) {
                return this.toResponse(methodLevel);
            }
            boolean bl = subType = (method.getModifiers() & 8) == 0 && (method.getModifiers() & 2) == 0;
            if (subType && this.locator.pattern.declaringQualification != null && method.getDeclaringClass() != null && method.getDeclaringClass().getPackage() != null) {
                boolean bl2 = subType = CharOperation.compareWith((char[])this.locator.pattern.declaringQualification, (char[])method.getDeclaringClass().getPackage().getName().toCharArray()) == 0;
            }
            int declaringLevel = subType ? this.resolveLevelAsSubtype(this.locator.pattern.declaringSimpleName, this.locator.pattern.declaringQualification, method.getDeclaringClass(), method.getName(), null, method.getDeclaringClass().getPackage().getName(), (method.getModifiers() & 0x10000) != 0) : this.resolveLevelForType(this.locator.pattern.declaringSimpleName, this.locator.pattern.declaringQualification, method.getDeclaringClass());
            int level = (methodLevel & 0xF) > (declaringLevel & 0xF) ? declaringLevel : methodLevel;
            return this.toResponse(level);
        }
        return this.toResponse(1);
    }

    protected int resolveLevelAsSubtype(char[] simplePattern, char[] qualifiedPattern, ITypeBinding type, String methodName, ITypeBinding[] argumentTypes, String packageName, boolean isDefault) {
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(simplePattern, qualifiedPattern, type);
        if (level != 0) {
            IMethodBinding method;
            if (isDefault && !Objects.equals(packageName, type.getPackage().getName())) {
                return 0;
            }
            IMethodBinding iMethodBinding = method = argumentTypes == null ? null : this.getDOMASTMethodBinding(type, methodName, argumentTypes);
            if (!((method == null || Modifier.isAbstract((int)method.getModifiers())) && Modifier.isAbstract((int)type.getModifiers()) || type.isInterface())) {
                level |= 0x800;
            }
            return level;
        }
        if (!type.isInterface() && !type.getQualifiedName().equals(Object.class.getName()) && (level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, type.getSuperclass(), methodName, argumentTypes, packageName, isDefault)) != 0) {
            IMethodBinding method;
            if (argumentTypes != null && (method = this.getDOMASTMethodBinding(type, methodName, argumentTypes)) != null) {
                if ((level & 0x800) != 0) {
                    return 0;
                }
                if (!Modifier.isAbstract((int)method.getModifiers()) && !type.isInterface()) {
                    level |= 0x800;
                }
            }
            return level | 0x400;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        if (interfaces == null) {
            return 1;
        }
        for (ITypeBinding ref : interfaces) {
            level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, ref, methodName, null, packageName, isDefault);
            if (level == 0) continue;
            if (!Modifier.isAbstract((int)type.getModifiers()) && !type.isInterface()) {
                level |= 0x800;
            }
            return level | 0x400;
        }
        return 0;
    }
}

