/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.util.JUnitPlugin;
import com.microsoft.java.test.plugin.util.ProjectTestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.Location;

public class TestNavigationUtils {
    public static TestNavigationResult findTestOrTarget(List<Object> arguments, IProgressMonitor monitor) throws JavaModelException {
        String typeName;
        if (arguments == null || arguments.size() < 2) {
            throw new IllegalArgumentException("Wrong arguments passed to findTestOrTarget().");
        }
        String typeUri = (String)arguments.get(0);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)typeUri);
        if (unit == null) {
            JUnitPlugin.logError("Failed to resolve compilation unit from " + typeUri);
            return null;
        }
        IType primaryType = unit.findPrimaryType();
        Location location = null;
        if (primaryType != null) {
            typeName = primaryType.getElementName();
            location = JDTUtils.toLocation((IJavaElement)primaryType, (JDTUtils.LocationType)JDTUtils.LocationType.NAME_RANGE);
        } else {
            typeName = unit.getElementName().substring(0, unit.getElementName().lastIndexOf(".java"));
        }
        SearchEngine searchEngine = new SearchEngine();
        boolean goToTest = (Boolean)arguments.get(1);
        String nameToSearch = goToTest ? typeName : TestNavigationUtils.guessTestSubjectName(typeName);
        IJavaSearchScope scope = TestNavigationUtils.getSearchScope(goToTest);
        IJavaProject javaProject = unit.getJavaProject();
        HashSet<TestNavigationItem> items = new HashSet<TestNavigationItem>();
        searchEngine.searchAllTypeNames(null, 0, ("*" + nameToSearch + "*").toCharArray(), 2, 5, scope, (TypeNameRequestor)new TestNavigationNameRequestor(items, javaProject, nameToSearch, typeName, goToTest), 3, monitor);
        return new TestNavigationResult(items, location);
    }

    private static IJavaSearchScope getSearchScope(boolean isTest) throws JavaModelException {
        IJavaProject[] javaProjects;
        LinkedList<IPackageFragmentRoot> javaElements = new LinkedList<IPackageFragmentRoot>();
        IJavaProject[] iJavaProjectArray = javaProjects = ProjectUtils.getJavaProjects();
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            List<IClasspathEntry> testEntries = isTest ? ProjectTestUtils.getTestEntries(project) : ProjectTestUtils.getSourceEntries(project);
            for (IClasspathEntry entry : testEntries) {
                javaElements.addAll(Arrays.asList(project.findPackageFragmentRoots(entry)));
            }
            ++n2;
        }
        return SearchEngine.createJavaSearchScope((!isTest ? 1 : 0) != 0, (IJavaElement[])javaElements.toArray(new IJavaElement[0]), (boolean)true);
    }

    private static String guessTestSubjectName(String testTypeName) {
        return testTypeName.replaceAll("Tests?", "");
    }

    static final class TestNavigationItem {
        public String simpleName;
        public String fullyQualifiedName;
        public String uri;
        public int relevance;
        public boolean outOfBelongingProject;

        public TestNavigationItem(String simpleName, String fullyQualifiedName, String uri, int relevance, boolean outOfBelongingProject) {
            this.simpleName = simpleName;
            this.fullyQualifiedName = fullyQualifiedName;
            this.uri = uri;
            this.relevance = relevance;
            this.outOfBelongingProject = outOfBelongingProject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestNavigationItem other = (TestNavigationItem)obj;
            return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
        }
    }

    static final class TestNavigationNameRequestor
    extends TypeNameRequestor {
        private final Set<TestNavigationItem> results;
        private final IJavaProject javaProject;
        private final String typeNameToSearch;
        private final String from;
        private final boolean isTest;

        private TestNavigationNameRequestor(Set<TestNavigationItem> results, IJavaProject javaProject, String typeNameToSearch, String from, boolean isTest) {
            this.results = results;
            this.javaProject = javaProject;
            this.typeNameToSearch = typeNameToSearch;
            this.from = from;
            this.isTest = isTest;
        }

        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            if (!path.endsWith(".java")) {
                return;
            }
            Path fullPath = new Path(path);
            IFile file = this.javaProject.getProject().getFile(fullPath.makeRelativeTo(this.javaProject.getProject().getFullPath()));
            if (!file.exists()) {
                return;
            }
            String uri = file.getLocation().toFile().toURI().toString();
            String simpleName = enclosingTypeNames.length == 0 ? String.valueOf(simpleTypeName) : String.valueOf(enclosingTypeNames[0]);
            if (Objects.equals(simpleName, this.from)) {
                return;
            }
            if (!this.isTest && (simpleName.endsWith("Test") || simpleName.endsWith("Tests"))) {
                return;
            }
            String fullyQualifiedName = String.valueOf(packageName) + "." + simpleName;
            int relevance = this.calculateRelevance(simpleName);
            boolean outOfBelongingProject = !Objects.equals(this.javaProject.getElementName(), fullPath.segment(0));
            this.results.add(new TestNavigationItem(simpleName, fullyQualifiedName, uri, relevance, outOfBelongingProject));
        }

        private int calculateRelevance(String simpleName) {
            if (this.isTest && (Objects.equals(simpleName, this.typeNameToSearch + "Test") || Objects.equals(simpleName, this.typeNameToSearch + "Tests"))) {
                return Integer.MIN_VALUE;
            }
            int relevance = simpleName.indexOf(this.typeNameToSearch);
            if (relevance < 0) {
                relevance = Integer.MAX_VALUE;
            }
            return relevance;
        }
    }

    static final class TestNavigationResult {
        public Collection<TestNavigationItem> items;
        public Location location;

        public TestNavigationResult(Collection<TestNavigationItem> items, Location location) {
            this.items = items;
            this.location = location;
        }
    }
}

