/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.xbean.classloader.NamedClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends NamedClassLoader {
    private static final Enumeration<URL> EMPTY_ENUMERATION = Collections.enumeration(new ArrayList());
    private final ClassLoader[] parents;
    private final boolean inverseClassLoading;
    private final String[] hiddenClasses;
    private final String[] nonOverridableClasses;
    private final String[] hiddenResources;
    private final String[] nonOverridableResources;

    public MultiParentClassLoader(String name, URL[] urls) {
        this(name, urls, ClassLoader.getSystemClassLoader());
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent) {
        this(name, urls, new ClassLoader[]{parent});
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(name, urls, new ClassLoader[]{parent}, factory);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents) {
        this(name, urls, parents, false, new String[0], new String[0]);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader parent, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        this(name, urls, new ClassLoader[]{parent}, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents, URLStreamHandlerFactory factory) {
        super(name, urls, null, factory);
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = false;
        this.hiddenClasses = new String[0];
        this.nonOverridableClasses = new String[0];
        this.hiddenResources = new String[0];
        this.nonOverridableResources = new String[0];
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, Collection<String> hiddenClasses, Collection<String> nonOverridableClasses) {
        this(name, urls, parents, inverseClassLoading, hiddenClasses.toArray(new String[hiddenClasses.size()]), nonOverridableClasses.toArray(new String[nonOverridableClasses.size()]));
    }

    public MultiParentClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(name, urls);
        this.parents = MultiParentClassLoader.copyParents(parents);
        this.inverseClassLoading = inverseClassLoading;
        this.hiddenClasses = hiddenClasses;
        this.nonOverridableClasses = nonOverridableClasses;
        this.hiddenResources = MultiParentClassLoader.toResources(hiddenClasses);
        this.nonOverridableResources = MultiParentClassLoader.toResources(nonOverridableClasses);
    }

    private static String[] toResources(String[] classes) {
        String[] resources = new String[classes.length];
        int i = 0;
        while (i < classes.length) {
            String className = classes[i];
            resources[i] = className.replace('.', '/');
            ++i;
        }
        return resources;
    }

    private static ClassLoader[] copyParents(ClassLoader[] parents) {
        ClassLoader[] newParentsArray = new ClassLoader[parents.length];
        int i = 0;
        while (i < parents.length) {
            ClassLoader parent = parents[i];
            if (parent == null) {
                throw new NullPointerException("parent[" + i + "] is null");
            }
            newParentsArray[i] = parent;
            ++i;
        }
        return newParentsArray;
    }

    public ClassLoader[] getParents() {
        return this.parents;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            return this.resolveClass(cachedClass, resolve);
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableClass(name)) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
        }
        if (!this.isHiddenClass(name)) {
            int i = 0;
            while (i < this.parents.length) {
                ClassLoader parent = this.parents[i];
                try {
                    Class<?> clazz = parent.loadClass(name);
                    return this.resolveClass(clazz, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ++i;
                }
            }
        }
        if (!this.isDestroyed()) {
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(String.valueOf(name) + " in classloader " + this.getName());
    }

    private boolean isNonOverridableClass(String name) {
        int i = 0;
        while (i < this.nonOverridableClasses.length) {
            if (name.startsWith(this.nonOverridableClasses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isHiddenClass(String name) {
        int i = 0;
        while (i < this.hiddenClasses.length) {
            if (name.startsWith(this.hiddenClasses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.isDestroyed()) {
            return null;
        }
        if (this.inverseClassLoading && !this.isDestroyed() && !this.isNonOverridableResource(name) && (url = this.findResource(name)) != null) {
            return url;
        }
        if (!this.isHiddenResource(name)) {
            int i = 0;
            while (i < this.parents.length) {
                ClassLoader parent = this.parents[i];
                URL url2 = parent.getResource(name);
                if (url2 != null) {
                    return url2;
                }
                ++i;
            }
        }
        if (!this.isDestroyed()) {
            return this.findResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.isDestroyed()) {
            return EMPTY_ENUMERATION;
        }
        ArrayList<URL> resources = new ArrayList<URL>();
        if (this.inverseClassLoading && !this.isDestroyed()) {
            ArrayList<URL> myResources = Collections.list(super.findResources(name));
            resources.addAll(myResources);
        }
        int i = 0;
        while (i < this.parents.length) {
            ClassLoader parent = this.parents[i];
            ArrayList<URL> parentResources = Collections.list(parent.getResources(name));
            resources.addAll(parentResources);
            ++i;
        }
        if (!this.inverseClassLoading && !this.isDestroyed()) {
            ArrayList<URL> myResources = Collections.list(super.findResources(name));
            resources.addAll(myResources);
        }
        return Collections.enumeration(resources);
    }

    private boolean isNonOverridableResource(String name) {
        int i = 0;
        while (i < this.nonOverridableResources.length) {
            if (name.startsWith(this.nonOverridableResources[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isHiddenResource(String name) {
        int i = 0;
        while (i < this.hiddenResources.length) {
            if (name.startsWith(this.hiddenResources[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + ":" + " name=" + this.getName() + " urls=" + Arrays.asList(this.getURLs()) + " parents=" + Arrays.asList(this.parents) + "]";
    }
}

