/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.codemanipulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class PartialSortMembersOperation {
    public static final String CONTAINS_MALFORMED_NODES = "malformed";
    private Comparator comparator;
    private IJavaElement[] elements;

    public PartialSortMembersOperation(IJavaElement[] elements, Comparator comparator) {
        this.elements = elements;
        this.comparator = comparator;
    }

    boolean checkMalformedNodes(ASTNode node) {
        Object property = node.getProperty(CONTAINS_MALFORMED_NODES);
        if (property == null) {
            return false;
        }
        return (Boolean)property;
    }

    protected boolean isMalformed(ASTNode node) {
        return (node.getFlags() & 1) != 0;
    }

    public TextEdit calculateEdit(CompilationUnit unit, List<ASTNode> selectedNodes, TextEditGroup group) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)this.elements[0];
        String content = cu.getBuffer().getContents();
        ASTRewrite rewrite = this.sortCompilationUnit(unit, selectedNodes, group);
        if (rewrite == null) {
            return null;
        }
        Document document = new Document(content);
        return rewrite.rewriteAST((IDocument)document, cu.getOptions(true));
    }

    private ASTRewrite sortCompilationUnit(CompilationUnit ast, final List<ASTNode> selectedNodes, final TextEditGroup group) {
        ast.accept(new ASTVisitor(){

            public boolean visit(CompilationUnit compilationUnit) {
                List types = compilationUnit.types();
                boolean contains_malformed_nodes = false;
                for (AbstractTypeDeclaration typeDeclaration : types) {
                    typeDeclaration.setProperty("relativeOrder", (Object)typeDeclaration.getStartPosition());
                    contains_malformed_nodes |= PartialSortMembersOperation.this.isMalformed((ASTNode)typeDeclaration);
                }
                compilationUnit.setProperty(PartialSortMembersOperation.CONTAINS_MALFORMED_NODES, (Object)contains_malformed_nodes);
                return true;
            }

            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                List bodyDeclarations = annotationTypeDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", (Object)bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= PartialSortMembersOperation.this.isMalformed((ASTNode)bodyDeclaration);
                }
                annotationTypeDeclaration.setProperty(PartialSortMembersOperation.CONTAINS_MALFORMED_NODES, (Object)contains_malformed_nodes);
                return true;
            }

            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", (Object)bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= PartialSortMembersOperation.this.isMalformed((ASTNode)bodyDeclaration);
                }
                anonymousClassDeclaration.setProperty(PartialSortMembersOperation.CONTAINS_MALFORMED_NODES, (Object)contains_malformed_nodes);
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration) {
                List bodyDeclarations = typeDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", (Object)bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= PartialSortMembersOperation.this.isMalformed((ASTNode)bodyDeclaration);
                }
                typeDeclaration.setProperty(PartialSortMembersOperation.CONTAINS_MALFORMED_NODES, (Object)contains_malformed_nodes);
                return true;
            }

            public boolean visit(EnumDeclaration enumDeclaration) {
                List bodyDeclarations = enumDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", (Object)bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= PartialSortMembersOperation.this.isMalformed((ASTNode)bodyDeclaration);
                }
                List enumConstants = enumDeclaration.enumConstants();
                for (EnumConstantDeclaration enumConstantDeclaration : enumConstants) {
                    enumConstantDeclaration.setProperty("relativeOrder", (Object)enumConstantDeclaration.getStartPosition());
                    contains_malformed_nodes |= PartialSortMembersOperation.this.isMalformed((ASTNode)enumConstantDeclaration);
                }
                enumDeclaration.setProperty(PartialSortMembersOperation.CONTAINS_MALFORMED_NODES, (Object)contains_malformed_nodes);
                return true;
            }
        });
        final ASTRewrite rewriter = ASTRewrite.create((AST)ast.getAST());
        final boolean[] hasChanges = new boolean[1];
        ast.accept(new ASTVisitor(){

            private void sortElements(List elements, ListRewrite listRewrite) {
                if (elements.size() == 0) {
                    return;
                }
                ArrayList myCopy = new ArrayList();
                myCopy.addAll(elements);
                Collections.sort(myCopy, PartialSortMembersOperation.this.comparator);
                int i = 0;
                while (i < elements.size()) {
                    ASTNode newNode;
                    ASTNode oldNode = (ASTNode)elements.get(i);
                    if (oldNode != (newNode = (ASTNode)myCopy.get(i))) {
                        listRewrite.replace(oldNode, rewriter.createMoveTarget(newNode), group);
                        hasChanges[0] = true;
                    }
                    ++i;
                }
            }

            public boolean visit(CompilationUnit compilationUnit) {
                if (PartialSortMembersOperation.this.checkMalformedNodes((ASTNode)compilationUnit)) {
                    return true;
                }
                this.sortElements(selectedNodes.stream().filter(node -> compilationUnit.types().contains(node)).collect(Collectors.toList()), rewriter.getListRewrite((ASTNode)compilationUnit, CompilationUnit.TYPES_PROPERTY));
                return true;
            }

            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                if (PartialSortMembersOperation.this.checkMalformedNodes((ASTNode)annotationTypeDeclaration)) {
                    return true;
                }
                this.sortElements(selectedNodes.stream().filter(node -> annotationTypeDeclaration.bodyDeclarations().contains(node)).collect(Collectors.toList()), rewriter.getListRewrite((ASTNode)annotationTypeDeclaration, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                if (PartialSortMembersOperation.this.checkMalformedNodes((ASTNode)anonymousClassDeclaration)) {
                    return true;
                }
                this.sortElements(selectedNodes.stream().filter(node -> anonymousClassDeclaration.bodyDeclarations().contains(node)).collect(Collectors.toList()), rewriter.getListRewrite((ASTNode)anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration) {
                if (PartialSortMembersOperation.this.checkMalformedNodes((ASTNode)typeDeclaration)) {
                    return true;
                }
                this.sortElements(selectedNodes.stream().filter(node -> typeDeclaration.bodyDeclarations().contains(node)).collect(Collectors.toList()), rewriter.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            public boolean visit(EnumDeclaration enumDeclaration) {
                if (PartialSortMembersOperation.this.checkMalformedNodes((ASTNode)enumDeclaration)) {
                    return true;
                }
                this.sortElements(selectedNodes.stream().filter(node -> enumDeclaration.bodyDeclarations().contains(node)).collect(Collectors.toList()), rewriter.getListRewrite((ASTNode)enumDeclaration, EnumDeclaration.BODY_DECLARATIONS_PROPERTY));
                this.sortElements(selectedNodes.stream().filter(node -> enumDeclaration.bodyDeclarations().contains(node)).collect(Collectors.toList()), rewriter.getListRewrite((ASTNode)enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY));
                return true;
            }
        });
        if (!hasChanges[0]) {
            return null;
        }
        return rewriter;
    }
}

