/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.managers.InvisibleProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class DocumentLifeCycleHandler
extends BaseDocumentLifeCycleHandler {
    private JavaClientConnection connection;

    public DocumentLifeCycleHandler(JavaClientConnection connection, PreferenceManager preferenceManager, ProjectsManager projectsManager, boolean delayValidation) {
        super(preferenceManager, delayValidation);
        this.connection = connection;
    }

    @Override
    public BaseDiagnosticsHandler createDiagnosticsHandler(ICompilationUnit unit) {
        return new DiagnosticsHandler(this.connection, unit);
    }

    @Override
    public boolean isSyntaxMode(ICompilationUnit unit) {
        return JDTUtils.isDefaultProject(unit) || !JDTUtils.isOnClassPath(unit);
    }

    @Override
    public ICompilationUnit resolveCompilationUnit(String uri) {
        ICompilationUnit unit = null;
        IFile resource = JDTUtils.findFile(uri);
        if (resource != null) {
            unit = JDTUtils.resolveCompilationUnit(resource);
        } else {
            IPath filePath = ResourceUtils.canonicalFilePathFromURI(uri);
            if (filePath != null) {
                Collection<IPath> rootPaths = this.preferenceManager.getPreferences().getRootPaths();
                Optional<IPath> belongedRootPath = rootPaths.stream().filter(rootPath -> rootPath.isPrefixOf(filePath)).findFirst();
                boolean invisibleProjectEnabled = false;
                if (belongedRootPath.isPresent()) {
                    IPath rootPath2 = belongedRootPath.get();
                    try {
                        invisibleProjectEnabled = InvisibleProjectImporter.loadInvisibleProject(filePath, rootPath2, false, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException("Failed to load invisible project", e);
                    }
                    if (invisibleProjectEnabled) {
                        unit = JDTUtils.resolveCompilationUnit(uri);
                    }
                }
                if (!invisibleProjectEnabled) {
                    unit = JDTUtils.getFakeCompilationUnit(uri);
                }
            }
        }
        return unit;
    }
}

