/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.JdtCoreDomPackagePrivateUtility;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeArgumentMatchingUtility;

public class DOMMethodLocator
extends DOMPatternLocator {
    private MethodLocator locator;

    public DOMMethodLocator(MethodLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    private IMethodBinding getDOMASTMethodBinding(ITypeBinding type, String methodName, ITypeBinding[] argumentTypes) {
        return Stream.of(type.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), methodName)).filter(method -> DOMMethodLocator.compatibleByErasure(method.getParameterTypes(), argumentTypes)).findAny().orElse(null);
    }

    private static boolean compatibleByErasure(ITypeBinding[] one, ITypeBinding[] other) {
        if (Objects.equals(one, other)) {
            return true;
        }
        if (one == null || other == null || one.length != other.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (Objects.equals(one[i].getErasure(), other[i].getErasure())) continue;
            return false;
        }
        return true;
    }

    @Override
    public LocatorResponse match(MethodDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!this.locator.pattern.findDeclarations) {
            return this.toResponse(0);
        }
        if (!this.locator.matchesName(this.locator.pattern.selector, node.getName().getIdentifier().toCharArray())) {
            return this.toResponse(0);
        }
        boolean resolve = this.locator.pattern.mustResolve;
        if (this.locator.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            List args = node.parameters();
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return this.toResponse(0);
            }
            for (int i = 0; i < argsLength; ++i) {
                SingleVariableDeclaration arg = (SingleVariableDeclaration)args.get(i);
                if (this.matchesTypeReference(this.locator.pattern.parameterSimpleNames[i], arg.getType(), arg.isVarargs())) continue;
                if (this.locator.mayBeGeneric) {
                    if (this.locator.pattern.mustResolve) continue;
                    nodeSet.setMustResolve(true);
                    resolve = true;
                    continue;
                }
                return this.toResponse(0);
            }
        }
        if (this.locator.pattern.hasMethodArguments() && (node.typeParameters() == null || node.typeParameters().size() != this.locator.pattern.methodArguments.length)) {
            return this.toResponse(0);
        }
        int level = nodeSet.addMatch((ASTNode)node, resolve ? 2 : 3);
        return this.toResponse(level, true);
    }

    @Override
    public LocatorResponse match(AnnotationTypeMemberDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(this.locator.pattern.findDeclarations && this.locator.matchesName(this.locator.pattern.selector, node.getName().getIdentifier().toCharArray()) ? 2 : 0);
    }

    @Override
    public LocatorResponse match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int n;
        if (this.locator.pattern.findReferences && node instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnot = (SingleMemberAnnotation)node;
            n = 2;
        } else {
            n = 0;
        }
        return this.toResponse(n);
    }

    private int matchReference(SimpleName name, List<?> args) {
        if (!this.locator.pattern.findReferences) {
            return 0;
        }
        if (!this.locator.matchesName(this.locator.pattern.selector, name.getIdentifier().toCharArray())) {
            return 0;
        }
        if (this.locator.pattern.parameterSimpleNames != null && (!this.locator.pattern.varargs || DOMASTNodeUtils.insideDocComment((ASTNode)name))) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return 0;
            }
        }
        return this.locator.pattern.mustResolve ? 2 : 3;
    }

    @Override
    public LocatorResponse match(MethodInvocation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int level = this.matchReference(node.getName(), node.arguments());
        if (level == 0) {
            return this.toResponse(0);
        }
        return this.toResponse(nodeSet.addMatch((ASTNode)node, level), true);
    }

    @Override
    public LocatorResponse match(Expression expression, NodeSetWrapper nodeSet, MatchLocator locator) {
        int level = 0;
        if (expression instanceof SuperMethodInvocation) {
            SuperMethodInvocation node = (SuperMethodInvocation)expression;
            level = this.matchReference(node.getName(), node.arguments());
        }
        if (expression.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY && this.locator.pattern.matchesName(this.locator.pattern.selector, "value".toCharArray()) && this.locator.pattern.parameterCount == 0) {
            level = 2;
        }
        if (level == 0) {
            return this.toResponse(0);
        }
        return this.toResponse(nodeSet.addMatch((ASTNode)expression, level), true);
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        String lastSegment;
        MethodInvocation mi;
        ASTNode aSTNode = node.getParent();
        if (aSTNode instanceof MethodInvocation && (mi = (MethodInvocation)aSTNode).getName() == node) {
            return this.toResponse(0);
        }
        if (node.getLocationInParent() == MemberValuePair.NAME_PROPERTY && this.locator.pattern.parameterCount == 0 && node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            return this.toResponse(this.matchReference(simpleName, null));
        }
        String name = node.toString();
        String[] segments = name.split("\\.");
        String string = lastSegment = segments == null || segments.length == 0 ? null : segments[segments.length - 1];
        boolean matchesLastSegment = this.locator.pattern.selector == null ? true : this.locator.matchesName(this.locator.pattern.selector, (lastSegment == null ? "" : lastSegment).toCharArray());
        boolean matchesPrefix = this.locator.pattern.declaringPackageName == null ? true : name.startsWith(new String(this.locator.pattern.declaringPackageName));
        int level = matchesLastSegment && matchesPrefix ? 2 : 0;
        return this.toResponse(level);
    }

    protected int matchMethod(ASTNode node, IMethodBinding method, boolean skipImpossibleArg, boolean bindingIsDeclaration) {
        if (!this.locator.matchesName(this.locator.pattern.selector, method.getName().toCharArray())) {
            return 0;
        }
        int level = this.matchMethodBindingName(method);
        if (level == 0) {
            return level;
        }
        level = this.resolveLevelForType(this.locator.pattern.returnSimpleName, this.locator.pattern.returnQualification, method.getReturnType());
        if (level == 0) {
            return level;
        }
        if ((level = this.matchMethodBindingParameters(node, method, skipImpossibleArg, level)) == 0) {
            return level;
        }
        level = this.matchMethodBindingTypeArguments(node, method, skipImpossibleArg, level, bindingIsDeclaration);
        return level;
    }

    private IBinding findPossiblyUnresolvedBindingForType(ASTNode node, String patternSig) {
        IBinding patternBinding = JdtCoreDomPackagePrivateUtility.findBindingForType(node, patternSig);
        if (patternBinding == null) {
            String safePatternString;
            boolean plusOrMinus = patternSig.startsWith("+") || patternSig.startsWith("-");
            String string = safePatternString = plusOrMinus ? patternSig.substring(1) : patternSig;
            if (safePatternString.startsWith("Q")) {
                patternBinding = JdtCoreDomPackagePrivateUtility.findUnresolvedBindingForType(node, safePatternString);
            }
        }
        return patternBinding;
    }

    private boolean isPatternErasureMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x10) == 16;
    }

    private boolean isPatternEquivalentMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x20) == 32;
    }

    private boolean isPatternExactMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x40) == 64;
    }

    private int matchMethodBindingTypeArguments(ASTNode node, IMethodBinding method, boolean skipImpossibleArg, int level, boolean bindingIsDeclaration) {
        boolean potentialMatchOnly = false;
        if (this.locator.pattern.hasMethodArguments()) {
            ITypeBinding[] argBindings = method.getTypeArguments();
            char[][] goal = this.locator.pattern.methodArguments;
            if (goal == null || goal.length == 0) {
                return level;
            }
            if (argBindings == null || argBindings.length == 0) {
                List typeArgsFromNode = null;
                if (node instanceof MethodInvocation) {
                    MethodInvocation mi = (MethodInvocation)node;
                    typeArgsFromNode = mi.typeArguments();
                    potentialMatchOnly = !bindingIsDeclaration;
                } else if (node instanceof MethodDeclaration) {
                    MethodDeclaration md = (MethodDeclaration)node;
                    typeArgsFromNode = md.typeParameters();
                }
                if (typeArgsFromNode != null && typeArgsFromNode.size() > 0) {
                    List<ITypeBinding> tmp = typeArgsFromNode.stream().map(DOMASTNodeUtils::getBinding).filter(x -> x instanceof ITypeBinding).map(x -> (ITypeBinding)x).collect(Collectors.toList());
                    argBindings = tmp.toArray(new ITypeBinding[tmp.size()]);
                }
            }
            boolean isExactPattern = this.isPatternExactMatch();
            boolean isErasurePattern = this.isPatternErasureMatch();
            boolean isEquivPattern = this.isPatternEquivalentMatch();
            if (argBindings == null || argBindings.length == 0) {
                if (goal == null || goal.length == 0) {
                    return level;
                }
                if (isExactPattern || !isErasurePattern && !isEquivPattern) {
                    return 0;
                }
                if (!bindingIsDeclaration) {
                    return 0;
                }
                ITypeBinding[] tmp = method.getTypeParameters();
                if (tmp != null && tmp.length > 0) {
                    return goal != null && goal.length == tmp.length ? 4 : 0;
                }
                return 4;
            }
            if (argBindings.length != goal.length) {
                return 0;
            }
            for (int i = 0; i < argBindings.length; ++i) {
                boolean match;
                String goaliString = new String(goal[i]);
                IBinding patternBinding = this.findPossiblyUnresolvedBindingForType(node, goaliString);
                if (argBindings[i].isTypeVariable() && patternBinding == null || (match = TypeArgumentMatchingUtility.validateSingleTypeArgMatches(isExactPattern, goaliString, patternBinding, (IBinding)argBindings[i]))) continue;
                if (isExactPattern || !isErasurePattern && !isEquivPattern) {
                    return 0;
                }
                if (potentialMatchOnly) {
                    return 1;
                }
                return 4;
            }
        }
        return level;
    }

    protected int matchMethodBindingName(IMethodBinding binding) {
        int newLevel;
        int level = 3;
        if (this.locator.pattern.declaringSimpleName == null && level > (newLevel = this.resolveLevelForType(this.locator.pattern.returnSimpleName, this.locator.pattern.returnQualification, binding.getReturnType()))) {
            if (newLevel == 0) {
                return 0;
            }
            level = newLevel;
        }
        return level;
    }

    private int matchMethodBindingParameters(ASTNode node, IMethodBinding method, boolean skipImpossibleArg, int level) {
        int parameterCount;
        boolean isExactPattern = this.isPatternExactMatch();
        int n = parameterCount = this.locator.pattern.parameterSimpleNames == null ? -1 : this.locator.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.getParameterTypes() == null) {
                return 1;
            }
            if (parameterCount != method.getParameterTypes().length) {
                return 0;
            }
            if (method.isRecovered()) {
                return 1;
            }
            boolean foundTypeVariable = false;
            IMethodBinding focusMethodBinding = null;
            boolean checkedFocus = false;
            boolean isBinary = this.locator.pattern != null && this.locator.pattern.focus instanceof BinaryMethod;
            ITypeBinding[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < parameterCount; ++i) {
                ITypeBinding argType = paramTypes[i];
                int newLevel = 0;
                boolean foundLevel = false;
                if (argType.isMember() || this.locator.pattern.parameterQualifications[i] != null) {
                    ITypeBinding[] parameters;
                    if (!checkedFocus) {
                        focusMethodBinding = this.getDOMASTMethodBinding(this.locator.pattern, node.getAST());
                        checkedFocus = true;
                    }
                    if (focusMethodBinding != null && (parameters = focusMethodBinding.getParameterTypes()).length >= parameterCount) {
                        newLevel = (isBinary ? argType.getErasure().isEqualTo((IBinding)parameters[i].getErasure()) : argType.isEqualTo((IBinding)parameters[i])) ? 3 : 0;
                        foundLevel = true;
                    }
                } else {
                    newLevel = this.resolveLevelForType(this.locator.pattern.parameterSimpleNames[i], this.locator.pattern.parameterQualifications[i], argType);
                    if (argType.isGenericType() && newLevel == 3) {
                        boolean patternHasTypeArgs;
                        ITypeBinding[] nestedParams = argType.getTypeParameters();
                        char[][][][] ptaAll = this.locator.pattern.parametersTypeArguments;
                        char[][][] ptaThisLevel = ptaAll == null || ptaAll.length == 0 ? null : ptaAll[0];
                        boolean bl = patternHasTypeArgs = ptaThisLevel != null && ptaThisLevel.length > i;
                        if (patternHasTypeArgs) {
                            char[][] thisParamTypeArgs = ptaThisLevel[i];
                            for (int q = 0; q < thisParamTypeArgs.length; ++q) {
                                ITypeBinding fromBinding;
                                char[] fromPattern = thisParamTypeArgs[q];
                                ITypeBinding iTypeBinding = fromBinding = nestedParams == null || nestedParams.length == 0 ? null : nestedParams[q];
                                if (fromBinding == null) {
                                    newLevel = 1;
                                    continue;
                                }
                                String fromPatternString = new String(fromPattern);
                                IBinding patternBinding = this.findPossiblyUnresolvedBindingForType(node, fromPatternString);
                                boolean match = TypeArgumentMatchingUtility.validateSingleTypeArgMatches(isExactPattern, fromPatternString, patternBinding, (IBinding)fromBinding);
                                if (match) continue;
                                newLevel = 1;
                            }
                        }
                    }
                }
                if (level <= newLevel) continue;
                if (newLevel == 0) {
                    if (skipImpossibleArg) {
                        if (!foundLevel) {
                            newLevel = level;
                        }
                    } else if (argType.isTypeVariable()) {
                        newLevel = level;
                        foundTypeVariable = true;
                    } else {
                        return 0;
                    }
                }
                level = newLevel;
            }
            if (foundTypeVariable) {
                if (!Modifier.isStatic((int)method.getModifiers()) && !Modifier.isPrivate((int)method.getModifiers())) {
                    if (!checkedFocus) {
                        focusMethodBinding = this.getDOMASTMethodBinding(this.locator.pattern, node.getAST());
                    }
                    if (focusMethodBinding != null && (focusMethodBinding.overrides(method) || method.overrides(focusMethodBinding))) {
                        return 3;
                    }
                }
                return 0;
            }
        }
        return level;
    }

    public IMethodBinding getDOMASTMethodBinding(MethodPattern methodPattern, AST ast) {
        ITypeBinding type;
        char[] typeName = PatternLocator.qualifiedPattern((char[])methodPattern.declaringSimpleName, (char[])methodPattern.declaringQualification);
        if (typeName != null && (type = ast.resolveWellKnownType(new String(typeName))) != null) {
            for (IMethodBinding method : type.getDeclaredMethods()) {
                if (!Objects.equals(method.getJavaElement(), methodPattern.focus)) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        SingleMemberAnnotation singleMemberAnnotation;
        IMemberValuePairBinding[] valuePairs;
        ASTNode aSTNode;
        boolean isExactPattern = this.isPatternExactMatch();
        boolean isErasurePattern = this.isPatternErasureMatch();
        boolean isEquivPattern = this.isPatternEquivalentMatch();
        if (node.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY && (aSTNode = node.getParent()) instanceof SingleMemberAnnotation && (valuePairs = (singleMemberAnnotation = (SingleMemberAnnotation)aSTNode).resolveAnnotationBinding().getDeclaredMemberValuePairs()) != null && valuePairs.length > 0) {
            binding = valuePairs[0].getMethodBinding();
        }
        if (binding instanceof IMethodBinding) {
            boolean subType;
            IMethodBinding method = (IMethodBinding)binding;
            boolean skipVerif = this.locator.pattern.findDeclarations && this.locator.mayBeGeneric;
            int methodLevel = this.matchMethod(node, method, skipVerif, false);
            if (methodLevel == 0) {
                IMethodBinding decl = method.getMethodDeclaration();
                if (method != decl) {
                    methodLevel = this.matchMethod(node, decl, skipVerif, true);
                }
                if (methodLevel == 0) {
                    return this.toResponse(0);
                }
                method = decl;
            }
            if (node instanceof Name) {
                boolean patternHasTypeArgs;
                boolean bl = patternHasTypeArgs = this.locator.pattern.parameterSimpleNames != null && this.locator.pattern.parameterSimpleNames.length > 0 && this.locator.pattern.parameterSimpleNames[0] != null;
                if (patternHasTypeArgs) {
                    return this.toResponse(0);
                }
            }
            if (this.locator.pattern.declaringSimpleName == null && this.locator.pattern.declaringQualification == null) {
                return this.toResponse(methodLevel);
            }
            boolean bl = subType = (method.getModifiers() & 8) == 0 && (method.getModifiers() & 2) == 0;
            if (subType && this.locator.pattern.declaringQualification != null && method.getDeclaringClass() != null && method.getDeclaringClass().getPackage() != null) {
                subType = CharOperation.compareWith((char[])this.locator.pattern.declaringQualification, (char[])method.getDeclaringClass().getPackage().getName().toCharArray()) == 0;
            }
            ITypeBinding declaring = method.getDeclaringClass();
            int declaringLevel = subType ? this.resolveLevelAsSubtype(this.locator.pattern.declaringSimpleName, this.locator.pattern.declaringQualification, declaring, method.getName(), null, declaring.getPackage().getName(), (method.getModifiers() & 0x10000) != 0) : this.resolveLevelForType(this.locator.pattern.declaringSimpleName, this.locator.pattern.declaringQualification, declaring);
            int weakerLevel = this.findWeakerLevel(methodLevel & 0xF, declaringLevel & 0xF);
            int matchLevel = weakerLevel & 0xF;
            if (matchLevel != 3) {
                if (isExactPattern || !isErasurePattern && !isEquivPattern) {
                    return this.toResponse(0);
                }
                if (isEquivPattern && matchLevel == 4) {
                    return this.toResponse(0);
                }
            }
            return this.toResponse(weakerLevel);
        }
        return this.toResponse(1);
    }

    private int findWeakerLevel(int i, int j) {
        int jIndex;
        int[] ints = new int[]{0, 2, 1, 4, 3};
        List list = Arrays.stream(ints).boxed().collect(Collectors.toList());
        int iIndex = list.indexOf(i);
        return iIndex > (jIndex = list.indexOf(j)) ? j : i;
    }

    protected int resolveLevelAsSubtype(char[] simplePattern, char[] qualifiedPattern, ITypeBinding type, String methodName, ITypeBinding[] argumentTypes, String packageName, boolean isDefault) {
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(simplePattern, qualifiedPattern, type);
        if (level != 0) {
            IMethodBinding method;
            if (isDefault && !Objects.equals(packageName, type.getPackage().getName())) {
                return 0;
            }
            IMethodBinding iMethodBinding = method = argumentTypes == null ? null : this.getDOMASTMethodBinding(type, methodName, argumentTypes);
            if (!((method == null || Modifier.isAbstract((int)method.getModifiers())) && Modifier.isAbstract((int)type.getModifiers()) || type.isInterface())) {
                level |= 0x800;
            }
            return level;
        }
        if (!type.isInterface() && !type.getQualifiedName().equals(Object.class.getName()) && (level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, type.getSuperclass(), methodName, argumentTypes, packageName, isDefault)) != 0) {
            IMethodBinding method;
            if (argumentTypes != null && (method = this.getDOMASTMethodBinding(type, methodName, argumentTypes)) != null) {
                if ((level & 0x800) != 0) {
                    return 0;
                }
                if (!Modifier.isAbstract((int)method.getModifiers()) && !type.isInterface()) {
                    level |= 0x800;
                }
            }
            return level | 0x400;
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        if (interfaces == null) {
            return 1;
        }
        for (ITypeBinding ref : interfaces) {
            level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, ref, methodName, null, packageName, isDefault);
            if (level == 0) continue;
            if (!Modifier.isAbstract((int)type.getModifiers()) && !type.isInterface()) {
                level |= 0x800;
            }
            return level | 0x400;
        }
        return 0;
    }
}

