/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.type.NullType;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeVariableBinding;

public abstract class JavacTypeBinding
implements ITypeBinding {
    private static final ITypeBinding[] NO_TYPE_ARGUMENTS = new ITypeBinding[0];
    final JavacBindingResolver resolver;
    public final Symbol.TypeSymbol typeSymbol;
    protected final Types types;
    private final Names names;
    public final Type type;
    private final boolean isGeneric;
    private boolean recovered = false;
    private final Type[] alternatives;
    private IJavaElement javaElement;
    private String key;

    public JavacTypeBinding(Type type, Symbol.TypeSymbol typeSymbol, Type[] alternatives, boolean likelyGeneric, JavacBindingResolver resolver) {
        if (!JavacBindingResolver.isTypeOfType(type) && typeSymbol != null) {
            type = typeSymbol.type;
        }
        this.isGeneric = type.isParameterized() && likelyGeneric;
        this.typeSymbol = (typeSymbol == null || typeSymbol.kind == Kinds.Kind.ERR) && type != null ? type.tsym : typeSymbol;
        this.type = this.isGeneric || type == null ? this.typeSymbol.type : type;
        this.resolver = resolver;
        this.types = Types.instance(this.resolver.context);
        this.names = Names.instance(this.resolver.context);
        this.alternatives = alternatives;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacTypeBinding)) return false;
        JavacTypeBinding other = (JavacTypeBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.type, other.type)) return false;
        if (!Objects.equals(this.typeSymbol, other.typeSymbol)) return false;
        if (!Objects.equals(this.isGeneric, other.isGeneric)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.type, this.typeSymbol, this.isGeneric});
    }

    public IAnnotationBinding[] getAnnotations() {
        java.util.List annots = this.typeSymbol.getAnnotationMirrors();
        if (this.resolver.isRecoveringBindings()) {
            return (IAnnotationBinding[])annots.stream().map(am -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)am, (IBinding)this)).toArray(IAnnotationBinding[]::new);
        }
        return (IAnnotationBinding[])annots.stream().filter(x -> !(x.type instanceof Type.ErrorType)).map(am -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)am, (IBinding)this)).toArray(IAnnotationBinding[]::new);
    }

    public int getKind() {
        return 2;
    }

    public boolean isDeprecated() {
        return this.typeSymbol.isDeprecated();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRecovered() {
        Symbol.TypeSymbol typeSymbol;
        if (this.recovered) {
            return true;
        }
        if (this.isArray()) {
            return this.getComponentType().isRecovered();
        }
        if (this.typeSymbol.kind == Kinds.Kind.ERR) return true;
        if (!this.type.isPrimitiveOrVoid() && (typeSymbol = this.typeSymbol) instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol symbol = (Symbol.ClassSymbol)typeSymbol;
            if (symbol.sourcefile == null) {
                if (symbol.classfile == null) return true;
            }
        }
        if (this.type.allparams().stream().anyMatch(param -> param.isErroneous())) return true;
        if (!Object.class.getName().equals(this.typeSymbol.getQualifiedName().toString())) return false;
        if (this.getJavaElement() != null) return false;
        return true;
    }

    public boolean isSynthetic() {
        return (this.typeSymbol.flags() & 0x1000L) != 0L;
    }

    public IJavaElement getJavaElement() {
        if (this.javaElement == null) {
            this.javaElement = this.computeJavaElement();
        }
        return this.javaElement;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private IJavaElement computeJavaElement() {
        block28: {
            if (!this.isTypeVariable() || this.typeSymbol == null) break block28;
            var3_1 = this.typeSymbol.owner;
            if (!(var3_1 instanceof Symbol.ClassSymbol)) ** GOTO lbl-1000
            ownerSymbol = (Symbol.ClassSymbol)var3_1;
            if (ownerSymbol.type != null) {
                var4_3 = this.resolver.bindings.getTypeBinding(ownerSymbol.type).getJavaElement();
                if (var4_3 instanceof IType && (ownerType = (IType)var4_3).getTypeParameter(this.getName()) != null) {
                    return ownerType.getTypeParameter(this.getName());
                }
            } else if ((ownerType = this.typeSymbol.owner) instanceof Symbol.MethodSymbol) {
                ownerSymbol /* !! */  = (Symbol.MethodSymbol)ownerType;
                if (ownerSymbol /* !! */ .type != null && (var5_5 = (mb = this.resolver.bindings.getMethodBinding(ownerSymbol /* !! */ .type.asMethodType(), (Symbol.MethodSymbol)ownerSymbol /* !! */ , null, this.isGeneric)).getJavaElement()) instanceof IMethod && (ownerMethod = var5_5).getTypeParameter(this.getName()) != null) {
                    return ownerMethod.getTypeParameter(this.getName());
                }
            }
        }
        if (this.resolver.javaProject == null) {
            return null;
        }
        if (this.isArray()) {
            return this.getElementType().getJavaElement();
        }
        ownerSymbol /* !! */  = this.typeSymbol;
        if (ownerSymbol /* !! */  instanceof Symbol.ClassSymbol) {
            classSymbol = (Symbol.ClassSymbol)ownerSymbol /* !! */ ;
            if (this.isAnonymous()) {
                if (this.getDeclaringMethod() != null && (var6_7 = this.getDeclaringMethod().getJavaElement()) instanceof IMethod) {
                    method = (IMethod)var6_7;
                    if (!method.isBinary()) {
                        return this.resolved(method.getType("", 1));
                    }
                } else {
                    var6_7 = this.getDeclaringMember();
                    if (var6_7 instanceof IBinding && (gdm = var6_7) != null && (var6_7 = gdm.getJavaElement()) instanceof IField) {
                        field = (IField)var6_7;
                        if (!field.isBinary()) {
                            return this.resolved(field.getType("", 1));
                        }
                    } else if (this.getDeclaringClass() != null && (var6_7 = this.getDeclaringClass().getJavaElement()) instanceof IType && !(type = (IType)var6_7).isBinary()) {
                        return this.resolved(type.getType("", 1));
                    }
                }
            }
            if (this.typeSymbol.owner instanceof Symbol.MethodSymbol && this.getDeclaringMethod() != null && (gdm = this.getDeclaringMethod().getJavaElement()) instanceof IMethod && !(method = (IMethod)gdm).isBinary()) {
                return this.resolved(method.getType(this.typeSymbol.name.toString(), 1));
            }
            jfo = null;
            if (classSymbol != null) {
                jfo = classSymbol.classfile != null ? classSymbol.classfile : classSymbol.sourcefile;
            }
            typeRoot = null;
            if (jfo != null && !jfo.getName().endsWith("whatever_InvalidNameWE_HOP3_n00ne_will_Ever_use_in_real_file.java")) {
                jfoFile = new File(jfo.getName());
                jfoPath = new Path(jfo.getName());
                fileStream = jfoFile.isFile() != false ? Arrays.stream(this.resolver.javaProject.getResource().getWorkspace().getRoot().findFilesForLocationURI(jfoFile.toURI())) : (jfoPath.segmentCount() > 1 ? Stream.of(this.resolver.javaProject.getResource().getWorkspace().getRoot().getFile((IPath)jfoPath)) : Stream.of(new IFile[0]));
                typeRoot = fileStream.map((Function<IFile, IJavaElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create(org.eclipse.core.resources.IFile ), (Lorg/eclipse/core/resources/IFile;)Lorg/eclipse/jdt/core/IJavaElement;)()).filter((Predicate<IJavaElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/eclipse/jdt/core/IJavaElement;)Z)(ITypeRoot.class)).map((Function<IJavaElement, ITypeRoot>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lorg/eclipse/jdt/core/IJavaElement;)Lorg/eclipse/jdt/core/ITypeRoot;)(ITypeRoot.class)).findAny().orElse(null);
            }
            candidate = null;
            if (typeRoot instanceof ICompilationUnit) {
                tmp = (ICompilationUnit)typeRoot;
                wc = tmp.findWorkingCopy(this.resolver.getWorkingCopyOwner());
                if (wc != null) {
                    tmp = wc;
                }
                if ((cleaned = JavacTypeBinding.cleanedUpName(this.type).split("\\$")).length > 0) {
                    cleaned[0] = cleaned[0].substring(cleaned[0].lastIndexOf(46) + 1);
                }
                done = false;
                for (i = 0; i < cleaned.length && !done; done |= candidate == null, ++i) {
                    if (candidate == null) {
                        candidate = tmp.getType(cleaned[i]);
                        continue;
                    }
                    if (candidate.isBinary()) continue;
                    candidate = candidate.getType(cleaned[i]);
                }
                if (candidate != null && candidate.exists()) {
                    return this.resolved(candidate);
                }
            }
            try {
                ret = this.resolver.javaProject.findType(JavacTypeBinding.cleanedUpName(this.type), this.resolver.getWorkingCopyOwner(), (IProgressMonitor)new NullProgressMonitor());
                if (ret != null) {
                    return this.resolved(ret);
                }
            }
            catch (JavaModelException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
            return this.resolved(candidate);
        }
        return null;
    }

    private IType resolved(IType type) {
        if (type == null) {
            return null;
        }
        IJavaElement iJavaElement = type.getAncestor(5);
        if (iJavaElement instanceof ClassFileWorkingCopy) {
            ClassFileWorkingCopy classFileWC = (ClassFileWorkingCopy)iJavaElement;
            iJavaElement = classFileWC.classFile;
            if (iJavaElement instanceof IOrdinaryClassFile) {
                IOrdinaryClassFile classFile = (IOrdinaryClassFile)iJavaElement;
                type = classFile.getType();
            }
        }
        if (type instanceof SourceType && !(type instanceof ResolvedSourceType)) {
            return new ResolvedSourceType((JavaElement)type.getParent(), type.getElementName(), this.getGenericTypeSignature(true), type.getOccurrenceCount());
        }
        if (type instanceof BinaryType && !(type instanceof ResolvedBinaryType)) {
            return new ResolvedBinaryType((JavaElement)type.getParent(), type.getElementName(), this.getGenericTypeSignature(true), type.getOccurrenceCount());
        }
        return type;
    }

    private static String cleanedUpName(Type type) {
        Type.ClassType classType;
        AnnoConstruct annoConstruct;
        if (type instanceof Type.ClassType && (annoConstruct = (classType = (Type.ClassType)type).getEnclosingType()) instanceof Type.ClassType) {
            Type.ClassType enclosing = (Type.ClassType)annoConstruct;
            return JavacTypeBinding.cleanedUpName(enclosing) + "$" + ((Name)type.tsym.getSimpleName()).toString();
        }
        annoConstruct = type.tsym;
        if (annoConstruct instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)annoConstruct;
            annoConstruct = type.tsym.owner;
            if (annoConstruct instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol enclosingSymbol = (Symbol.ClassSymbol)annoConstruct;
                return enclosingSymbol.getQualifiedName().toString() + "$" + classSymbol.getSimpleName().toString();
            }
        }
        return type.tsym.getQualifiedName().toString();
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.computeKey();
        }
        return this.key;
    }

    private String computeKey() {
        Type type;
        String b3 = this.getKeyWithPossibleGenerics(this.type, this.typeSymbol, tb -> tb != null ? tb.getKey() : "Ljava/lang/Object;", true);
        if ((this.type.isSuperBound() || this.type.isExtendsBound()) && (type = this.type) instanceof Type.WildcardType) {
            Type.WildcardType wt = (Type.WildcardType)type;
            String base1 = this.getKey(this.type, this.typeSymbol.flatName(), false, true);
            String base = JavacTypeBinding.removeTrailingSemicolon(base1);
            int[] counter = new int[]{0};
            String base4 = this.getKey(wt.type, wt.type.tsym.flatName(), false, true);
            String r = this.prependBaseAndCount(base, JavacTypeBinding.removeTrailingSemicolon(base4), counter);
            return r;
        }
        return b3;
    }

    public String getKeyWithPossibleGenerics(Type t, Symbol.TypeSymbol s) {
        return this.getKeyWithPossibleGenerics(t, s, tb -> tb != null ? tb.getKey() : "Ljava/lang/Object;");
    }

    private String getKeyWithPossibleGenerics(Type t, Symbol.TypeSymbol s, Function<ITypeBinding, String> parameterizedCallback) {
        return this.getKeyWithPossibleGenerics(t, s, parameterizedCallback, false);
    }

    private String getKeyWithPossibleGenerics(Type t, Symbol.TypeSymbol s, Function<ITypeBinding, String> parameterizedCallback, boolean useSlashes) {
        JavacTypeBinding javacTypeBinding;
        if (!this.isGeneric && (javacTypeBinding = this) instanceof JavacTypeVariableBinding) {
            JavacTypeVariableBinding jctvb = (JavacTypeVariableBinding)javacTypeBinding;
            String ret = jctvb.getKeyWithOptionalCaptureCode(false);
            return ret;
        }
        String base1 = this.getKey(t, s.flatName(), false, useSlashes);
        String base = JavacTypeBinding.removeTrailingSemicolon(base1);
        if (this.isRawType(t)) {
            return base + "<>;";
        }
        if (this.isGenericType(t)) {
            return base + "<" + Arrays.stream(this.getTypeParametersForBase(t)).map(ITypeBinding::getName).map(name -> "T" + name + ";").collect(Collectors.joining()) + ">;";
        }
        if (this.isParameterizedType(t)) {
            String base2 = base;
            int[] counter = new int[]{0};
            return base + "<" + Arrays.stream(this.getTypeArgumentsForBase(this.type, this.typeSymbol)).map(parameterizedCallback).map(x -> this.prependBaseAndCount((String)x, base2, counter)).collect(Collectors.joining()) + ">;";
        }
        return base1;
    }

    public String getGenericTypeSignature(boolean useSlashes) {
        return this.getGenericTypeSignature(this.type, this.typeSymbol, useSlashes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getGenericTypeSignature(Type t, Symbol.TypeSymbol s, boolean useSlashes) {
        if (t instanceof Type.ClassType) {
            Type.ClassType ct = (Type.ClassType)t;
            if (!s.isAnonymous() && ct.getEnclosingType() != null) {
                Type enclosing = ct.getEnclosingType();
                if (enclosing == null) return this.getKeyWithPossibleGenerics(t, s, x -> {
                    String string;
                    if (x instanceof JavacTypeBinding) {
                        JavacTypeBinding jtb = (JavacTypeBinding)x;
                        string = jtb.getGenericTypeSignature(useSlashes);
                    } else {
                        string = x != null ? x.getKey() : "Ljava/lang/Object;";
                    }
                    return string;
                }, useSlashes);
                if (enclosing == Type.noType) return this.getKeyWithPossibleGenerics(t, s, x -> {
                    String string;
                    if (x instanceof JavacTypeBinding) {
                        JavacTypeBinding jtb = (JavacTypeBinding)x;
                        string = jtb.getGenericTypeSignature(useSlashes);
                    } else {
                        string = x != null ? x.getKey() : "Ljava/lang/Object;";
                    }
                    return string;
                }, useSlashes);
                JavacTypeBinding enclosingBinding = this.resolver.bindings.getTypeBinding(enclosing);
                String enclosingSignature = JavacTypeBinding.removeTrailingSemicolon(enclosingBinding.getGenericTypeSignature(useSlashes));
                String simpleName = ((Name)s.getSimpleName()).toString();
                Object typeArgs = ";";
                if (!t.getTypeArguments().nonEmpty()) return enclosingSignature + "$" + simpleName + (String)typeArgs;
                String simpleBase = JavacTypeBinding.removeTrailingSemicolon(this.getKey(t, s.flatName(), false, useSlashes));
                int[] counter = new int[]{0};
                typeArgs = "<" + Arrays.stream(this.getTypeArguments()).map(x -> {
                    String string;
                    if (x instanceof JavacTypeBinding) {
                        JavacTypeBinding jtb = (JavacTypeBinding)x;
                        string = jtb.getGenericTypeSignature(useSlashes);
                    } else {
                        string = x.getKey();
                    }
                    return string;
                }).map(x -> this.prependBaseAndCount((String)x, simpleBase, counter)).collect(Collectors.joining()) + ">;";
                return enclosingSignature + "$" + simpleName + (String)typeArgs;
            }
        }
        if (!(t instanceof Type.ArrayType)) return this.getKeyWithPossibleGenerics(t, s, x -> {
            String string;
            if (x instanceof JavacTypeBinding) {
                JavacTypeBinding jtb = (JavacTypeBinding)x;
                string = jtb.getGenericTypeSignature(useSlashes);
            } else {
                string = x != null ? x.getKey() : "Ljava/lang/Object;";
            }
            return string;
        }, useSlashes);
        Type.ArrayType at = (Type.ArrayType)t;
        Type component = at.getComponentType();
        JavacTypeBinding componentBinding = this.resolver.bindings.getTypeBinding(component);
        return "[" + componentBinding.getGenericTypeSignature(useSlashes);
    }

    private String prependBaseAndCount(String typeKey, String base, int[] counter) {
        char c;
        char c2 = c = typeKey.length() > 0 ? typeKey.charAt(0) : (char)'\u0000';
        if (c == '\u0000' || c == 'T') {
            return typeKey;
        }
        if (base.length() > 0 && "LIZVCDBFJS[!".indexOf(c) == -1) {
            String ret = base + ";{" + counter[0] + "}" + typeKey;
            counter[0] = counter[0] + 1;
            return ret;
        }
        return typeKey;
    }

    private static String removeTrailingSemicolon(String key) {
        return key.endsWith(";") ? key.substring(0, key.length() - 1) : key;
    }

    private String getKey(Type t) {
        return this.getKey(t, this.typeSymbol.flatName());
    }

    public String getKey(boolean includeTypeParameters) {
        return this.getKey(this.type, this.typeSymbol.flatName(), includeTypeParameters);
    }

    public String getKey(boolean includeTypeParameters, boolean useSlashes) {
        return this.getKey(this.type, this.typeSymbol.flatName(), includeTypeParameters, useSlashes);
    }

    public String getKey(Type t, Name n) {
        return this.getKey(this.type, n, true);
    }

    public String getKey(Type t, Name n, boolean includeTypeParameters) {
        return this.getKey(t, n, includeTypeParameters, false);
    }

    public String getKey(Type t, Name n, boolean includeTypeParameters, boolean useSlashes) {
        try {
            StringBuilder builder = new StringBuilder();
            JavacTypeBinding.getKey(builder, t, n.toString(), false, includeTypeParameters, useSlashes, this.resolver);
            return builder.toString();
        }
        catch (JavacBindingResolver.BindingKeyException bke) {
            return null;
        }
    }

    static void getKey(StringBuilder builder, Type typeToBuild, boolean isLeaf, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacTypeBinding.getKey(builder, typeToBuild, typeToBuild.asElement().flatName(), isLeaf, false, false, resolver);
    }

    static void getKey(StringBuilder builder, Type typeToBuild, boolean isLeaf, boolean includeParameters, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacTypeBinding.getKey(builder, typeToBuild, typeToBuild.asElement().flatName(), isLeaf, includeParameters, false, resolver);
    }

    static void getKey(StringBuilder builder, Type typeToBuild, boolean isLeaf, boolean includeParameters, boolean useSlashes, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacTypeBinding.getKey(builder, typeToBuild, typeToBuild.asElement().flatName(), isLeaf, includeParameters, useSlashes, resolver);
    }

    static void getKey(StringBuilder builder, Type typeToBuild, Name n, boolean isLeaf, boolean includeParameters, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacTypeBinding.getKey(builder, typeToBuild, n.toString(), isLeaf, includeParameters, false, resolver);
    }

    static void getKey(StringBuilder builder, Type typeToBuild, Name n, boolean isLeaf, boolean includeParameters, boolean useSlashes, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacTypeBinding.getKey(builder, typeToBuild, n.toString(), isLeaf, includeParameters, useSlashes, resolver);
    }

    static void getKey(StringBuilder builder, Type typeToBuild, String n, boolean isLeaf, boolean includeParameters, boolean useSlashes, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        if (typeToBuild instanceof Type.JCNoType) {
            return;
        }
        if (typeToBuild instanceof Type.CapturedType) {
            Type.CapturedType capturedType = (Type.CapturedType)typeToBuild;
            builder.append('!');
            JavacTypeBinding.getKey(builder, capturedType.wildcard, false, includeParameters, resolver);
            builder.append(((long)capturedType.hashCode() & 0xFFFFFFFFL) % 997L);
            builder.append(';');
            return;
        }
        if (typeToBuild.hasTag(TypeTag.NONE)) {
            builder.append('*');
            return;
        }
        if (typeToBuild instanceof Type.ArrayType) {
            Type.ArrayType arrayType = (Type.ArrayType)typeToBuild;
            builder.append('[');
            JavacTypeBinding.getKey(builder, arrayType.elemtype, isLeaf, includeParameters, useSlashes, resolver);
            return;
        }
        if (typeToBuild instanceof Type.IntersectionClassType) {
            Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)typeToBuild;
            JavacTypeBinding.getKey(builder, (Type)intersectionClassType.interfaces_field.get(0), isLeaf, includeParameters, useSlashes, resolver);
            return;
        }
        if (typeToBuild instanceof Type.WildcardType) {
            Type.WildcardType wildcardType = (Type.WildcardType)typeToBuild;
            if (wildcardType.isUnbound()) {
                builder.append("+Ljava/lang/Object;");
            } else if (wildcardType.isExtendsBound()) {
                Type extendsBound = wildcardType.getExtendsBound();
                if (extendsBound.isIntersection()) {
                    builder.append('*');
                } else {
                    builder.append('+');
                    JavacTypeBinding.getKey(builder, extendsBound, isLeaf, includeParameters, useSlashes, resolver);
                }
            } else if (wildcardType.isSuperBound()) {
                Type superBound = wildcardType.getSuperBound();
                if (superBound.isIntersection()) {
                    builder.append('*');
                } else {
                    builder.append('-');
                    JavacTypeBinding.getKey(builder, wildcardType.getSuperBound(), isLeaf, includeParameters, useSlashes, resolver);
                }
            }
            return;
        }
        if (typeToBuild.isReference()) {
            Symbol.TypeSymbol cic;
            Object object;
            ASTNode node;
            Object currentTypeSignature = "";
            if (!isLeaf) {
                currentTypeSignature = typeToBuild.tsym instanceof Symbol.TypeVariableSymbol ? (String)currentTypeSignature + "T" : (String)currentTypeSignature + "L";
            }
            String nameAsString = n.toString();
            if (useSlashes) {
                nameAsString = nameAsString.replace('.', '/');
            }
            nameAsString = nameAsString.replaceFirst("\\$([0-9]+)([A-Za-z$_][A-Za-z$_0-9]*)", "\\$$1\\$$2");
            if (typeToBuild.tsym.isAnonymous() && (node = resolver.symbolToDeclaration.get(typeToBuild.tsym)) != null && (object = node.getParent()) instanceof ClassInstanceCreation) {
                cic = (ClassInstanceCreation)object;
                nameAsString = nameAsString.replaceFirst("\\$([0-9]+)", "\\$" + cic.getType().getStartPosition());
            }
            currentTypeSignature = (String)currentTypeSignature + nameAsString;
            builder.append((String)currentTypeSignature);
            cic = typeToBuild.tsym;
            if (cic instanceof Symbol.ClassSymbol) {
                JavaFileObject sourcefile;
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)cic;
                if (!(classSymbol.type instanceof Type.ErrorType) && classSymbol.owner instanceof Symbol.PackageSymbol && (sourcefile = classSymbol.sourcefile) != null && sourcefile.getKind() == JavaFileObject.Kind.SOURCE) {
                    URI uri = sourcefile.toUri();
                    String fileName = null;
                    try {
                        fileName = Paths.get(uri).getFileName().toString();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (fileName != null && !fileName.startsWith(classSymbol.getSimpleName().toString()) && !fileName.endsWith("whatever_InvalidNameWE_HOP3_n00ne_will_Ever_use_in_real_file.java")) {
                        int simpleNameIndex = builder.lastIndexOf(classSymbol.getSimpleName().toString());
                        builder.insert(simpleNameIndex, fileName.substring(0, fileName.indexOf(".java")) + "~");
                    }
                }
            }
            boolean b1 = typeToBuild.isParameterized();
            boolean b2 = false;
            try {
                b2 = typeToBuild.tsym != null && typeToBuild.tsym.type != null && typeToBuild.tsym.type.isParameterized();
            }
            catch (Symbol.CompletionFailure cf1) {
                if (resolver.isRecoveringBindings()) {
                    ILog.get().error(cf1.getMessage(), (Throwable)cf1);
                }
                throw new JavacBindingResolver.BindingKeyException(cf1);
            }
            if ((b1 || b2) && includeParameters) {
                builder.append('<');
                for (Type typeArgument : typeToBuild.getTypeArguments()) {
                    StringBuilder tmp = new StringBuilder();
                    JavacTypeBinding.getKey(tmp, typeArgument, typeArgument.asElement().flatName().toString(), false, includeParameters, useSlashes, resolver);
                    String paramType = tmp.toString();
                    if (paramType.startsWith("+") && !paramType.equals("+Ljava/lang/Object;")) {
                        builder.append("!");
                        builder.append((String)currentTypeSignature);
                        builder.append(";{1}");
                        builder.append(paramType);
                        builder.append("1;");
                        continue;
                    }
                    builder.append(paramType);
                }
                builder.append('>');
            }
            if (!isLeaf) {
                builder.append(';');
            }
            return;
        }
        if (typeToBuild.isPrimitiveOrVoid()) {
            switch (typeToBuild.getKind()) {
                case BYTE: {
                    builder.append('B');
                    return;
                }
                case CHAR: {
                    builder.append('C');
                    return;
                }
                case DOUBLE: {
                    builder.append('D');
                    return;
                }
                case FLOAT: {
                    builder.append('F');
                    return;
                }
                case INT: {
                    builder.append('I');
                    return;
                }
                case LONG: {
                    builder.append('J');
                    return;
                }
                case SHORT: {
                    builder.append('S');
                    return;
                }
                case BOOLEAN: {
                    builder.append('Z');
                    return;
                }
                case VOID: {
                    builder.append('V');
                    return;
                }
            }
        }
        if (typeToBuild.isNullOrReference()) {
            return;
        }
        throw new UnsupportedOperationException("Unimplemented method 'getKey'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof ITypeBinding)) return false;
        ITypeBinding other = (ITypeBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public ITypeBinding createArrayType(int dimension) {
        int realDimensions = dimension;
        if ((realDimensions += this.getDimensions()) < 1 || realDimensions > 255) {
            throw new IllegalArgumentException();
        }
        if (this.type instanceof Type.JCVoidType) {
            return null;
        }
        Type type = this.type;
        for (int i = 0; i < dimension; ++i) {
            type = this.types.makeArrayType(type);
        }
        return this.resolver.bindings.getTypeBinding(type);
    }

    public String getBinaryName() {
        if (this.type.isPrimitiveOrVoid() || this.type instanceof Type.ArrayType) {
            final StringBuilder res1 = new StringBuilder();
            Types types = this.types;
            Objects.requireNonNull(types);
            Types.SignatureGenerator generator1 = new Types.SignatureGenerator(this, types){

                @Override
                protected void append(char ch) {
                    res1.append(ch);
                }

                @Override
                protected void append(byte[] ba) {
                    res1.append(new String(ba));
                }

                @Override
                protected void append(Name name) {
                    res1.append(name.toString());
                }
            };
            generator1.assembleSig(this.type);
            String s111 = res1.toString().replaceAll("/", ".");
            return s111;
        }
        return this.typeSymbol.flatName().toString();
    }

    public ITypeBinding getBound() {
        Type.WildcardType wildcardType;
        Type type = this.type;
        if (type instanceof Type.WildcardType && !(wildcardType = (Type.WildcardType)type).isUnbound()) {
            Type bound = wildcardType.getExtendsBound();
            if (bound == null) {
                bound = wildcardType.getSuperBound();
            }
            if (bound != null) {
                return this.resolver.bindings.getTypeBinding(bound);
            }
            ITypeBinding[] boundsArray = this.getTypeBounds();
            if (boundsArray.length == 1) {
                return boundsArray[0];
            }
        }
        return null;
    }

    public ITypeBinding getGenericTypeOfWildcardType() {
        if (!this.isWildcardType()) {
            return null;
        }
        Type type = this.typeSymbol.type;
        if (type instanceof Type.WildcardType) {
            Type.WildcardType wildcardType = (Type.WildcardType)type;
            return (ITypeBinding)this.resolver.bindings.getBinding(wildcardType.type.tsym, wildcardType.type);
        }
        throw new IllegalStateException("Binding is a wildcard, but type cast failed");
    }

    public int getRank() {
        if (this.isWildcardType() || this.isIntersectionType()) {
            return this.types.rank(this.type);
        }
        return -1;
    }

    public ITypeBinding getComponentType() {
        Type type = this.type;
        if (type instanceof Type.ArrayType) {
            Type.ArrayType arrayType = (Type.ArrayType)type;
            return this.resolver.bindings.getTypeBinding(arrayType.elemtype);
        }
        return null;
    }

    public IVariableBinding[] getDeclaredFields() {
        if (this.typeSymbol.members() == null) {
            return new IVariableBinding[0];
        }
        return (IVariableBinding[])StreamSupport.stream(this.typeSymbol.members().getSymbols().spliterator(), false).filter(Symbol.VarSymbol.class::isInstance).map(Symbol.VarSymbol.class::cast).filter(sym -> sym.name != this.names.error).map(varSym -> this.resolver.bindings.getVariableBinding((Symbol.VarSymbol)varSym)).filter(Objects::nonNull).toArray(IVariableBinding[]::new);
    }

    public IMethodBinding[] getDeclaredMethods() {
        if (this.typeSymbol.members() == null) {
            return new IMethodBinding[0];
        }
        if (this.isRecord()) {
            ArrayList<Symbol> l = new ArrayList<Symbol>();
            this.typeSymbol.members().getSymbols().forEach(l::add);
            Collections.reverse(l);
            IMethodBinding[] ret = this.getDeclaredMethodsForRecords(l);
            if (ret != null) {
                return ret;
            }
        }
        Stream<JavacMethodBinding> methods = StreamSupport.stream(this.typeSymbol.members().getSymbols(Symbol.MethodSymbol.class::isInstance, Scope.LookupKind.NON_RECURSIVE).spliterator(), false).map(Symbol.MethodSymbol.class::cast).map(sym -> {
            Type.MethodType methodType = this.types.memberType(this.type, (Symbol)sym).asMethodType();
            return this.resolver.bindings.getMethodBinding(methodType, (Symbol.MethodSymbol)sym, this.type, this.isGeneric);
        }).filter(Objects::nonNull);
        if (!this.isFromSource()) {
            java.util.List<Object> tmp = java.util.List.of();
            IJavaElement iJavaElement = this.getJavaElement();
            if (iJavaElement instanceof IType) {
                IType type = (IType)iJavaElement;
                try {
                    tmp = Arrays.asList(type.getChildren());
                }
                catch (JavaModelException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
            java.util.List orderedListFromModel = tmp;
            methods = methods.sorted(Comparator.comparingInt(binding -> {
                IMethod elt = binding.getUnresolvedJavaElement();
                return elt != null ? orderedListFromModel.indexOf(elt) : -1;
            }));
        }
        return (IMethodBinding[])methods.toArray(IMethodBinding[]::new);
    }

    private ITypeBinding[] getDeclaredTypeDefaultImpl(ArrayList<Symbol> l) {
        return (ITypeBinding[])StreamSupport.stream(l.spliterator(), false).filter(Symbol.ClassSymbol.class::isInstance).map(Symbol.ClassSymbol.class::cast).map(sym -> {
            Type t = this.types.memberType(this.type, (Symbol)sym);
            return this.resolver.bindings.getTypeBinding(t, this.isGeneric);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(ITypeBinding::getName)).toArray(ITypeBinding[]::new);
    }

    private IMethodBinding[] getDeclaredMethodsForRecords(ArrayList<Symbol> l) {
        boolean isRecord;
        ASTNode node = this.resolver.symbolToDeclaration.get(this.typeSymbol);
        boolean bl = isRecord = this.isRecord() && node instanceof RecordDeclaration;
        if (!isRecord) {
            return null;
        }
        RecordDeclaration rd = (RecordDeclaration)node;
        java.util.List bodies = rd.bodyDeclarations();
        java.util.List explicitMethods = bodies.stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(Objects::nonNull).map(x -> x.getName().toString()).map(String.class::cast).collect(Collectors.toList());
        explicitMethods.add("<init>");
        return (IMethodBinding[])StreamSupport.stream(l.spliterator(), false).filter(Symbol.MethodSymbol.class::isInstance).map(Symbol.MethodSymbol.class::cast).map(sym -> {
            String symName = sym.name.toString();
            boolean isSynthetic = !explicitMethods.contains(symName);
            Type.MethodType methodType = this.types.memberType(this.type, (Symbol)sym).asMethodType();
            return this.resolver.bindings.getMethodBinding(methodType, (Symbol.MethodSymbol)sym, this.type, isSynthetic);
        }).filter(Objects::nonNull).toArray(IMethodBinding[]::new);
    }

    public int getDeclaredModifiers() {
        int n;
        ASTNode aSTNode = this.resolver.findNode(this.typeSymbol);
        if (aSTNode instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)aSTNode;
            n = typeDecl.getModifiers();
        } else {
            n = 0;
        }
        return n;
    }

    public ITypeBinding[] getDeclaredTypes() {
        Scope.WriteableScope members = this.typeSymbol.members();
        if (members == null) {
            return new ITypeBinding[0];
        }
        ArrayList<Symbol> l = new ArrayList<Symbol>();
        for (Symbol s : members.getSymbols()) {
            l.add(s);
        }
        return this.getDeclaredTypeDefaultImpl(l);
    }

    public ITypeBinding getDeclaringClass() {
        Symbol parentSymbol = this.typeSymbol.owner;
        do {
            if (!(parentSymbol instanceof Symbol.ClassSymbol)) continue;
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)parentSymbol;
            return this.resolver.bindings.getTypeBinding(clazz.type, true);
        } while ((parentSymbol = parentSymbol.owner) != null);
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        Symbol parentSymbol = this.typeSymbol.owner;
        do {
            if (!(parentSymbol instanceof Symbol.MethodSymbol)) continue;
            Symbol.MethodSymbol method = (Symbol.MethodSymbol)parentSymbol;
            Type type = method.type;
            if (type instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)type;
                return this.resolver.bindings.getMethodBinding(methodType, method, null, true);
            }
            Type type2 = method.type;
            if (type2 instanceof Type.ForAll) {
                Type.ForAll faType = (Type.ForAll)type2;
                type2 = faType.qtype;
                if (type2 instanceof Type.MethodType) {
                    Type.MethodType mtt = (Type.MethodType)type2;
                    JavacMethodBinding found = this.resolver.bindings.getMethodBinding(mtt, method, null, true);
                    return found;
                }
            }
            return null;
        } while ((parentSymbol = parentSymbol.owner) != null);
        return null;
    }

    public IBinding getDeclaringMember() {
        if (!this.isLocal()) {
            return null;
        }
        return this.resolver.bindings.getBinding(this.typeSymbol.owner, this.typeSymbol.owner.type);
    }

    public int getDimensions() {
        return this.types.dimensions(this.type);
    }

    public ITypeBinding getElementType() {
        Type t = this.types.elemtype(this.type);
        while (t instanceof Type.ArrayType) {
            t = this.types.elemtype(t);
        }
        if (t == null) {
            return null;
        }
        return this.resolver.bindings.getTypeBinding(t);
    }

    public ITypeBinding getErasure() {
        if (this.isParameterizedType()) {
            return this.resolver.bindings.getTypeBinding(this.type, true);
        }
        if (this.isRawType() && this.typeSymbol.type.isParameterized()) {
            return this.resolver.bindings.getTypeBinding(this.typeSymbol.type, true);
        }
        return this.resolver.bindings.getTypeBinding(this.types.erasureRecursive(this.type));
    }

    public IMethodBinding getFunctionalInterfaceMethod() {
        if (this.typeSymbol == null) {
            return null;
        }
        try {
            Symbol.MethodSymbol methodSymbol;
            Type.MethodType res;
            Symbol symbol = this.types.findDescriptorSymbol(this.typeSymbol);
            if (symbol instanceof Symbol.MethodSymbol && (res = this.types.memberType(this.type, methodSymbol = (Symbol.MethodSymbol)symbol).asMethodType()) != null) {
                return this.resolver.bindings.getMethodBinding(res, methodSymbol, this.type, false);
            }
        }
        catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
            // empty catch block
        }
        return null;
    }

    public ITypeBinding[] getInterfaces() {
        return (ITypeBinding[])this.types.interfaces(this.type).stream().map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    public int getModifiers() {
        int modifiers = JavacMethodBinding.toInt(this.typeSymbol.getModifiers());
        ASTNode aSTNode = this.resolver.findDeclaringNode((IBinding)this);
        if (aSTNode instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)aSTNode;
            modifiers |= typeDecl.getModifiers();
        }
        if (this.isInterface()) {
            modifiers &= 0xFFFFFBFF;
        }
        return modifiers;
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean checkParameterized) {
        ITypeBinding[] types;
        if (this.isIntersectionType()) {
            if (this.alternatives != null) {
                return this.resolver.bindings.getTypeBinding(this.alternatives[0]).getName();
            }
            Type type = this.type;
            if (type instanceof Type.IntersectionClassType) {
                Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)type;
                return this.resolver.bindings.getTypeBinding(intersectionClassType.supertype_field).getName();
            }
        }
        if (this.isArray()) {
            StringBuilder builder = new StringBuilder(this.getElementType().getName());
            for (int i = 0; i < this.getDimensions(); ++i) {
                builder.append("[]");
            }
            return builder.toString();
        }
        Type i = this.type;
        if (i instanceof Type.WildcardType) {
            Type.WildcardType wt = (Type.WildcardType)i;
            if (wt.type == null || this.resolver.resolveWellKnownType("java.lang.Object").equals((Object)this.resolver.bindings.getTypeBinding(wt.type))) {
                return "?";
            }
            StringBuilder builder = new StringBuilder("? ");
            if (wt.isExtendsBound()) {
                builder.append("extends ");
            } else if (wt.isSuperBound()) {
                builder.append("super ");
            }
            builder.append(this.resolver.bindings.getTypeBinding(wt.type).getName());
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder(((Name)this.typeSymbol.getSimpleName()).toString());
        if (checkParameterized && this.isParameterizedType() && (types = this.getUncheckedTypeArguments(this.type, this.typeSymbol)) != null && types.length > 0) {
            builder.append("<");
            for (int z = 0; z < types.length; ++z) {
                ITypeBinding zBinding = types[z];
                if (zBinding == null) continue;
                builder.append(zBinding.getName());
                if (z == types.length - 1) continue;
                builder.append(",");
            }
            builder.append(">");
        }
        return builder.toString();
    }

    public IPackageBinding getPackage() {
        if (this.isPrimitive() || this.isArray() || this.isWildcardType() || this.isNullType() || this.isTypeVariable()) {
            return null;
        }
        return this.typeSymbol.packge() != null ? this.resolver.bindings.getPackageBinding(this.typeSymbol.packge()) : null;
    }

    public String getQualifiedName() {
        return this.getQualifiedNameImpl(this.type, this.typeSymbol, this.typeSymbol.owner, !this.isGeneric);
    }

    public String getQualifiedName(boolean includeParams) {
        return this.getQualifiedNameImpl(this.type, this.typeSymbol, this.typeSymbol.owner, includeParams);
    }

    protected String getQualifiedNameImpl(Type type, Symbol.TypeSymbol typeSymbol, Symbol owner, boolean includeParameters) {
        if (owner instanceof Symbol.MethodSymbol) {
            return "";
        }
        if (type instanceof NullType) {
            return "null";
        }
        if (type instanceof Type.IntersectionClassType) {
            Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)type;
            return "";
        }
        if (type instanceof Type.ArrayType) {
            Type.ArrayType at = (Type.ArrayType)type;
            if (type.tsym.isAnonymous()) {
                return "";
            }
            return this.resolver.bindings.getTypeBinding(at.getComponentType()).getQualifiedName() + "[]";
        }
        if (type instanceof Type.WildcardType) {
            Type.WildcardType wt = (Type.WildcardType)type;
            if (wt.type == null || this.resolver.resolveWellKnownType("java.lang.Object").equals((Object)this.resolver.bindings.getTypeBinding(wt.type)) || this.resolver.bindings.getTypeBinding(wt.type).isIntersectionType() && this.resolver.resolveWellKnownType("java.lang.Object").equals((Object)this.resolver.bindings.getTypeBinding(wt.type).getSuperclass())) {
                return "?";
            }
            StringBuilder builder = new StringBuilder("? ");
            if (wt.isExtendsBound()) {
                builder.append("extends ");
            } else if (wt.isSuperBound()) {
                builder.append("super ");
            }
            builder.append(this.resolver.bindings.getTypeBinding(wt.type).getQualifiedName());
            return builder.toString();
        }
        if (this.isAnonymous()) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        if (owner instanceof Symbol.RootPackageSymbol) {
            return type == null || type.tsym == null || type.tsym.name == null ? "" : type.tsym.name.toString();
        }
        if (owner instanceof Symbol.TypeSymbol) {
            Type.ClassType ct;
            Symbol.TypeSymbol tss = (Symbol.TypeSymbol)owner;
            Type parentType = type instanceof Type.ClassType && (ct = (Type.ClassType)type).getEnclosingType() != Type.noType ? ct.getEnclosingType() : tss.type;
            String parentName = this.getQualifiedNameImpl(parentType, tss, tss.owner, includeParameters);
            res.append(parentName);
            if (!"".equals(parentName)) {
                res.append(".");
            }
            res.append(typeSymbol.name.toString());
        } else {
            res.append(typeSymbol.toString());
        }
        if (includeParameters) {
            boolean isTypeDeclaration;
            ITypeBinding[] typeArguments = this.getUncheckedTypeArguments(type, typeSymbol);
            boolean bl = isTypeDeclaration = typeSymbol != null && typeSymbol.type == type;
            if (!isTypeDeclaration && typeArguments.length > 0) {
                int i;
                res.append("<");
                for (i = 0; i < typeArguments.length - 1; ++i) {
                    res.append(typeArguments[i].getQualifiedName());
                    res.append(",");
                }
                res.append(typeArguments[i].getQualifiedName());
                res.append(">");
            }
        }
        int annotationIndex = -1;
        while ((annotationIndex = res.lastIndexOf("@")) >= 0) {
            int nextSpace = res.indexOf(" ", annotationIndex);
            if (nextSpace < 0) continue;
            res.delete(annotationIndex, nextSpace + 1);
        }
        return res.toString();
    }

    public ITypeBinding getSuperclass() {
        Symbol.ClassSymbol classSymbol;
        AnnoConstruct annoConstruct;
        Type superType = this.types.supertype(this.type);
        if (superType != null && !(superType instanceof Type.JCNoType)) {
            if (this.isInterface() && superType.toString().equals("java.lang.Object")) {
                return null;
            }
            return this.resolver.bindings.getTypeBinding(superType);
        }
        String jlObject = this.typeSymbol.getQualifiedName().toString();
        if (Object.class.getName().equals(jlObject)) {
            return null;
        }
        if (this.typeSymbol instanceof Symbol.TypeVariableSymbol && (annoConstruct = this.type) instanceof Type.TypeVar) {
            Type.TypeVar tv = (Type.TypeVar)annoConstruct;
            Type t = tv.getUpperBound();
            JavacTypeBinding possible = this.resolver.bindings.getTypeBinding(t);
            if (!possible.isInterface()) {
                return possible;
            }
            if (t instanceof Type.ClassType) {
                Type.ClassType ct;
                Type.ClassType working = ct = (Type.ClassType)t;
                while (working != null) {
                    Type wt = working.supertype_field;
                    String sig = this.getKey(wt);
                    if (new String(ConstantPool.JavaLangObjectSignature).equals(sig)) {
                        return this.resolver.bindings.getTypeBinding(wt);
                    }
                    working = wt instanceof Type.ClassType ? (Type.ClassType)wt : null;
                }
            }
        }
        if ((annoConstruct = this.typeSymbol) instanceof Symbol.ClassSymbol && (classSymbol = (Symbol.ClassSymbol)annoConstruct).getSuperclass() != null && classSymbol.getSuperclass().tsym != null) {
            return this.resolver.bindings.getTypeBinding(classSymbol.getSuperclass());
        }
        return null;
    }

    public IAnnotationBinding[] getTypeAnnotations() {
        if (this.typeSymbol.hasTypeAnnotations()) {
            return new IAnnotationBinding[0];
        }
        return new IAnnotationBinding[0];
    }

    public ITypeBinding[] getTypeArguments() {
        return this.getTypeArguments(this.type, this.typeSymbol);
    }

    private ITypeBinding[] getTypeArgumentsForBase(Type t, Symbol.TypeSymbol ts) {
        if (t instanceof Type.ArrayType) {
            Type.ArrayType at = (Type.ArrayType)t;
            return this.getTypeArguments(at.elemtype, at.tsym);
        }
        return this.getTypeArguments(t, ts);
    }

    private ITypeBinding[] getTypeArguments(Type t, Symbol.TypeSymbol ts) {
        if (!this.isParameterizedType(t) || this.isTargettingPreGenerics()) {
            return NO_TYPE_ARGUMENTS;
        }
        return this.getUncheckedTypeArguments(t, ts);
    }

    private ITypeBinding[] getUncheckedTypeArguments(Type t, Symbol.TypeSymbol ts) {
        return (ITypeBinding[])t.getTypeArguments().stream().map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    private boolean isTargettingPreGenerics() {
        if (this.resolver.javaProject == null) {
            return false;
        }
        String target = this.resolver.javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        return "1.1".equals(target) || "cldc1.1".equals(target) || "1.2".equals(target) || "1.3".equals(target) || "1.4".equals(target);
    }

    public ITypeBinding[] getTypeBounds() {
        if (this.isIntersectionType() || this.type.isUnion()) {
            if (this.alternatives != null) {
                return (ITypeBinding[])Stream.of(this.alternatives).map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
            }
            Type type = this.type;
            if (type instanceof Type.IntersectionClassType) {
                Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)type;
                return (ITypeBinding[])intersectionClassType.interfaces_field.stream().map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
            }
            type = this.type;
            if (type instanceof Type.UnionClassType) {
                Type.UnionClassType unionClassType = (Type.UnionClassType)type;
                return (ITypeBinding[])unionClassType.interfaces_field.stream().map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
            }
        } else {
            Type bounds;
            Type z1;
            Type intersectionClassType = this.type;
            if (intersectionClassType instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)intersectionClassType;
                z1 = classType.supertype_field;
                List<Type> z2 = classType.interfaces_field;
                ArrayList<JavacTypeBinding> l = new ArrayList<JavacTypeBinding>();
                if (z1 != null) {
                    l.add(this.resolver.bindings.getTypeBinding(z1));
                }
                if (z2 != null) {
                    for (int i = 0; i < z2.size(); ++i) {
                        l.add(this.resolver.bindings.getTypeBinding((Type)z2.get(i)));
                    }
                }
                return (ITypeBinding[])l.toArray(JavacTypeBinding[]::new);
            }
            z1 = this.type;
            if (z1 instanceof Type.TypeVar) {
                Type.TypeVar typeVar = (Type.TypeVar)z1;
                bounds = typeVar.getUpperBound();
                if (bounds instanceof Type.IntersectionClassType) {
                    Type.IntersectionClassType intersectionType = (Type.IntersectionClassType)bounds;
                    return (ITypeBinding[])intersectionType.getBounds().stream().filter(Type.class::isInstance).map(Type.class::cast).map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
                }
                return new ITypeBinding[]{this.resolver.bindings.getTypeBinding(bounds)};
            }
            bounds = this.type;
            if (bounds instanceof Type.WildcardType) {
                Type.WildcardType wildcardType = (Type.WildcardType)bounds;
                boolean isUnbound = wildcardType.isUnbound();
                boolean isSuperBound = wildcardType.isSuperBound();
                Type type = wildcardType.type;
                if (type instanceof Type.TypeVar) {
                    Type.TypeVar typeVar = (Type.TypeVar)type;
                    return this.resolver.bindings.getTypeVariableBinding(typeVar).getTypeBounds();
                }
                return new ITypeBinding[]{isUnbound || isSuperBound ? this.resolver.resolveWellKnownType(Object.class.getName()) : this.resolver.bindings.getTypeBinding(wildcardType.type)};
            }
        }
        return new ITypeBinding[0];
    }

    public ITypeBinding getTypeDeclaration() {
        if (this.isParameterizedType() || this.isRawType()) {
            return this.getErasure();
        }
        return this.typeSymbol.type == this.type ? this : this.resolver.bindings.getTypeBinding(this.typeSymbol.type, true);
    }

    public ITypeBinding[] getTypeParameters() {
        return this.getTypeParameters(this.type);
    }

    public ITypeBinding[] getTypeParametersForBase(Type t) {
        if (t instanceof Type.ArrayType) {
            Type.ArrayType at = (Type.ArrayType)t;
            return this.getTypeParameters(at.elemtype);
        }
        return this.getTypeParameters(t);
    }

    public ITypeBinding[] getTypeParameters(Type t) {
        if (!this.isGenericType(t) || this.isTargettingPreGenerics() || !(t instanceof Type.ClassType)) {
            return new ITypeBinding[0];
        }
        return (ITypeBinding[])((List)((Type.ClassType)t).getTypeArguments()).map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    public ITypeBinding getWildcard() {
        Type type = this.type;
        if (type instanceof Type.CapturedType) {
            Type.CapturedType capturedType = (Type.CapturedType)type;
            return this.resolver.bindings.getTypeBinding(capturedType.wildcard);
        }
        return null;
    }

    public boolean isAnnotation() {
        return this.typeSymbol.isAnnotationType();
    }

    public boolean isAnonymous() {
        return this.typeSymbol.isAnonymous();
    }

    public boolean isArray() {
        return this.type instanceof Type.ArrayType;
    }

    public boolean isAssignmentCompatible(ITypeBinding variableType) {
        if (variableType instanceof JavacTypeBinding) {
            JavacTypeBinding other = (JavacTypeBinding)variableType;
            return this.types.isAssignable(this.type, other.type);
        }
        throw new UnsupportedOperationException("Cannot mix with non Javac binding");
    }

    public boolean isCapture() {
        return this.type instanceof Type.CapturedType;
    }

    public boolean isCastCompatible(ITypeBinding type) {
        if (type instanceof JavacTypeBinding) {
            JavacTypeBinding other = (JavacTypeBinding)type;
            return this.types.isCastable(other.type, this.type);
        }
        throw new UnsupportedOperationException("Cannot mix with non Javac binding");
    }

    public boolean isClass() {
        Symbol.ClassSymbol classSymbol;
        Symbol.TypeSymbol typeSymbol = this.typeSymbol;
        return typeSymbol instanceof Symbol.ClassSymbol && !(classSymbol = (Symbol.ClassSymbol)typeSymbol).isEnum() && !classSymbol.isInterface();
    }

    public boolean isEnum() {
        return this.typeSymbol.isEnum();
    }

    public boolean isRecord() {
        Symbol.ClassSymbol classSymbol;
        Symbol.TypeSymbol typeSymbol = this.typeSymbol;
        return typeSymbol instanceof Symbol.ClassSymbol && (classSymbol = (Symbol.ClassSymbol)typeSymbol).isRecord();
    }

    public boolean isFromSource() {
        return this.resolver.findDeclaringNode((IBinding)this) != null || this.getJavaElement() instanceof SourceType || this.getDeclaringClass() != null && this.getDeclaringClass().isFromSource() || this.isCapture();
    }

    public boolean isGenericType() {
        return this.isGenericType(this.type);
    }

    public boolean isGenericType(Type t) {
        return !this.isRawType(t) && t.isParameterized() && this.isGeneric;
    }

    public boolean isInterface() {
        return this.typeSymbol.isInterface();
    }

    public boolean isIntersectionType() {
        return this.type.isIntersection();
    }

    public boolean isLocal() {
        ASTNode aSTNode = this.resolver.findDeclaringNode((IBinding)this);
        if (aSTNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration node = (AbstractTypeDeclaration)aSTNode;
            return !(node.getParent() instanceof CompilationUnit) && !(node.getParent() instanceof AbstractTypeDeclaration) && !(node.getParent() instanceof AnonymousClassDeclaration);
        }
        return this.typeSymbol.owner.kind.matches(Kinds.KindSelector.VAL_MTH);
    }

    public boolean isMember() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            return this.typeSymbol.owner instanceof Symbol.ClassSymbol;
        }
        return false;
    }

    public boolean isNested() {
        if (this.isTypeVariable()) {
            return false;
        }
        return this.getDeclaringClass() != null;
    }

    public boolean isNullType() {
        Type.ErrorType et;
        Type type;
        return this.type instanceof NullType || (type = this.type) instanceof Type.ErrorType && (et = (Type.ErrorType)type).getOriginalType() instanceof NullType;
    }

    public boolean isParameterizedType() {
        return this.isParameterizedType(this.type);
    }

    public boolean isParameterizedType(Type t) {
        return t.isParameterized() && !this.isGeneric;
    }

    public boolean isPrimitive() {
        return this.type.isPrimitiveOrVoid();
    }

    public boolean isRawType() {
        return this.isRawType(this.type);
    }

    private boolean isRawType(Type type2) {
        return type2.isRaw();
    }

    public boolean isSubTypeCompatible(ITypeBinding type) {
        if (this == type) {
            return true;
        }
        if (type instanceof JavacTypeBinding) {
            JavacTypeBinding other = (JavacTypeBinding)type;
            return this.types.isSubtype(this.type, other.type);
        }
        return false;
    }

    public boolean isTopLevel() {
        return this.getDeclaringClass() == null;
    }

    public boolean isTypeVariable() {
        return this.type instanceof Type.TypeVar;
    }

    public boolean isUpperbound() {
        return this.type.isExtendsBound();
    }

    public boolean isWildcardType() {
        return this.type instanceof Type.WildcardType;
    }

    public IModuleBinding getModule() {
        Symbol o = this.type.tsym.owner;
        if (o instanceof Symbol.PackageSymbol) {
            Symbol.PackageSymbol ps = (Symbol.PackageSymbol)o;
            return this.resolver.bindings.getModuleBinding(ps.modle);
        }
        return null;
    }

    public void setRecovered(boolean recovered) {
        this.recovered = recovered;
    }

    public String toString() {
        if (this.isIntersectionType()) {
            Type.IntersectionClassType intersectionClassType = (Type.IntersectionClassType)this.type;
            StringBuilder builder = new StringBuilder();
            builder.append(Arrays.stream(this.getAnnotations()).map(Object::toString).map(ann -> ann + " ").collect(Collectors.joining()));
            builder.append(this.resolver.bindings.getTypeBinding(intersectionClassType.supertype_field).getQualifiedName());
            for (Type superinterface : intersectionClassType.interfaces_field) {
                builder.append(" & ");
                builder.append(this.resolver.bindings.getTypeBinding(superinterface).getQualifiedName());
            }
            return builder.toString();
        }
        return Arrays.stream(this.getAnnotations()).map(Object::toString).map(ann -> ann + " ").collect(Collectors.joining()) + this.getQualifiedName();
    }
}

