/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.resolver;

import com.microsoft.gradle.manager.GradleFilesManager;
import com.microsoft.gradle.resolver.GradleClosure;
import com.microsoft.gradle.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class GradleLibraryResolver {
    private static String JAVA_PLUGIN = "org.gradle.api.plugins.JavaPlugin";
    private GradleFilesManager gradleFilesManager;
    private Map<String, JavaClass> gradleClasses = new HashMap<String, JavaClass>();
    private Set<String> javaConfigurations = new HashSet<String>();
    private Set<String> javaPlugins = new HashSet<String>();
    private Map<String, List<String>> projectPlugins = new HashMap<String, List<String>>();
    private Map<String, List<GradleClosure>> extClosures = new HashMap<String, List<GradleClosure>>();
    private String gradleHome;
    private String gradleVersion;
    private boolean gradleWrapperEnabled;
    private Path workspacePath;
    private File coreAPI;
    private File pluginAPI;
    private boolean needToLoadClasses;
    private Path gradleUserHomePath;

    public GradleLibraryResolver(GradleFilesManager gradleFilesManager) {
        this.gradleFilesManager = gradleFilesManager;
        this.javaPlugins.addAll(Arrays.asList("java", "application", "groovy", "java-library", "war"));
        this.needToLoadClasses = true;
        this.gradleUserHomePath = Paths.get(System.getProperty("user.home"), ".gradle");
    }

    public void setGradleHome(String gradleHome) {
        this.gradleHome = gradleHome;
    }

    public void setGradleVersion(String gradleVersion) {
        this.gradleVersion = gradleVersion;
    }

    public void setGradleWrapperEnabled(Boolean gradleWrapperEnabled) {
        this.gradleWrapperEnabled = gradleWrapperEnabled == null ? true : gradleWrapperEnabled;
    }

    public void setGradleUserHomePath(String gradleUserHome) {
        this.gradleUserHomePath = gradleUserHome != null ? Paths.get(gradleUserHome, new String[0]) : Paths.get(System.getProperty("user.home"), ".gradle");
    }

    public void setWorkspacePath(Path workspacePath) {
        this.workspacePath = workspacePath;
    }

    public Map<String, JavaClass> getGradleClasses() {
        return this.gradleClasses;
    }

    public Set<String> getJavaConfigurations() {
        return this.javaConfigurations;
    }

    public List<GradleClosure> getExtClosures(String projectPath) {
        return this.extClosures.get(projectPath);
    }

    public boolean resolveGradleAPI() {
        return this.resolveGradleAPI(null);
    }

    public boolean resolveGradleAPI(URI gradleFilePath) {
        this.needToLoadClasses = true;
        File libFolder = null;
        if (this.gradleWrapperEnabled) {
            DistInfo info = this.getWrapperPropertiesInfo(gradleFilePath);
            if (info == null) {
                return false;
            }
            libFolder = this.findLibFolder(info);
        } else if (this.gradleVersion != null) {
            Path distsPath = this.gradleUserHomePath.resolve(Paths.get("wrapper", "dists"));
            String distName = "gradle-" + this.gradleVersion;
            libFolder = this.findLibFolder(new DistInfo(distsPath, distName));
        } else if (this.gradleHome != null) {
            libFolder = Paths.get(this.gradleHome, new String[0]).resolve("lib").toFile();
        }
        if (!Utils.isValidFolder(libFolder)) {
            return false;
        }
        File newAPI = this.findCoreAPI(libFolder);
        if (!Utils.isValidFile(newAPI)) {
            return false;
        }
        if (this.coreAPI != null && this.coreAPI.equals(newAPI)) {
            this.needToLoadClasses = false;
            return false;
        }
        this.gradleFilesManager.setGradleLibraries(Utils.listAllFiles(libFolder));
        this.coreAPI = newAPI;
        this.pluginAPI = this.findPluginAPI(this.coreAPI.toPath().getParent().resolve(Paths.get("plugins", new String[0])).toFile());
        return Utils.isValidFile(this.pluginAPI);
    }

    public void loadGradleClasses(URI uri) {
        boolean isAPIValid;
        boolean bl = isAPIValid = Utils.isValidFile(this.coreAPI) && Utils.isValidFile(this.pluginAPI);
        if (!this.needToLoadClasses || !isAPIValid && !this.resolveGradleAPI(uri)) {
            return;
        }
        try {
            JarFile coreAPIJar = new JarFile(this.coreAPI);
            this.loadClasses(this.coreAPI.toPath(), coreAPIJar);
            JarFile pluginAPIJar = new JarFile(this.pluginAPI);
            this.loadClasses(this.pluginAPI.toPath(), pluginAPIJar);
            this.loadJavaConfigurations();
            this.needToLoadClasses = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DistInfo getWrapperPropertiesInfo(URI gradleFilePath) {
        if (this.workspacePath == null && gradleFilePath == null) {
            return null;
        }
        Path propertiesRelativePath = Paths.get("gradle", "wrapper", "gradle-wrapper.properties");
        Path propertiesPath = null;
        propertiesPath = gradleFilePath != null ? Paths.get(gradleFilePath).getParent().resolve(propertiesRelativePath) : this.workspacePath.resolve(propertiesRelativePath);
        File propertiesFile = propertiesPath.toFile();
        if (!propertiesFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try (FileInputStream stream = new FileInputStream(propertiesFile);){
            Path distributionBase;
            properties.load(stream);
            String distributionBaseValue = properties.getProperty("distributionBase");
            if (distributionBaseValue == null) {
                distributionBaseValue = "GRADLE_USER_HOME";
            }
            if ((distributionBase = this.getDistributionBase(distributionBaseValue)) == null) {
                DistInfo distInfo = null;
                return distInfo;
            }
            String distributionPath = properties.getProperty("distributionPath");
            if (distributionPath == null) {
                distributionPath = "wrapper/dists";
            }
            Path distPath = distributionBase.resolve(distributionPath);
            String distributionUrl = properties.getProperty("distributionUrl");
            if (distributionUrl == null) {
                DistInfo distInfo = null;
                return distInfo;
            }
            Path fileName = Paths.get(new URL(distributionUrl).getPath(), new String[0]).getFileName();
            DistInfo distInfo = new DistInfo(distPath, Utils.getFileNameWithoutExtension(fileName));
            return distInfo;
        }
        catch (IOException e) {
            return null;
        }
    }

    private File findLibFolder(DistInfo info) {
        File distFolder = info.distsPath.toFile();
        if (!Utils.isValidFolder(distFolder)) {
            return null;
        }
        File targetFolder = Utils.findSubFolder(distFolder, info.distName);
        if (!Utils.isValidFolder(targetFolder)) {
            return null;
        }
        for (File internalValueFolder : targetFolder.listFiles()) {
            if (!Utils.isValidFolder(internalValueFolder)) continue;
            for (File extractFolder : internalValueFolder.listFiles()) {
                if (!Utils.isValidFolder(extractFolder)) continue;
                return extractFolder.toPath().resolve("lib").toFile();
            }
        }
        return null;
    }

    private File findCoreAPI(File folder) {
        String name;
        for (File file : folder.listFiles()) {
            name = file.getName();
            if (!name.startsWith("gradle-core-api") || !name.endsWith(".jar")) continue;
            return file;
        }
        for (File file : folder.listFiles()) {
            name = file.getName();
            if (!name.startsWith("gradle-core") || !name.endsWith(".jar")) continue;
            return file;
        }
        return null;
    }

    private File findPluginAPI(File folder) {
        for (File file : folder.listFiles()) {
            String name = file.getName();
            if (!name.startsWith("gradle-plugins") || !name.endsWith(".jar")) continue;
            return file;
        }
        return null;
    }

    private void loadClasses(Path jarPath, JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            ClassParser parser = new ClassParser(jarPath.toString(), entry.getName());
            try {
                JavaClass javaClass = parser.parse();
                String className = javaClass.getClassName();
                this.gradleClasses.put(className, javaClass);
            }
            catch (IOException | ClassFormatException throwable) {}
        }
    }

    private void loadJavaConfigurations() {
        JavaClass javaPluginClass = this.gradleClasses.get(JAVA_PLUGIN);
        if (javaPluginClass == null) {
            return;
        }
        for (Field field : javaPluginClass.getFields()) {
            if (!field.getName().endsWith("CONFIGURATION_NAME")) continue;
            this.javaConfigurations.add(GradleLibraryResolver.removeQuotes(field.getConstantValue().toString()));
        }
    }

    public void setExtClosures(String projectPath, List<GradleClosure> closures) {
        this.extClosures.put(projectPath, closures);
    }

    private static String removeQuotes(String original) {
        if (original.length() < 3) {
            return original;
        }
        return original.substring(1, original.length() - 1);
    }

    public void setProjectPlugins(String projectPath, List<String> plugins) {
        this.projectPlugins.put(projectPath, plugins);
    }

    public boolean isJavaPluginsIncluded(URI uri, Set<String> plugins) {
        List<String> pluginsList;
        String folderPath = Utils.getFolderPath(uri);
        if (folderPath != null && (pluginsList = this.projectPlugins.get(folderPath)) != null && pluginsList.contains("java")) {
            return true;
        }
        for (String plugin : plugins) {
            if (!this.javaPlugins.contains(plugin)) continue;
            return true;
        }
        return false;
    }

    private Path getDistributionBase(String distributionBase) {
        if (distributionBase.equals("GRADLE_USER_HOME")) {
            return this.gradleUserHomePath;
        }
        if (distributionBase.equals("PROJECT")) {
            return this.workspacePath;
        }
        return null;
    }

    private class DistInfo {
        public Path distsPath;
        public String distName;

        public DistInfo(Path distsPath, String distName) {
            this.distsPath = distsPath;
            this.distName = distName;
        }
    }
}

