/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.reporter;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.LogMessageParams;
import ch.epfl.scala.bsp4j.MessageType;
import ch.epfl.scala.bsp4j.TaskId;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.task.TaskOperationDescriptor;

public abstract class ProgressReporter
implements ProgressListener {
    protected final BuildClient client;
    protected final String originId;
    protected final TaskId taskId;
    protected final List<String> taskIds;

    public ProgressReporter(BuildClient client, String originId) {
        this.client = client;
        this.originId = originId;
        this.taskId = new TaskId(UUID.randomUUID().toString());
        this.taskIds = new ArrayList<String>();
        this.taskIds.add(this.taskId.getId());
    }

    public void sendError(String error) {
        if (this.client != null) {
            LogMessageParams messageParam = new LogMessageParams(MessageType.ERROR, error);
            messageParam.setOriginId(this.originId);
            messageParam.setTask(this.taskId);
            this.client.onBuildLogMessage(messageParam);
        }
    }

    protected TaskId getTaskId(String taskPath) {
        TaskId taskId = new TaskId(taskPath == null ? "null" : taskPath);
        taskId.setParents(this.taskIds);
        return taskId;
    }

    protected String getTaskPath(OperationDescriptor operationDescriptor) {
        if (operationDescriptor == null) {
            return null;
        }
        if (operationDescriptor instanceof TaskOperationDescriptor) {
            return ((TaskOperationDescriptor)operationDescriptor).getTaskPath();
        }
        OperationDescriptor parent = operationDescriptor.getParent();
        if (parent != operationDescriptor) {
            return this.getTaskPath(operationDescriptor.getParent());
        }
        return null;
    }
}

