/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class ConvertLoopCleanUpCore
extends AbstractCleanUp {
    public ConvertLoopCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public ConvertLoopCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.isEnabled("cleanup.convert_to_enhanced_for_loop"), false, false, null);
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean convertForLoops = this.isEnabled("cleanup.convert_to_enhanced_for_loop");
        boolean checkIfLoopVarUsed = this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used");
        return ConvertLoopFixCore.createCleanUp(compilationUnit, convertForLoops, convertForLoops, this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final"), checkIfLoopVarUsed);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            if (this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used")) {
                result.add(MultiFixMessages.Java50CleanUp_ConvertLoopOnlyIfLoopVarUsed_description);
            } else {
                result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            buf.append("for (int id : ids) {\n");
            buf.append("    double value= id / 2; \n");
            buf.append("    System.out.println(value);\n");
            buf.append("}\n\n");
        } else {
            buf.append("for (int i = 0; i < ids.length; i++) {\n");
            buf.append("    double value= ids[i] / 2; \n");
            buf.append("    System.out.println(value);\n");
            buf.append("}\n\n");
        }
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop") && !this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used")) {
            buf.append("for (int id : ids) {\n");
            buf.append("    System.out.println(\"here\");\n");
            buf.append("}\n");
        } else {
            buf.append("for (int i = 0; i < ids.length; i++) {\n");
            buf.append("    System.out.println(\"here\");\n");
            buf.append("}\n");
        }
        return buf.toString();
    }
}

