/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin;

import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.JavaExtension;
import com.microsoft.java.bs.gradle.model.SupportedLanguage;
import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import com.microsoft.java.bs.gradle.model.impl.DefaultJavaExtension;
import com.microsoft.java.bs.gradle.plugin.LanguageModelBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.util.GradleVersion;

public class JavaLanguageModelBuilder
extends LanguageModelBuilder {
    public SupportedLanguage<JavaExtension> getLanguage() {
        return SupportedLanguages.JAVA;
    }

    @Override
    public DefaultJavaExtension getExtensionFor(Project project, SourceSet sourceSet, Set<GradleModuleDependency> moduleDependencies) {
        JavaCompile javaCompile = this.getJavaCompileTask(project, sourceSet);
        if (javaCompile != null) {
            DefaultJavaExtension extension = new DefaultJavaExtension();
            extension.setJavaHome(DefaultInstalledJdk.current().getJavaHome());
            extension.setJavaVersion(DefaultInstalledJdk.current().getJavaVersion().getMajorVersion());
            extension.setCompileTaskName(javaCompile.getName());
            extension.setSourceDirs(sourceSet.getJava().getSrcDirs());
            HashSet<File> generatedSrcDirs = new HashSet<File>();
            this.addAnnotationProcessingDir(javaCompile, generatedSrcDirs);
            this.addGeneratedSourceDirs(javaCompile, extension.getSourceDirs(), generatedSrcDirs);
            extension.setGeneratedSourceDirs(generatedSrcDirs);
            extension.setClassesDir(this.getClassesDir((AbstractCompile)javaCompile));
            List<String> compilerArgs = this.getCompilerArgs(javaCompile);
            extension.setCompilerArgs(compilerArgs);
            extension.setSourceCompatibility(javaCompile.getSourceCompatibility());
            extension.setTargetCompatibility(javaCompile.getTargetCompatibility());
            return extension;
        }
        return null;
    }

    private JavaCompile getJavaCompileTask(Project project, SourceSet sourceSet) {
        return (JavaCompile)this.getLanguageCompileTask(project, sourceSet);
    }

    private void addAnnotationProcessingDir(JavaCompile javaCompile, Set<File> generatedSrcDirs) {
        File generatedDir;
        CompileOptions options = javaCompile.getOptions();
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.3")) >= 0) {
            Directory generatedDir2 = (Directory)options.getGeneratedSourceOutputDirectory().getOrNull();
            if (generatedDir2 != null) {
                generatedSrcDirs.add(generatedDir2.getAsFile());
            }
        } else if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.3")) >= 0 && (generatedDir = options.getAnnotationProcessorGeneratedSourcesDirectory()) != null) {
            generatedSrcDirs.add(generatedDir);
        }
    }

    private void addGeneratedSourceDirs(JavaCompile javaCompile, Set<File> srcDirs, Set<File> generatedSrcDirs) {
        Set filesToCompile = javaCompile.getSource().getFiles();
        for (File file : filesToCompile) {
            File srcDir;
            if (this.canSkipInferSourceRoot(file, srcDirs, generatedSrcDirs) || (srcDir = this.findSourceDirForGeneratedFile(file)) == null) continue;
            generatedSrcDirs.add(srcDir);
        }
    }

    private boolean canSkipInferSourceRoot(File sourceFile, Set<File> srcDirs, Set<File> generatedSrcDirs) {
        if (!(sourceFile.isFile() && sourceFile.exists() && sourceFile.getName().endsWith(".java"))) {
            return true;
        }
        if (srcDirs.stream().anyMatch(dir -> sourceFile.getAbsolutePath().startsWith(dir.getAbsolutePath()))) {
            return true;
        }
        return generatedSrcDirs.stream().anyMatch(dir -> sourceFile.getAbsolutePath().startsWith(dir.getAbsolutePath()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File findSourceDirForGeneratedFile(File file) {
        Pattern packagePattern = Pattern.compile("^\\s*package\\s+([\\w.]+)\\s*;\\s*$");
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            Matcher matcher;
            do {
                if ((line = reader.readLine()) == null) return null;
            } while (!(matcher = packagePattern.matcher(line)).matches());
            String packageName = matcher.group(1);
            String relativeToRoot = packageName.replace(".", File.separator).concat(File.separator).concat(file.getName());
            String absolutePath = file.getAbsolutePath();
            if (!absolutePath.endsWith(relativeToRoot)) {
                File file2 = null;
                return file2;
            }
            File file3 = new File(absolutePath.substring(0, absolutePath.length() - relativeToRoot.length()));
            return file3;
        }
        catch (IOException e) {
            return null;
        }
    }

    private DefaultJavaCompileSpec getJavaCompileSpec(JavaCompile javaCompile) {
        String targetCompatibility;
        String sourceCompatibility;
        CompileOptions options = javaCompile.getOptions();
        DefaultJavaCompileSpec specs = new DefaultJavaCompileSpec();
        specs.setCompileOptions(options);
        List originalArgs = options.getCompilerArgs();
        String argsSourceCompatibility = this.getSourceCompatibility(originalArgs);
        String argsTargetCompatibility = this.getTargetCompatibility(originalArgs);
        if (!argsSourceCompatibility.isEmpty() && !argsTargetCompatibility.isEmpty()) {
            return specs;
        }
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.6")) >= 0 && options.getRelease().isPresent()) {
            specs.setRelease((Integer)options.getRelease().get());
            return specs;
        }
        if (argsSourceCompatibility.isEmpty() && specs.getSourceCompatibility() == null && (sourceCompatibility = javaCompile.getSourceCompatibility()) != null) {
            specs.setSourceCompatibility(sourceCompatibility);
        }
        if (argsTargetCompatibility.isEmpty() && specs.getTargetCompatibility() == null && (targetCompatibility = javaCompile.getTargetCompatibility()) != null) {
            specs.setTargetCompatibility(targetCompatibility);
        }
        return specs;
    }

    private List<String> getCompilerArgs(JavaCompile javaCompile) {
        CompileOptions options = javaCompile.getOptions();
        try {
            DefaultJavaCompileSpec specs = this.getJavaCompileSpec(javaCompile);
            JavaCompilerArgumentsBuilder builder = new JavaCompilerArgumentsBuilder((JavaCompileSpec)specs).includeMainOptions(true).includeClasspath(false).includeSourceFiles(false).includeLauncherOptions(false);
            return builder.build();
        }
        catch (Exception e) {
            LinkedList compilerArgs = new LinkedList(options.getCompilerArgs());
            return compilerArgs.stream().map(Object::toString).collect(Collectors.toList());
        }
    }

    private String getSourceCompatibility(List<String> compilerArgs) {
        return this.findFirstCompilerArgMatch(compilerArgs, Stream.of("-source", "--source", "--release")).orElse("");
    }

    private String getTargetCompatibility(List<String> compilerArgs) {
        return this.findFirstCompilerArgMatch(compilerArgs, Stream.of("-target", "--target", "--release")).orElse("");
    }

    private Optional<String> findCompilerArg(List<String> compilerArgs, String arg) {
        int idx = compilerArgs.indexOf(arg);
        if (idx >= 0 && idx < compilerArgs.size() - 1) {
            return Optional.of(compilerArgs.get(idx + 1));
        }
        return Optional.empty();
    }

    private Optional<String> findFirstCompilerArgMatch(List<String> compilerArgs, Stream<String> args) {
        return args.map(arg -> this.findCompilerArg(compilerArgs, (String)arg)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private File getClassesDir(AbstractCompile compile) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) >= 0) {
            return ((Directory)compile.getDestinationDirectory().get()).getAsFile();
        }
        return compile.getDestinationDir();
    }
}

