/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;

public class ConstructorLocator
extends PatternLocator {
    protected ConstructorPattern pattern;

    public ConstructorLocator(ConstructorPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    protected int fineGrain() {
        return this.pattern.fineGrain;
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.ASTNode node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(node instanceof ExplicitConstructorCall)) {
            return 0;
        }
        if (!this.matchParametersCount(node, ((ExplicitConstructorCall)node).arguments)) {
            return 0;
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(ConstructorDeclaration node, MatchingNodeSet nodeSet) {
        if (this.pattern.fineGrain != 0 && !this.pattern.findDeclarations) {
            return 0;
        }
        int referencesLevel = this.pattern.findReferences ? this.matchLevelForReferences(node) : 0;
        int declarationsLevel = this.pattern.findDeclarations ? this.matchLevelForDeclarations(node) : 0;
        return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    @Override
    public int match(MethodDeclaration node, MatchingNodeSet nodeSet, MatchLocator locator) {
        if (!node.isConstructor()) {
            return 0;
        }
        if (this.pattern.fineGrain != 0 && !this.pattern.findDeclarations) {
            return 0;
        }
        int referencesLevel = 0;
        int declarationsLevel = this.pattern.findDeclarations ? this.matchLevelForDeclarations(node) : 0;
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.Expression node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(node instanceof AllocationExpression)) {
            return 0;
        }
        AllocationExpression allocation = (AllocationExpression)node;
        char[][] typeName = allocation.type.getTypeName();
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, typeName[typeName.length - 1])) {
            return 0;
        }
        if (!this.matchParametersCount((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, allocation.arguments)) {
            return 0;
        }
        return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(Expression node, MatchingNodeSet nodeSet, MatchLocator locator) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (node instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)node;
            if (this.pattern.declaringSimpleName == null || this.matchesTypeReference(this.pattern.declaringSimpleName, creationRef.getType())) {
                return this.pattern.mustResolve ? 2 : 1;
            }
        }
        if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation newInstance = (ClassInstanceCreation)node;
            return (this.pattern.declaringSimpleName == null || this.matchesTypeReference(this.pattern.declaringSimpleName, newInstance.getType())) && this.matchParametersCount(node, newInstance.arguments()) ? 2 : 0;
        }
        return 0;
    }

    @Override
    public int match(ASTNode node, MatchingNodeSet nodeSet, MatchLocator locator) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (node instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superRef = (SuperConstructorInvocation)node;
            if (!this.matchParametersCount(node, superRef.arguments())) {
                return 0;
            }
            if (this.pattern.declaringSimpleName != null) {
                Type superType = null;
                ASTNode current = superRef.getParent();
                while (current != null && !(current instanceof AbstractTypeDeclaration) && !(current instanceof CreationReference)) {
                    current = current.getParent();
                }
                if (current instanceof TypeDeclaration) {
                    TypeDeclaration typeDecl = (TypeDeclaration)current;
                    superType = typeDecl.getSuperclassType();
                }
                if (current instanceof CreationReference) {
                    CreationReference newInstance = (CreationReference)current;
                    superType = newInstance.getType();
                }
                if (!this.matchesTypeReference(this.pattern.declaringSimpleName, superType)) {
                    return 0;
                }
            }
            return this.pattern.mustResolve ? 2 : 1;
        }
        if (node instanceof EnumConstantDeclaration) {
            EnumDeclaration enumDeclaration;
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)node;
            ASTNode aSTNode = node.getParent();
            if (aSTNode instanceof EnumDeclaration && this.matchesName(this.pattern.declaringSimpleName, (enumDeclaration = (EnumDeclaration)aSTNode).getName().getIdentifier().toCharArray()) && this.matchParametersCount(enumConstantDecl, enumConstantDecl.arguments())) {
                return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
            }
        }
        return 0;
    }

    @Override
    public int match(FieldDeclaration field, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (field.type != null || !(field.initialization instanceof AllocationExpression)) {
            return 0;
        }
        AllocationExpression allocation = (AllocationExpression)field.initialization;
        if (field.binding != null && field.binding.declaringClass != null && this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, field.binding.declaringClass.sourceName())) {
            return 0;
        }
        if (!this.matchParametersCount((org.eclipse.jdt.internal.compiler.ast.ASTNode)field, allocation.arguments)) {
            return 0;
        }
        return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)field, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(MessageSend msgSend, MatchingNodeSet nodeSet) {
        if ((msgSend.bits & 0x8000) == 0) {
            return 0;
        }
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (this.pattern.declaringSimpleName == null || CharOperation.equals((char[])msgSend.selector, (char[])this.pattern.declaringSimpleName)) {
            return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)msgSend, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int match(ReferenceExpression node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences || node.isMethodReference()) {
            return 0;
        }
        return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, this.pattern.mustResolve ? 2 : 3);
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (this.pattern.fineGrain != 0 && (this.pattern.fineGrain & 0xEFFFFFFF) == 0) {
            return 0;
        }
        return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, this.pattern.mustResolve ? 2 : 3);
    }

    protected int matchConstructor(MethodBinding constructor) {
        if (!constructor.isConstructor()) {
            return 0;
        }
        int level = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, (TypeBinding)constructor.declaringClass);
        if (level == 0) {
            return 0;
        }
        int parameterCount = this.pattern.parameterCount;
        if (parameterCount > -1) {
            if (constructor.parameters == null) {
                return 1;
            }
            if (parameterCount != constructor.parameters.length) {
                return 0;
            }
            int i = 0;
            while (i < parameterCount) {
                int newLevel = this.resolveLevelForType(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i], constructor.parameters[i]);
                if (level > newLevel) {
                    if (newLevel == 0) {
                        return 0;
                    }
                    level = newLevel;
                }
                ++i;
            }
        }
        return level;
    }

    protected int matchConstructor(IMethodBinding constructor) {
        if (!constructor.isConstructor()) {
            return 0;
        }
        int level = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, constructor.getDeclaringClass());
        if (level == 0) {
            return 0;
        }
        int parameterCount = this.pattern.parameterCount;
        if (parameterCount > -1) {
            if (parameterCount != constructor.getParameterTypes().length) {
                return 0;
            }
            int i = 0;
            while (i < parameterCount) {
                int newLevel = this.resolveLevelForType(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i], constructor.getParameterTypes()[i]);
                if (level > newLevel) {
                    if (newLevel == 0) {
                        return 0;
                    }
                    level = newLevel;
                }
                ++i;
            }
        }
        return level;
    }

    @Override
    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 2;
    }

    protected int matchLevelForReferences(ConstructorDeclaration constructor) {
        ExplicitConstructorCall constructorCall = constructor.constructorCall;
        if (constructorCall == null || constructorCall.accessMode != 1) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            org.eclipse.jdt.internal.compiler.ast.Expression[] args = constructorCall.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return this.pattern.mustResolve ? 2 : 3;
    }

    protected int matchLevelForDeclarations(ConstructorDeclaration constructor) {
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, constructor.selector)) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = constructor.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        if (this.pattern.hasConstructorArguments() && (constructor.typeParameters == null || constructor.typeParameters.length != this.pattern.constructorArguments.length)) {
            return 0;
        }
        return this.pattern.mustResolve ? 2 : 3;
    }

    protected int matchLevelForDeclarations(MethodDeclaration constructor) {
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, constructor.getName().toString().toCharArray())) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            List args = constructor.parameters();
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return 0;
            }
        }
        if (this.pattern.hasConstructorArguments() && (constructor.typeParameters() == null || constructor.typeParameters().size() != this.pattern.constructorArguments.length)) {
            return 0;
        }
        return this.pattern.mustResolve ? 2 : 3;
    }

    boolean matchParametersCount(org.eclipse.jdt.internal.compiler.ast.ASTNode node, org.eclipse.jdt.internal.compiler.ast.Expression[] args) {
        if (!(this.pattern.parameterSimpleNames == null || this.pattern.varargs && (node.bits & 0x8000) == 0)) {
            int argsLength;
            int length = this.pattern.parameterCount;
            if (length < 0) {
                length = this.pattern.parameterSimpleNames.length;
            }
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return false;
            }
        }
        return true;
    }

    boolean matchParametersCount(ASTNode node, List<Expression> args) {
        if (this.pattern.parameterSimpleNames != null && (!this.pattern.varargs || DOMASTNodeUtils.insideDocComment(node))) {
            int argsLength;
            int length = this.pattern.parameterCount;
            if (length < 0) {
                length = this.pattern.parameterSimpleNames.length;
            }
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void matchReportReference(org.eclipse.jdt.internal.compiler.ast.ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        boolean report;
        MethodBinding constructorBinding = null;
        boolean isSynthetic = false;
        if (reference instanceof ExplicitConstructorCall) {
            ExplicitConstructorCall call = (ExplicitConstructorCall)reference;
            isSynthetic = call.isImplicitSuper();
            constructorBinding = call.binding;
        } else if (reference instanceof AllocationExpression) {
            AllocationExpression alloc = (AllocationExpression)reference;
            constructorBinding = alloc.binding;
        } else if (reference instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration || reference instanceof FieldDeclaration) {
            super.matchReportReference(reference, element, elementBinding, accuracy, locator);
            if (this.match != null) {
                return;
            }
        }
        this.match = locator.newMethodReferenceMatch(element, elementBinding, accuracy, -1, -1, true, isSynthetic, reference);
        if (constructorBinding instanceof ParameterizedGenericMethodBinding) {
            ParameterizedGenericMethodBinding parameterizedMethodBinding = (ParameterizedGenericMethodBinding)constructorBinding;
            this.match.setRaw(parameterizedMethodBinding.isRaw);
            TypeBinding[] typeBindings = parameterizedMethodBinding.isRaw ? null : parameterizedMethodBinding.typeArguments;
            this.updateMatch(typeBindings, locator, this.pattern.constructorArguments, this.pattern.hasConstructorParameters());
            if (constructorBinding.declaringClass.isParameterizedType() || constructorBinding.declaringClass.isRawType()) {
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)constructorBinding.declaringClass;
                if (!(!this.pattern.hasTypeArguments() && this.pattern.hasConstructorArguments() || parameterizedBinding.isParameterizedWithOwnVariables())) {
                    if (this.pattern.hasTypeArguments() && !this.pattern.hasConstructorArguments()) {
                        this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                    } else {
                        this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                    }
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
        } else if (constructorBinding instanceof ParameterizedMethodBinding) {
            if (constructorBinding.declaringClass.isParameterizedType() || constructorBinding.declaringClass.isRawType()) {
                ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)constructorBinding.declaringClass;
                if (!this.pattern.hasTypeArguments() && this.pattern.hasConstructorArguments()) {
                    this.updateMatch(parameterizedBinding, new char[][][]{this.pattern.constructorArguments}, this.pattern.hasTypeParameters(), 0, locator);
                } else if (!parameterizedBinding.isParameterizedWithOwnVariables()) {
                    this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
        } else if (this.pattern.hasConstructorArguments()) {
            this.match.setRule(16);
        }
        if (this.match.getRule() == 0) {
            return;
        }
        boolean bl = report = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
        if (!report) {
            return;
        }
        int offset = reference.sourceStart;
        this.match.setOffset(offset);
        this.match.setLength(reference.sourceEnd - offset + 1);
        if (reference instanceof FieldDeclaration) {
            FieldDeclaration enumConstant = (FieldDeclaration)reference;
            if (enumConstant.initialization instanceof QualifiedAllocationExpression) {
                locator.reportAccurateEnumConstructorReference(this.match, enumConstant, (AllocationExpression)((QualifiedAllocationExpression)enumConstant.initialization));
                return;
            }
        }
        locator.report(this.match);
    }

    @Override
    public SearchMatch newDeclarationMatch(org.eclipse.jdt.internal.compiler.ast.ASTNode reference, IJavaElement element, Binding binding, int accuracy, int length, MatchLocator locator) {
        this.match = null;
        int offset = reference.sourceStart;
        if (this.pattern.findReferences) {
            if (reference instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) {
                org.eclipse.jdt.internal.compiler.ast.TypeDeclaration type = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)reference;
                AbstractMethodDeclaration[] methods = type.methods;
                if (methods != null) {
                    AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractMethodDeclaration method = abstractMethodDeclarationArray[n2];
                        boolean synthetic = method.isDefaultConstructor() && method.sourceStart < type.bodyStart;
                        this.match = locator.newMethodReferenceMatch(element, binding, accuracy, offset, length, method.isConstructor(), synthetic, (org.eclipse.jdt.internal.compiler.ast.ASTNode)method);
                        ++n2;
                    }
                }
            } else if (reference instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructor = (ConstructorDeclaration)reference;
                ExplicitConstructorCall call = constructor.constructorCall;
                boolean synthetic = call != null && call.isImplicitSuper();
                this.match = locator.newMethodReferenceMatch(element, binding, accuracy, offset, length, constructor.isConstructor(), synthetic, (org.eclipse.jdt.internal.compiler.ast.ASTNode)constructor);
            }
        }
        if (this.match != null) {
            return this.match;
        }
        return locator.newDeclarationMatch(element, binding, accuracy, reference.sourceStart, length);
    }

    @Override
    public int resolveLevel(org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        if (this.pattern.findReferences) {
            if (node instanceof AllocationExpression) {
                return this.resolveLevel((AllocationExpression)node);
            }
            if (node instanceof ExplicitConstructorCall) {
                return this.resolveLevel((Binding)((ExplicitConstructorCall)node).binding);
            }
            if (node instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) {
                return this.resolveLevel((org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)node);
            }
            if (node instanceof FieldDeclaration) {
                return this.resolveLevel((FieldDeclaration)node);
            }
            if (node instanceof JavadocMessageSend) {
                return this.resolveLevel((Binding)((JavadocMessageSend)node).binding);
            }
            if (node instanceof ReferenceExpression) {
                return this.resolveLevel((Binding)((ReferenceExpression)node).getMethodBinding());
            }
        }
        if (node instanceof ConstructorDeclaration) {
            return this.resolveLevel((ConstructorDeclaration)node, true);
        }
        return 0;
    }

    @Override
    protected int referenceType() {
        return 9;
    }

    protected int resolveLevel(AllocationExpression allocation) {
        char[][] typeName = allocation.type.getTypeName();
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, typeName[typeName.length - 1])) {
            return 0;
        }
        return this.resolveLevel((Binding)allocation.binding);
    }

    protected int resolveLevel(FieldDeclaration field) {
        if (field.type != null || field.binding == null) {
            return 0;
        }
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, field.binding.type.sourceName())) {
            return 0;
        }
        if (!(field.initialization instanceof AllocationExpression) || field.initialization.resolvedType.isLocalType()) {
            return 0;
        }
        return this.resolveLevel((Binding)((AllocationExpression)field.initialization).binding);
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding constructor = (MethodBinding)binding;
        int level = this.matchConstructor(constructor);
        if (level == 0 && constructor != constructor.original()) {
            level = this.matchConstructor(constructor.original());
        }
        return level;
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding instanceof IMethodBinding) {
            IMethodBinding constructor = (IMethodBinding)binding;
            int level = this.matchConstructor(constructor);
            if (level == 0 && constructor != constructor.getMethodDeclaration()) {
                level = this.matchConstructor(constructor.getMethodDeclaration());
            }
            return level;
        }
        return 0;
    }

    protected int resolveLevel(ConstructorDeclaration constructor, boolean checkDeclarations) {
        ExplicitConstructorCall constructorCall;
        int referencesLevel = 0;
        if (this.pattern.findReferences && (constructorCall = constructor.constructorCall) != null && constructorCall.accessMode == 1) {
            int patternCount;
            int callCount = constructorCall.arguments == null ? 0 : constructorCall.arguments.length;
            int n = patternCount = this.pattern.parameterSimpleNames == null ? 0 : this.pattern.parameterSimpleNames.length;
            if (patternCount != callCount) {
                referencesLevel = 0;
            } else {
                referencesLevel = this.resolveLevel((Binding)constructorCall.binding);
                if (referencesLevel == 3) {
                    return 3;
                }
            }
        }
        if (!checkDeclarations) {
            return referencesLevel;
        }
        int declarationsLevel = this.pattern.findDeclarations ? this.resolveLevel((Binding)constructor.binding) : 0;
        return referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel;
    }

    protected int resolveLevel(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration type) {
        AbstractMethodDeclaration[] methods = type.methods;
        if (methods != null) {
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractMethodDeclaration method = abstractMethodDeclarationArray[n2];
                if (method.isDefaultConstructor() && method.sourceStart < type.bodyStart) {
                    return this.resolveLevel((ConstructorDeclaration)method, false);
                }
                ++n2;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

