/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;

public class TypeNameMatchCollector
extends TypeNameMatchRequestor {
    private final Collection<TypeNameMatch> fCollection;
    private Pattern[] fStringMatchers;

    public TypeNameMatchCollector(Collection<TypeNameMatch> collection) {
        Assert.isNotNull(collection);
        this.fCollection = collection;
    }

    private boolean inScope(TypeNameMatch match) {
        return !this.isFiltered(match);
    }

    private boolean isFiltered(TypeNameMatch match) {
        boolean filteredByPattern = this.filter(match.getFullyQualifiedName());
        if (filteredByPattern) {
            return true;
        }
        int accessibility = match.getAccessibility();
        switch (accessibility) {
            case 1: {
                return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck"));
            }
            case 2: {
                return "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck"));
            }
        }
        return false;
    }

    private boolean filter(String fullTypeName) {
        Pattern[] patternArray = this.getStringMatchers();
        int n = patternArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern curr = patternArray[n2];
            if (curr.matcher(fullTypeName).matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private synchronized Pattern[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String str = TypeNameMatchCollector.getPreference("org.eclipse.jdt.ui.typefilter.enabled");
            StringTokenizer tok = new StringTokenizer(str, ";");
            int nTokens = tok.countTokens();
            this.fStringMatchers = new Pattern[nTokens];
            int i = 0;
            while (i < nTokens) {
                String curr = tok.nextToken();
                if (curr.length() > 0) {
                    curr = curr.replace(".", "\\.");
                    curr = curr.replace("*", ".*");
                    curr = curr.replace("?", ".");
                    this.fStringMatchers[i] = Pattern.compile(curr);
                }
                ++i;
            }
        }
        return this.fStringMatchers;
    }

    public void acceptTypeNameMatch(TypeNameMatch match) {
        if (this.inScope(match)) {
            this.fCollection.add(match);
        }
    }

    private static String getPreference(String key) {
        String val;
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
        if (node != null && (val = node.get(key, null)) != null) {
            return val;
        }
        node = DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
        if (node != null) {
            return node.get(key, null);
        }
        return null;
    }
}

