/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer.jpms;

import com.microsoft.gradle.bs.importer.jpms.JpmsArgValue;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum JpmsArgType {
    ADD_EXPORTS("--add-exports", "add-exports", Pattern.compile("^(([A-Za-z0-9\\.$_]*)/[A-Za-z0-9\\.$_]*=[A-Za-z0-9\\.$_-]*)$")),
    ADD_OPENS("--add-opens", "add-opens", Pattern.compile("^(([A-Za-z0-9\\.$_]*)/[A-Za-z0-9\\.$_]*=[A-Za-z0-9\\.$_-]*)$")),
    ADD_READS("--add-reads", "add-reads", Pattern.compile("^(([A-Za-z0-9\\.$_]*)=[A-Za-z0-9\\.$_-]*)$")),
    PATCH_MODULE("--patch-module", "patch-module", Pattern.compile("^(([A-Za-z0-9\\.$_]*)=.*)$"));

    private String javacArgumentName;
    private String eclipseArgumentName;
    private Pattern extractPattern;

    private JpmsArgType(String javacArgumentName, String eclipseArgumentName, Pattern extractPattern) {
        this.javacArgumentName = javacArgumentName;
        this.eclipseArgumentName = eclipseArgumentName;
        this.extractPattern = extractPattern;
    }

    public static JpmsArgType fromJavacArgumentName(String arg) {
        return Arrays.stream(JpmsArgType.values()).filter(type -> type.javacArgumentName.equals(arg)).findFirst().orElse(null);
    }

    public String getEclipseArgumentName() {
        return this.eclipseArgumentName;
    }

    public JpmsArgValue parse(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String trimmed = value.trim();
        Matcher matcher = this.extractPattern.matcher(trimmed);
        if (matcher.matches()) {
            String argValue = matcher.group(1);
            String module = matcher.group(2);
            return new JpmsArgValue(module, argValue);
        }
        return null;
    }
}

