/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.service.prefs.BackingStoreException;

public class ProcessorConfig {
    private static final String APT_PLUGIN_ID = "org.eclipse.jdt.apt.core";
    private static final String APT_STRING_BASE = "org.eclipse.jdt.apt";
    private static final String APT_PROCESSOROPTIONS = "org.eclipse.jdt.apt.processorOptions";
    private static final String APT_NULLVALUE = "org.eclipse.jdt.apt.NULLVALUE";
    private static final String APT_ENABLED = "org.eclipse.jdt.apt.aptEnabled";
    private static final String APT_PROCESSANNOTATIONS = "org.eclipse.jdt.core.compiler.processAnnotations";
    private static final String PATHVAR_TOKEN = "^%[^%/\\\\ ]+%.*";
    private static final String PATHVAR_ROOT = "%ROOT%";
    private static final String PATHVAR_PROJECTROOT = "%PROJECT.DIR%";

    public static Map<String, String> getProcessorOptions(IJavaProject jproj) {
        Map<String, String> rawOptions = ProcessorConfig.getRawProcessorOptions(jproj);
        HashMap<String, String> options = new HashMap<String, String>(rawOptions.size());
        for (Map.Entry<String, String> entry : rawOptions.entrySet()) {
            String resolvedValue = ProcessorConfig.resolveVarPath(jproj, entry.getValue());
            String value = resolvedValue == null ? entry.getValue() : resolvedValue;
            options.put(entry.getKey(), value);
        }
        return options;
    }

    public static boolean isAnnotationProcessingEnabled(IJavaProject jproj) {
        IScopeContext[] contexts = jproj != null && jproj.getProject() != null ? new IScopeContext[]{new ProjectScope(jproj.getProject()), InstanceScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE};
        for (IScopeContext context : contexts) {
            IEclipsePreferences prefs = context.getNode("org.eclipse.jdt.core");
            if ("enabled".equals(prefs.get(APT_PROCESSANNOTATIONS, "disabled"))) {
                return true;
            }
            prefs = context.getNode(APT_PLUGIN_ID);
            if (!prefs.getBoolean(APT_ENABLED, false)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> getRawProcessorOptions(IJavaProject jproj) {
        HashMap<String, String> options = new HashMap<String, String>();
        IScopeContext[] contexts = jproj != null && jproj.getProject() != null ? new IScopeContext[]{new ProjectScope(jproj.getProject()), InstanceScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE};
        for (IScopeContext context : contexts) {
            IEclipsePreferences prefs = context.getNode(APT_PLUGIN_ID);
            try {
                IEclipsePreferences procOptionsNode;
                if (prefs.childrenNames().length <= 0 || (procOptionsNode = context.getNode("org.eclipse.jdt.apt.core/org.eclipse.jdt.apt.processorOptions")) == null) continue;
                for (String key : procOptionsNode.keys()) {
                    String nonNullVal = procOptionsNode.get(key, null);
                    String val = APT_NULLVALUE.equals(nonNullVal) ? null : nonNullVal;
                    options.put(key, val);
                }
                break;
            }
            catch (BackingStoreException e) {
                ILog.get().error("Unable to load annotation processor options", (Throwable)e);
            }
        }
        return options;
    }

    private static String resolveVarPath(IJavaProject jproj, String value) {
        if (value == null) {
            return null;
        }
        if (!Pattern.matches(PATHVAR_TOKEN, value)) {
            return value;
        }
        Path path = new Path(value);
        String firstToken = path.segment(0);
        if (PATHVAR_ROOT.equals(firstToken)) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource proj = root.findMember(path.segment(1));
            if (proj == null) {
                return value;
            }
            IPath relativePath = path.removeFirstSegments(2);
            IPath absoluteProjPath = proj.getLocation();
            IPath absoluteResPath = absoluteProjPath.append(relativePath);
            return absoluteResPath.toOSString();
        }
        if (jproj != null && PATHVAR_PROJECTROOT.equals(firstToken)) {
            IPath relativePath = path.removeFirstSegments(1);
            IPath absoluteProjPath = jproj.getProject().getLocation();
            IPath absoluteResPath = absoluteProjPath.append(relativePath);
            return absoluteResPath.toOSString();
        }
        String cpvName = firstToken.substring(1, firstToken.length() - 1);
        IPath cpvPath = JavaCore.getClasspathVariable((String)cpvName);
        if (cpvPath != null) {
            IPath resolved = cpvPath.append(path.removeFirstSegments(1));
            return resolved.toOSString();
        }
        return value;
    }
}

