/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.WorkspaceBuildTargetsResult;
import com.microsoft.gradle.bs.importer.BuildServerConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.handlers.MapFlattener;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.ExecuteCommandParams;

public class Utils {
    private static final String JAVA_BUILD_SERVER_GRADLE_ENABLED = "java.gradle.buildServer.enabled";

    private Utils() {
    }

    public static boolean isGradleBuildServerProject(IProject project) {
        return ProjectUtils.hasNature((IProject)project, (String)"com.microsoft.gradle.bs.importer.GradleBuildServerProjectNature");
    }

    public static Map<URI, List<BuildTarget>> getBuildTargetsMappedByProjectPath(BuildServerConnection serverConnection) {
        WorkspaceBuildTargetsResult workspaceBuildTargetsResult = (WorkspaceBuildTargetsResult)serverConnection.workspaceBuildTargets().join();
        List buildTargets = workspaceBuildTargetsResult.getTargets();
        return buildTargets.stream().collect(Collectors.groupingBy(target -> Utils.getUriWithoutQuery(target.getId().getUri())));
    }

    public static URI getUriWithoutQuery(String uriString) {
        try {
            URI uri = new URI(uriString);
            return new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null, uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri: " + uriString, e);
        }
    }

    public static List<BuildTarget> getBuildTargetsByProjectUri(BuildServerConnection serverConnection, URI projectUri) {
        if (projectUri == null) {
            throw new IllegalArgumentException("projectPath cannot be null.");
        }
        WorkspaceBuildTargetsResult workspaceBuildTargetsResult = (WorkspaceBuildTargetsResult)serverConnection.workspaceBuildTargets().join();
        List buildTargets = workspaceBuildTargetsResult.getTargets();
        return buildTargets.stream().filter(target -> URIUtil.sameURI((URI)projectUri, (URI)Utils.getUriWithoutQuery(target.getId().getUri()))).collect(Collectors.toList());
    }

    public static String getQueryValueByKey(String uriString, String key) {
        URI uri;
        block5: {
            uri = new URI(uriString);
            if (uri.getQuery() != null) break block5;
            return "";
        }
        try {
            String[] pairs;
            String query = uri.getQuery();
            String[] stringArray = pairs = query.split("&");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                int idx = pair.indexOf("=");
                if (idx > 0 && key.equals(pair.substring(0, idx))) {
                    return pair.substring(idx + 1);
                }
                ++n2;
            }
            return "";
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri: " + uriString, e);
        }
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IProjectDescription description = project.getDescription();
        List<String> currentNatureIds = Arrays.asList(description.getNatureIds());
        if (currentNatureIds.contains(natureId)) {
            return;
        }
        LinkedList<String> newIds = new LinkedList<String>();
        newIds.addAll(currentNatureIds);
        newIds.add(0, natureId);
        description.setNatureIds(newIds.toArray(new String[newIds.size()]));
        project.setDescription(description, 64, (IProgressMonitor)progress.newChild(1));
    }

    public static void addBuildSpec(IProjectDescription description, String[] buildNames) {
        ICommand[] commands = (ICommand[])Arrays.stream(buildNames).map(buildName -> {
            ICommand buildSpec = description.newCommand();
            buildSpec.setBuilderName(buildName);
            return buildSpec;
        }).toArray(ICommand[]::new);
        Utils.addBuildSpec(description, commands);
    }

    public static void addBuildSpec(IProjectDescription description, ICommand[] buildSpecs) {
        List<ICommand> currentBuildSpecs = Arrays.asList(description.getBuildSpec());
        LinkedList<ICommand> newSpecs = new LinkedList<ICommand>();
        newSpecs.addAll(currentBuildSpecs);
        ICommand[] iCommandArray = buildSpecs;
        int n = buildSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand buildSpec = iCommandArray[n2];
            if (!currentBuildSpecs.stream().anyMatch(spec -> Objects.equals(spec.getBuilderName(), buildSpec.getBuilderName()))) {
                newSpecs.add(0, buildSpec);
            }
            ++n2;
        }
        description.setBuildSpec(newSpecs.toArray(new ICommand[newSpecs.size()]));
    }

    public static void removeBuildshipConfigurations(IProjectDescription description) {
        ICommand[] commands = description.getBuildSpec();
        LinkedList<ICommand> newSpecs = new LinkedList<ICommand>();
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!Utils.isExcludedBuilder(command.getBuilderName())) {
                newSpecs.add(command);
            }
            ++n2;
        }
        description.setBuildSpec(newSpecs.toArray(new ICommand[newSpecs.size()]));
        String[] natureIds = description.getNatureIds();
        LinkedList<String> newNatureIds = new LinkedList<String>();
        String[] stringArray = natureIds;
        int n3 = natureIds.length;
        int n4 = 0;
        while (n4 < n3) {
            String natureId = stringArray[n4];
            if (!Objects.equals(natureId, "org.eclipse.buildship.core.gradleprojectnature")) {
                newNatureIds.add(natureId);
            }
            ++n4;
        }
        description.setNatureIds(newNatureIds.toArray(new String[newNatureIds.size()]));
    }

    private static boolean isExcludedBuilder(String builderName) {
        return Objects.equals(builderName, "org.eclipse.jdt.core.javabuilder") || Objects.equals(builderName, "org.eclipse.buildship.core.gradleprojectbuilder");
    }

    public static ICommand getBuildServerBuildSpec(IProjectDescription description) {
        ICommand buildSpec = description.newCommand();
        buildSpec.setBuilderName("com.microsoft.gradle.bs.importer.builder.BuildServerBuilder");
        buildSpec.setBuilding(9, false);
        buildSpec.setBuilding(15, false);
        return buildSpec;
    }

    public static boolean isBuildServerEnabled(Preferences preferences) {
        if (preferences == null) {
            return false;
        }
        if (!preferences.isImportGradleEnabled()) {
            return false;
        }
        String bspImporterEnabled = MapFlattener.getString((Map)preferences.asMap(), (String)JAVA_BUILD_SERVER_GRADLE_ENABLED);
        return "on".equalsIgnoreCase(bspImporterEnabled);
    }

    public static void sendTelemetry(JavaClientConnection.JavaLanguageClient client, Object message) {
        client.sendNotification(new ExecuteCommandParams("_java.gradle.buildServer.sendTelemetry", Arrays.asList(message)));
    }
}

