/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMLocalVariableLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldLocator;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;

public class DOMFieldLocator
extends DOMPatternLocator {
    private FieldLocator fieldLocator;

    public DOMFieldLocator(FieldLocator locator) {
        super((SearchPattern)locator.pattern);
        this.fieldLocator = locator;
    }

    @Override
    public LocatorResponse match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        VariablePattern variablePattern;
        ImportDeclaration importRef;
        int declarationsLevel = 0;
        if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstant = (EnumConstantDeclaration)node;
            return this.match(enumConstant, nodeSet);
        }
        if (this.fieldLocator.pattern.findReferences && node instanceof ImportDeclaration && (importRef = (ImportDeclaration)node).isStatic() && !importRef.isOnDemand() && this.fieldLocator.matchesName(this.fieldLocator.pattern.name, importRef.getName().toString().toCharArray()) && (variablePattern = this.fieldLocator.pattern) instanceof FieldPattern) {
            FieldPattern fieldPattern = (FieldPattern)variablePattern;
            char[] declaringType = CharOperation.concat((char[])fieldPattern.declaringQualification, (char[])fieldPattern.declaringSimpleName, (char)'.');
            if (this.fieldLocator.matchesName(declaringType, importRef.getName().toString().toCharArray())) {
                declarationsLevel = this.fieldLocator.pattern.mustResolve ? 2 : 3;
            }
        }
        int level = nodeSet.addMatch(node, declarationsLevel);
        return DOMFieldLocator.toResponse(level, true);
    }

    @Override
    public LocatorResponse match(Name name, NodeSetWrapper nodeSet, MatchLocator locator) {
        VariablePattern variablePattern;
        if (name.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY || name.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            return DOMFieldLocator.toResponse(0);
        }
        if (name.getLocationInParent() == MethodInvocation.NAME_PROPERTY) {
            return DOMFieldLocator.toResponse(0);
        }
        if (!this.fieldLocator.matchesName(this.fieldLocator.pattern.name, name.toString().toCharArray())) {
            return DOMFieldLocator.toResponse(0);
        }
        if (this.fieldLocator.isDeclarationOfAccessedFieldsPattern && (variablePattern = this.fieldLocator.pattern) instanceof DeclarationOfAccessedFieldsPattern) {
            DeclarationOfAccessedFieldsPattern doafp = (DeclarationOfAccessedFieldsPattern)variablePattern;
            if (doafp.enclosingElement != null) {
                IJavaElement je;
                if (!DOMASTNodeUtils.isWithinRange((ASTNode)name, doafp.enclosingElement)) {
                    return DOMFieldLocator.toResponse(0);
                }
                IBinding b = name.resolveBinding();
                IJavaElement iJavaElement = je = b == null ? null : b.getJavaElement();
                if (je != null && doafp.knownFields.includes((Object)je)) {
                    doafp.knownFields.remove((Object)je);
                    ISourceReference sr = je instanceof ISourceReference ? (ISourceReference)je : null;
                    IResource r = null;
                    ISourceRange srg = null;
                    String elName = je.getElementName();
                    try {
                        srg = sr.getSourceRange();
                        IJavaElement ancestor = je.getAncestor(5);
                        r = ancestor == null ? null : ancestor.getCorrespondingResource();
                    }
                    catch (JavaModelException ancestor) {
                        // empty catch block
                    }
                    if (srg != null) {
                        int accuracy = this.fieldLocator.pattern.mustResolve ? 2 : 3;
                        FieldDeclarationMatch fdMatch = new FieldDeclarationMatch(je, accuracy, srg.getOffset() + srg.getLength() - elName.length() - 1, elName.length(), locator.getParticipant(), r);
                        try {
                            locator.report((SearchMatch)fdMatch);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
                return DOMFieldLocator.toResponse(0);
            }
        }
        if (this.fieldLocator.pattern.fineGrain != 0 ? this.matchesFineGrain(name) : this.fieldLocator.pattern.readAccess && DOMLocalVariableLocator.isRead(name) || this.fieldLocator.pattern.writeAccess && DOMLocalVariableLocator.isWrite(name)) {
            int level = nodeSet.addMatch((ASTNode)name, this.fieldLocator.pattern.mustResolve ? 2 : 3);
            return DOMFieldLocator.toResponse(level, true);
        }
        return DOMFieldLocator.toResponse(0);
    }

    private boolean matchesFineGrain(Name name) {
        int fineGrain = this.fieldLocator.pattern.fineGrain;
        if (fineGrain == 0) {
            return true;
        }
        if ((fineGrain & 0x1000000) != 0 && name.getLocationInParent() == SuperFieldAccess.NAME_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x2000000) != 0 && name.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            return true;
        }
        if (name.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
            Expression expr = ((FieldAccess)name.getParent()).getExpression();
            if ((fineGrain & 0x4000000) != 0 && expr instanceof ThisExpression) {
                return true;
            }
            if ((fineGrain & 0x2000000) != 0 && expr != null && !(expr instanceof ThisExpression)) {
                return true;
            }
        }
        return (fineGrain & 0x8000000) != 0 && !Set.of(SuperFieldAccess.NAME_PROPERTY, FieldAccess.NAME_PROPERTY, QualifiedName.NAME_PROPERTY).contains(name.getLocationInParent());
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return DOMFieldLocator.toResponse(3);
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            if (variableBinding.isRecordComponent()) {
                if (!this.fieldLocator.matchesName(this.fieldLocator.pattern.name, variableBinding.getName().toCharArray())) {
                    return DOMFieldLocator.toResponse(0);
                }
                FieldPattern fieldPattern = (FieldPattern)this.fieldLocator.pattern;
                IMethodBinding declaring = variableBinding == null ? null : variableBinding.getDeclaringMethod();
                ITypeBinding tb = declaring == null ? null : declaring.getDeclaringClass();
                int level = this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, tb);
                return DOMFieldLocator.toResponse(level);
            }
            if (variableBinding.isField()) {
                return DOMFieldLocator.toResponse(this.matchField(variableBinding, true));
            }
        }
        return DOMFieldLocator.toResponse(0);
    }

    @Override
    public LocatorResponse match(VariableDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        VariablePattern variablePattern;
        if (!this.fieldLocator.pattern.findDeclarations && !this.fieldLocator.isDeclarationOfAccessedFieldsPattern) {
            return DOMFieldLocator.toResponse(0);
        }
        if (node.getLocationInParent() != FieldDeclaration.FRAGMENTS_PROPERTY) {
            return DOMFieldLocator.toResponse(0);
        }
        int referencesLevel = 0;
        if (this.fieldLocator.pattern.findReferences && this.fieldLocator.pattern.writeAccess && !this.fieldLocator.pattern.readAccess && node.getInitializer() != null && this.fieldLocator.matchesName(this.fieldLocator.pattern.name, node.getName().getIdentifier().toCharArray())) {
            referencesLevel = this.fieldLocator.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if ((this.fieldLocator.pattern.findDeclarations || this.fieldLocator.isDeclarationOfAccessedFieldsPattern) && this.fieldLocator.matchesName(this.fieldLocator.pattern.name, node.getName().getIdentifier().toCharArray()) && (variablePattern = this.fieldLocator.pattern) instanceof FieldPattern) {
            FieldPattern fieldPattern = (FieldPattern)variablePattern;
            if (this.matchesTypeReference(fieldPattern.typeSimpleName, ((FieldDeclaration)node.getParent()).getType())) {
                declarationsLevel = this.fieldLocator.pattern.mustResolve ? 2 : 3;
            }
        }
        int level = nodeSet.addMatch((ASTNode)node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
        return DOMFieldLocator.toResponse(level, true);
    }

    private LocatorResponse match(EnumConstantDeclaration node, NodeSetWrapper nodeSet) {
        VariablePattern variablePattern;
        int referencesLevel = 0;
        if (this.fieldLocator.pattern.findReferences && this.fieldLocator.pattern.writeAccess && !this.fieldLocator.pattern.readAccess && this.fieldLocator.matchesName(this.fieldLocator.pattern.name, node.getName().getIdentifier().toCharArray())) {
            referencesLevel = this.fieldLocator.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.fieldLocator.pattern.findDeclarations && this.fieldLocator.matchesName(this.fieldLocator.pattern.name, node.getName().getIdentifier().toCharArray()) && (variablePattern = this.fieldLocator.pattern) instanceof FieldPattern) {
            FieldPattern fieldPattern = (FieldPattern)variablePattern;
            if (this.fieldLocator.matchesName(fieldPattern.typeSimpleName, ((EnumDeclaration)node.getParent()).getName().getIdentifier().toCharArray())) {
                declarationsLevel = this.fieldLocator.pattern.mustResolve ? 2 : 3;
            }
        }
        int level = nodeSet.addMatch((ASTNode)node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
        return DOMFieldLocator.toResponse(level, true);
    }

    protected int matchField(IVariableBinding field, boolean matchName) {
        VariablePattern variablePattern;
        int ret;
        if (field == null) {
            return 1;
        }
        if (!field.isField()) {
            return 0;
        }
        if (matchName && !this.fieldLocator.matchesName(this.fieldLocator.pattern.name, field.getName().toCharArray())) {
            return 0;
        }
        FieldPattern fieldPattern = (FieldPattern)this.fieldLocator.pattern;
        ITypeBinding receiverBinding = field.getDeclaringClass();
        if (receiverBinding == null) {
            if (field == ArrayBinding.ArrayLength) {
                return fieldPattern.declaringQualification == null && fieldPattern.declaringSimpleName == null ? 3 : 0;
            }
            int mode = fieldPattern.getMatchMode();
            if (mode == 0) {
                return 0;
            }
            return 1;
        }
        int declaringLevel = this.resolveLevelForType(fieldPattern.declaringSimpleName, fieldPattern.declaringQualification, receiverBinding);
        if (declaringLevel == 0) {
            return 0;
        }
        if (fieldPattern.declaringSimpleName == null) {
            VariablePattern variablePattern2;
            if (this.fieldLocator.isDeclarationOfAccessedFieldsPattern && (variablePattern2 = this.fieldLocator.pattern) instanceof DeclarationOfAccessedFieldsPattern) {
                DeclarationOfAccessedFieldsPattern doafp = (DeclarationOfAccessedFieldsPattern)variablePattern2;
                IJavaElement je = field.getJavaElement();
                if (je != null) {
                    doafp.knownFields.add((Object)je);
                }
            } else {
                return declaringLevel;
            }
            return 0;
        }
        int typeLevel = this.resolveLevelForType(field.getType());
        int n = ret = declaringLevel > typeLevel ? typeLevel : declaringLevel;
        if (this.fieldLocator.isDeclarationOfAccessedFieldsPattern && (variablePattern = this.fieldLocator.pattern) instanceof DeclarationOfAccessedFieldsPattern) {
            DeclarationOfAccessedFieldsPattern doafp = (DeclarationOfAccessedFieldsPattern)variablePattern;
            IJavaElement je = field.getJavaElement();
            if (je != null) {
                doafp.knownFields.add((Object)je);
            }
        } else {
            return ret;
        }
        return 0;
    }

    protected int resolveLevelForType(ITypeBinding typeBinding) {
        FieldPattern fieldPattern = (FieldPattern)this.fieldLocator.pattern;
        ITypeBinding fieldTypeBinding = typeBinding;
        if (fieldTypeBinding != null && fieldTypeBinding.isParameterizedType()) {
            fieldTypeBinding = typeBinding.getErasure();
        }
        int fieldNameMatch = this.resolveLevelForType(fieldPattern.typeSimpleName, fieldPattern.typeQualification, fieldTypeBinding);
        return fieldNameMatch;
    }
}

