/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMMatchLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class DOMTypeDeclarationLocator
extends DOMPatternLocator {
    private TypeDeclarationLocator locator;

    public DOMTypeDeclarationLocator(TypeDeclarationLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    @Override
    public LocatorResponse match(AbstractTypeDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!DOMTypeDeclarationLocator.matchSearchForTypeSuffix(node, this.locator.pattern.typeSuffix)) {
            return DOMTypeDeclarationLocator.toResponse(0);
        }
        if (this.locator.pattern.simpleName == null || this.locator.matchesName(this.locator.pattern.simpleName, node.getName().getIdentifier().toCharArray())) {
            int level = nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
            return DOMTypeDeclarationLocator.toResponse(level, true);
        }
        return DOMTypeDeclarationLocator.toResponse(0);
    }

    @Override
    public LocatorResponse match(LambdaExpression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return DOMTypeDeclarationLocator.toResponse(2);
    }

    static boolean matchSearchForTypeSuffix(AbstractTypeDeclaration type, char typeSuffix) {
        return switch (typeSuffix) {
            case 'C' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && !(decl = (TypeDeclaration)type).isInterface()) {
                    yield true;
                }
                yield false;
            }
            case '\n' -> type instanceof TypeDeclaration;
            case '\t' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && !(decl = (TypeDeclaration)type).isInterface() || type instanceof EnumDeclaration) {
                    yield true;
                }
                yield false;
            }
            case 'I' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && (decl = (TypeDeclaration)type).isInterface()) {
                    yield true;
                }
                yield false;
            }
            case '\u000b' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && !(decl = (TypeDeclaration)type).isInterface() || type instanceof AnnotationTypeDeclaration) {
                    yield true;
                }
                yield false;
            }
            case 'E' -> type instanceof EnumDeclaration;
            case 'A' -> type instanceof AnnotationTypeDeclaration;
            case '\u0000' -> true;
            default -> false;
        };
    }

    static boolean matchSearchForTypeSuffix(ITypeBinding type, char typeSuffix) {
        return switch (typeSuffix) {
            case 'C' -> type.isClass();
            case '\n' -> {
                if (type.isClass() || type.isInterface() && !type.isAnnotation()) {
                    yield true;
                }
                yield false;
            }
            case '\t' -> {
                if (type.isClass() || type.isEnum()) {
                    yield true;
                }
                yield false;
            }
            case 'I' -> {
                if (type.isInterface() && !type.isAnnotation()) {
                    yield true;
                }
                yield false;
            }
            case '\u000b' -> {
                if (type.isInterface() || type.isAnnotation()) {
                    yield true;
                }
                yield false;
            }
            case 'E' -> type.isEnum();
            case 'A' -> type.isAnnotation();
            case '\u0000' -> true;
            default -> false;
        };
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return DOMTypeDeclarationLocator.toResponse(1);
        }
        if (!(binding instanceof ITypeBinding)) {
            return DOMTypeDeclarationLocator.toResponse(0);
        }
        ITypeBinding type = (ITypeBinding)binding;
        if (!DOMTypeDeclarationLocator.matchSearchForTypeSuffix(type, this.locator.pattern.typeSuffix)) {
            return DOMTypeDeclarationLocator.toResponse(0);
        }
        if (this.matchModule(this.locator.pattern, type) == 0) {
            return DOMTypeDeclarationLocator.toResponse(0);
        }
        if (this.locator.pattern instanceof QualifiedTypeDeclarationPattern) {
            QualifiedTypeDeclarationPattern qualifiedPattern = (QualifiedTypeDeclarationPattern)this.locator.pattern;
            int level = this.resolveLevelForType(qualifiedPattern.simpleName, qualifiedPattern.qualification, type);
            return DOMTypeDeclarationLocator.toResponse(level);
        }
        char[] enclosingTypeName = this.locator.pattern.enclosingTypeNames == null ? null : CharOperation.concatWith((char[][])this.locator.pattern.enclosingTypeNames, (char)'.');
        int level = this.resolveLevelForType(this.locator.pattern.simpleName, this.locator.pattern.pkg, enclosingTypeName, type);
        return DOMTypeDeclarationLocator.toResponse(level);
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[] enclosingNamePattern, ITypeBinding type) {
        if (enclosingNamePattern == null) {
            return this.resolveLevelForType(simpleNamePattern, qualificationPattern, type);
        }
        if (qualificationPattern == null) {
            return this.resolveLevelForType(simpleNamePattern, enclosingNamePattern, type);
        }
        char[] fullQualificationPattern = CharOperation.concat((char[])qualificationPattern, (char[])enclosingNamePattern, (char)'.');
        if (CharOperation.equals((char[])this.locator.pattern.pkg, (char[])type.getPackage().getName().toCharArray())) {
            return this.resolveLevelForType(simpleNamePattern, fullQualificationPattern, type);
        }
        return 0;
    }

    private int matchModule(TypeDeclarationPattern typePattern, ITypeBinding type) {
        IModuleBinding module = type.getModule();
        if (module == null || module.getName() == null || typePattern.moduleNames == null) {
            return 2;
        }
        String bindModName = module.getName();
        if (typePattern.modulePatterns == null) {
            char[][] moduleList;
            for (char[] m : typePattern.moduleNames) {
                int ret = this.locator.matchNameValue(m, bindModName.toCharArray());
                if (ret == 0) continue;
                return ret;
            }
            for (char[] m : moduleList = this.getModuleList(typePattern)) {
                int ret = this.locator.matchNameValue(m, bindModName.toCharArray());
                if (ret == 0) continue;
                return ret;
            }
        } else {
            for (Pattern p : typePattern.modulePatterns) {
                Matcher matcher = p.matcher(bindModName);
                if (!matcher.matches()) continue;
                return 3;
            }
        }
        return 0;
    }

    private HashSet<String> getModuleGraph(String mName, TypeDeclarationPattern typePattern, HashSet<String> mGraph) {
        mGraph.add(mName);
        SearchPattern modulePattern = SearchPattern.createPattern((String)mName, (int)12, (int)0, (int)typePattern.getMatchRule());
        if (modulePattern == null) {
            return mGraph;
        }
        final HashSet tmpGraph = new HashSet();
        JavaSearchParticipant participant = new JavaSearchParticipant(this){

            public void locateMatches(SearchDocument[] indexMatches, SearchPattern mPattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
                DOMMatchLocator matchLocator = new DOMMatchLocator(mPattern, requestor, scope, monitor);
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                matchLocator.locateMatches(indexMatches);
                this.addRequiredModules(matchLocator);
            }

            private void addRequiredModules(DOMMatchLocator matchLocator) {
                for (IModuleBinding m : matchLocator.moduleBindings) {
                    if (m.getName() == null || m.getName().isEmpty()) continue;
                    tmpGraph.add(new String(m.getName()));
                    for (IModuleBinding r : m.getRequiredModules()) {
                        char[] name = r.getName().toCharArray();
                        if (name == null || CharOperation.equals((char[])name, (char[])CharOperation.NO_CHAR)) continue;
                        tmpGraph.add(new String(name));
                    }
                }
            }
        };
        SearchRequestor requestor = new SearchRequestor(this){

            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                if (JavaModelManager.VERBOSE) {
                    JavaModelManager.trace((String)searchMatch.toString());
                }
            }
        };
        try {
            new SearchEngine().search(modulePattern, new SearchParticipant[]{participant}, (IJavaSearchScope)JavaModelManager.getJavaModelManager().getWorkspaceScope(), requestor, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        mGraph.addAll(tmpGraph);
        return mGraph;
    }

    protected char[][] getModuleList(TypeDeclarationPattern typePattern) {
        if (!typePattern.moduleGraph) {
            return typePattern.moduleNames;
        }
        if (typePattern.moduleGraphElements != null) {
            return typePattern.moduleGraphElements;
        }
        typePattern.moduleGraphElements = CharOperation.NO_CHAR_CHAR;
        List<String> moduleList = Arrays.asList(CharOperation.toStrings((char[][])typePattern.moduleNames));
        int sz = moduleList.size();
        HashSet<String> mGraph = new HashSet<String>();
        for (int i = 0; i < sz; ++i) {
            mGraph = this.getModuleGraph(moduleList.get(i), typePattern, mGraph);
        }
        sz = mGraph.size();
        if (sz > 0) {
            String[] ar = mGraph.toArray(new String[0]);
            char[][] tmp = new char[sz][];
            for (int i = 0; i < sz; ++i) {
                tmp[i] = ar[i].toCharArray();
            }
            typePattern.moduleGraphElements = tmp;
        }
        return typePattern.moduleGraphElements;
    }
}

