/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.gradle;

import com.microsoft.java.bs.core.internal.gradle.GradleBuildKind;
import com.microsoft.java.bs.core.internal.model.Preferences;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.util.GradleVersion;

public class Utils {
    private static final String INIT_GRADLE_SCRIPT = "init.gradle";
    private static final String GRADLE_HOME = "GRADLE_HOME";
    private static final String GRADLE_USER_HOME = "GRADLE_USER_HOME";

    private Utils() {
    }

    public static GradleConnector getProjectConnector(URI projectUri, Preferences preferences) {
        return Utils.getProjectConnector(new File(projectUri), preferences);
    }

    public static GradleConnector getProjectConnector(File project, Preferences preferences) {
        GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(project);
        File gradleUserHome = Utils.getGradleUserHomeFile(preferences.getGradleUserHome());
        if (gradleUserHome != null && gradleUserHome.exists()) {
            connector.useGradleUserHomeDir(gradleUserHome);
        }
        switch (Utils.getEffectiveBuildKind(project, preferences)) {
            case SPECIFIED_VERSION: {
                connector.useGradleVersion(preferences.getGradleVersion());
                break;
            }
            case SPECIFIED_INSTALLATION: {
                connector.useInstallation(Utils.getGradleHome(preferences.getGradleHome()));
                break;
            }
            default: {
                connector.useBuildDistribution();
            }
        }
        return connector;
    }

    public static <T> BuildActionExecuter<T> getBuildActionExecuter(ProjectConnection connection, Preferences preferences, BuildAction<T> action) {
        return Utils.setLauncherProperties(connection.action(action), preferences);
    }

    public static BuildLauncher getBuildLauncher(ProjectConnection connection, Preferences preferences) {
        return Utils.setLauncherProperties(connection.newBuild(), preferences);
    }

    public static TestLauncher getTestLauncher(ProjectConnection connection, Preferences preferences) {
        return Utils.setLauncherProperties(connection.newTestLauncher(), preferences);
    }

    public static <T extends ConfigurableLauncher<T>> T setLauncherProperties(T launcher, Preferences preferences) {
        List<String> gradleArguments;
        List<String> gradleJvmArguments;
        File gradleJavaHomeFile = Utils.getGradleJavaHomeFile(preferences.getGradleJavaHome());
        if (gradleJavaHomeFile != null && gradleJavaHomeFile.exists()) {
            launcher.setJavaHome(gradleJavaHomeFile);
        }
        if ((gradleJvmArguments = preferences.getGradleJvmArguments()) != null && !gradleJvmArguments.isEmpty()) {
            launcher.setJvmArguments(gradleJvmArguments);
        }
        if ((gradleArguments = preferences.getGradleArguments()) != null && !gradleArguments.isEmpty()) {
            launcher.withArguments(gradleArguments);
        }
        return launcher;
    }

    public static String getLatestCompatibleJavaVersion(String gradleVersion) {
        GradleVersion version = GradleVersion.version((String)gradleVersion);
        if (version.compareTo(GradleVersion.version((String)"8.8")) >= 0) {
            return "22";
        }
        if (version.compareTo(GradleVersion.version((String)"8.5")) >= 0) {
            return "21";
        }
        if (version.compareTo(GradleVersion.version((String)"8.3")) >= 0) {
            return "20";
        }
        if (version.compareTo(GradleVersion.version((String)"7.6")) >= 0) {
            return "19";
        }
        if (version.compareTo(GradleVersion.version((String)"7.5")) >= 0) {
            return "18";
        }
        if (version.compareTo(GradleVersion.version((String)"7.3")) >= 0) {
            return "17";
        }
        if (version.compareTo(GradleVersion.version((String)"7.0")) >= 0) {
            return "16";
        }
        if (version.compareTo(GradleVersion.version((String)"6.7")) >= 0) {
            return "15";
        }
        if (version.compareTo(GradleVersion.version((String)"6.3")) >= 0) {
            return "14";
        }
        if (version.compareTo(GradleVersion.version((String)"6.0")) >= 0) {
            return "13";
        }
        if (version.compareTo(GradleVersion.version((String)"5.4")) >= 0) {
            return "12";
        }
        if (version.compareTo(GradleVersion.version((String)"5.0")) >= 0) {
            return "11";
        }
        if (version.compareTo(GradleVersion.version((String)"4.7")) >= 0) {
            return "10";
        }
        if (version.compareTo(GradleVersion.version((String)"4.3")) >= 0) {
            return "9";
        }
        if (version.compareTo(GradleVersion.version((String)"2.0")) >= 0) {
            return "1.8";
        }
        return "";
    }

    public static String getOldestCompatibleJavaVersion() {
        return "1.8";
    }

    public static File getInitScriptFile() {
        return Paths.get(System.getProperty("plugin.dir"), INIT_GRADLE_SCRIPT).toFile();
    }

    static File getGradleUserHomeFile(String gradleUserHome) {
        if (StringUtils.isNotBlank((CharSequence)gradleUserHome)) {
            return new File(gradleUserHome);
        }
        return Utils.getFileFromEnvOrProperty(GRADLE_USER_HOME);
    }

    static File getGradleHome(String gradleHome) {
        File gradleHomeFolder = null;
        if (StringUtils.isNotBlank((CharSequence)gradleHome)) {
            gradleHomeFolder = new File(gradleHome);
        } else {
            String path = System.getenv("PATH");
            if (StringUtils.isNotBlank((CharSequence)path)) {
                for (String p : path.split(File.pathSeparator)) {
                    Optional<File> gradleLauncherJar;
                    File[] files;
                    File gradleLibFolder;
                    File gradleBinFolder;
                    File gradle = new File(p, "gradle");
                    if (!gradle.exists() || !gradle.isFile() || (gradleBinFolder = gradle.getParentFile()) == null || !gradleBinFolder.isDirectory() || !gradleBinFolder.getName().equals("bin") || !(gradleLibFolder = new File(gradleBinFolder.getParent(), "lib")).isDirectory() || (files = gradleLibFolder.listFiles()) == null || !(gradleLauncherJar = Arrays.stream(files).filter(file -> file.isFile() && file.getName().startsWith("gradle-launcher-") && file.getName().endsWith(".jar")).findFirst()).isPresent()) continue;
                    gradleHomeFolder = gradleBinFolder.getParentFile();
                    break;
                }
            }
        }
        if (gradleHomeFolder == null) {
            gradleHomeFolder = Utils.getFileFromEnvOrProperty(GRADLE_HOME);
        }
        if (gradleHomeFolder != null && gradleHomeFolder.isDirectory()) {
            return gradleHomeFolder;
        }
        return null;
    }

    static File getFileFromEnvOrProperty(String key) {
        String value = System.getenv().get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = System.getProperties().getProperty(key);
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return new File(value);
        }
        return null;
    }

    static File getGradleJavaHomeFile(String gradleJavaHome) {
        File file;
        if (StringUtils.isNotBlank((CharSequence)gradleJavaHome) && (file = new File(gradleJavaHome)).isDirectory()) {
            return file;
        }
        return null;
    }

    public static GradleBuildKind getEffectiveBuildKind(File projectRoot, Preferences preferences) {
        File wrapperProperties;
        if (preferences.isWrapperEnabled() && (wrapperProperties = Paths.get(projectRoot.getAbsolutePath(), "gradle", "wrapper", "gradle-wrapper.properties").toFile()).exists()) {
            return GradleBuildKind.WRAPPER;
        }
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleVersion())) {
            return GradleBuildKind.SPECIFIED_VERSION;
        }
        File gradleHome = Utils.getGradleHome(preferences.getGradleHome());
        if (gradleHome != null && gradleHome.exists()) {
            return GradleBuildKind.SPECIFIED_INSTALLATION;
        }
        return GradleBuildKind.TAPI;
    }
}

