/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class CreateVariableReferenceProposalCore
extends LinkedCorrectionProposalCore {
    private ITypeBinding fTypeNode;
    private VariableDeclarationFragment fSelectedNode;
    private String varName = null;
    private String varClass = null;

    public CreateVariableReferenceProposalCore(ICompilationUnit cu, VariableDeclarationFragment selectedNode, ITypeBinding typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fSelectedNode = selectedNode;
        this.fTypeNode = typeNode;
    }

    public boolean hasProposal() {
        if (this.fSelectedNode.getInitializer().getNodeType() != 40) {
            return false;
        }
        IVariableBinding variabelReference = this.findReference();
        if (variabelReference != null) {
            this.varName = variabelReference.getName();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createnew_reference_to_variable, new Object[]{this.varName, this.varClass});
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        IVariableBinding findInstance = this.findReference();
        if (findInstance == null) {
            return null;
        }
        AST ast = this.fSelectedNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        CompilationUnit cu = (CompilationUnit)this.fSelectedNode.getRoot();
        this.createImportRewrite(cu);
        VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
        vdf.setName(ast.newSimpleName(this.fSelectedNode.getName().getIdentifier()));
        vdf.setInitializer((Expression)ast.newSimpleName(this.varName));
        rewrite.replace((ASTNode)this.fSelectedNode, (ASTNode)vdf, null);
        return rewrite;
    }

    private IVariableBinding findReference() {
        BodyDeclaration parent = ASTNodes.getParent((ASTNode)this.fSelectedNode, BodyDeclaration.class);
        String qualifiedTypeName = Bindings.getFullyQualifiedName(this.fTypeNode);
        Set<SimpleName> localVariableIdentifiers = ASTNodes.getLocalVariableIdentifiers((ASTNode)parent, true);
        for (SimpleName name : localVariableIdentifiers) {
            String qualifiedTypeName2;
            ITypeBinding variableBindingType;
            IVariableBinding variableBinding;
            if (name.getStartPosition() > this.fSelectedNode.getStartPosition()) continue;
            VariableDeclaration vd = (VariableDeclaration)name.getParent();
            if (this.fSelectedNode.getName().getIdentifier().equals(vd.getName().getIdentifier()) || (variableBinding = vd.resolveBinding()) == null || (variableBindingType = variableBinding.getType()) == null || !qualifiedTypeName.equals(qualifiedTypeName2 = Bindings.getFullyQualifiedName(variableBindingType))) continue;
            this.varClass = ((TypeDeclaration)ASTResolving.findAncestor((ASTNode)name, 55)).getName().getIdentifier();
            return ((VariableDeclaration)name.getParent()).resolveBinding();
        }
        List<IVariableBinding> visibleLocalVariablesInScope = CreateVariableReferenceProposalCore.getVisibleLocalVariablesInScope((ASTNode)this.fSelectedNode);
        for (IVariableBinding binding : visibleLocalVariablesInScope) {
            if (Modifier.isStatic((int)parent.getModifiers()) && !Modifier.isStatic((int)binding.getModifiers()) || !Bindings.equals((IBinding)binding.getType(), (IBinding)this.fTypeNode)) continue;
            this.varClass = binding.isField() ? binding.getDeclaringClass().getName() : "local block";
            return binding;
        }
        return null;
    }

    private static List<IVariableBinding> getVisibleLocalVariablesInScope(ASTNode node) {
        IBinding[] bindings;
        ArrayList<IVariableBinding> variableNames = new ArrayList<IVariableBinding>();
        CompilationUnit root = (CompilationUnit)node.getRoot();
        IBinding[] iBindingArray = bindings = new ScopeAnalyzer(root).getDeclarationsInScope(node.getStartPosition(), 18);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            variableNames.add((IVariableBinding)binding);
            ++n2;
        }
        return variableNames;
    }
}

