/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.preferences.CodeSmellTypeToPreferenceTypeMapper;
import org.eclipse.titanium.preferences.ProblemTypePreference;

abstract class BaseCodeSmellSpotter {
    private final CodeSmellType type;
    private final int severity;

    protected BaseCodeSmellSpotter(CodeSmellType type) {
        this.type = type;
        IPreferencesService prefs = Platform.getPreferencesService();
        ProblemTypePreference pref = CodeSmellTypeToPreferenceTypeMapper.getPreferenceType(type);
        if (prefs == null) {
            this.severity = 1;
        } else {
            String prefName = pref.getPreferenceName();
            String warnLevel = prefs.getString("org.eclipse.titanium", prefName, "ignore", null);
            if (warnLevel.equals("ignore")) {
                this.severity = 0;
            } else if (warnLevel.equals("warning")) {
                this.severity = 1;
            } else if (warnLevel.equals("error")) {
                this.severity = 2;
            } else {
                throw new IllegalStateException("warnLevel should be one of IGNORE, WARNING or ERROR, not " + warnLevel);
            }
        }
    }

    protected class Problems {
        private final List<Marker> reports = new LinkedList<Marker>();

        protected Problems() {
        }

        public void report(Location loc, String message) {
            this.reports.add(new Marker(loc, message, BaseCodeSmellSpotter.this.severity, BaseCodeSmellSpotter.this.type));
        }

        public void report(IResource res, String message) {
            this.reports.add(new Marker(res, message, BaseCodeSmellSpotter.this.severity, BaseCodeSmellSpotter.this.type));
        }

        public List<Marker> getMarkers() {
            return this.reports;
        }
    }
}

