/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.implementation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.implementation.BaseModuleMetric;

public class MMTimesImported
extends BaseModuleMetric {
    private final Map<Module, Integer> imported = new HashMap<Module, Integer>();

    public MMTimesImported() {
        super(ModuleMetric.TIMES_IMPORTED);
    }

    @Override
    public void init(MetricData data) {
        this.imported.clear();
        List<Module> modules = data.getModules();
        for (Module module : modules) {
            this.imported.put(module, 0);
        }
        for (Module module : modules) {
            for (Module imp : module.getImportedModules()) {
                Integer count = this.imported.get(imp);
                if (count == null) continue;
                this.imported.put(imp, count + 1);
            }
        }
    }

    @Override
    public Number measure(MetricData data, Module module) {
        return this.imported.get(module);
    }
}

