/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.inject;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.inject.AdapterMap;
import org.eclipse.gef4.common.inject.AdapterMapInjector;

public class AdaptableTypeListener
implements TypeListener {
    private Injector injector;
    private Set<AdapterMapInjector> nonInjectedMemberInjectors = new HashSet<AdapterMapInjector>();

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
        for (AdapterMapInjector memberInjector : this.nonInjectedMemberInjectors) {
            injector.injectMembers((Object)memberInjector);
        }
        this.nonInjectedMemberInjectors.clear();
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        if (IAdaptable.class.isAssignableFrom(type.getRawType())) {
            Method[] methodArray = type.getRawType().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                int i = 0;
                while (i < method.getParameterAnnotations().length) {
                    AdapterMap methodAnnotation = this.getAnnotation(method.getParameterAnnotations()[i], AdapterMap.class);
                    if (methodAnnotation != null) {
                        if (method.getParameterTypes().length != 1) {
                            encounter.addError("AdapterBinding annotation is only valid on one-parameter operations.", new Object[]{method});
                        }
                        AdapterMapInjector membersInjector = new AdapterMapInjector(method, methodAnnotation);
                        if (this.injector != null) {
                            this.injector.injectMembers((Object)membersInjector);
                        } else {
                            this.nonInjectedMemberInjectors.add(membersInjector);
                        }
                        encounter.register((MembersInjector)membersInjector);
                    }
                    ++i;
                }
                ++n2;
            }
        }
    }

    private <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationType) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationType.isAssignableFrom(a.annotationType())) {
                return (T)a;
            }
            ++n2;
        }
        return null;
    }
}

