/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.listeners;

import java.util.HashMap;
import java.util.HashSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Transform;

public abstract class VisualChangeListener {
    private final ChangeListener<? super Bounds> boundsInLocalListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            if (VisualChangeListener.this.isValidBounds(newValue)) {
                VisualChangeListener.this.boundsInLocalChanged(oldValue, newValue);
            }
        }
    };
    private Node observed;
    private Node parent;
    private HashMap<ChangeListener<Transform>, Node> localToParentTransformListeners = new HashMap();

    protected abstract void boundsInLocalChanged(Bounds var1, Bounds var2);

    private Node getNearestCommonAncestor(Node source, Node target) {
        if (source == target) {
            return source;
        }
        HashSet<Node> parents = new HashSet<Node>();
        Node m = source;
        Node n = target;
        while (m != null || n != null) {
            if (m != null) {
                if (parents.contains(m)) {
                    return m;
                }
                parents.add(m);
                if (n != null && parents.contains(n)) {
                    return n;
                }
                m = m.getParent();
            }
            if (n == null) continue;
            if (parents.contains(n)) {
                return n;
            }
            parents.add(n);
            if (m != null && parents.contains(m)) {
                return m;
            }
            n = n.getParent();
        }
        return null;
    }

    public boolean isRegistered() {
        return this.parent != null;
    }

    private boolean isValidBounds(Bounds b) {
        if (Double.isNaN(b.getMinX())) {
            return false;
        }
        if (Double.isNaN(b.getMinY())) {
            return false;
        }
        if (Double.isNaN(b.getMaxX())) {
            return false;
        }
        return !Double.isNaN(b.getMaxY());
    }

    private boolean isValidTransform(Transform t) {
        if (Double.isNaN(t.getMxx())) {
            return false;
        }
        if (Double.isNaN(t.getMxy())) {
            return false;
        }
        if (Double.isNaN(t.getMxz())) {
            return false;
        }
        if (Double.isNaN(t.getMyx())) {
            return false;
        }
        if (Double.isNaN(t.getMyy())) {
            return false;
        }
        if (Double.isNaN(t.getMyz())) {
            return false;
        }
        if (Double.isNaN(t.getMzx())) {
            return false;
        }
        if (Double.isNaN(t.getMzy())) {
            return false;
        }
        if (Double.isNaN(t.getMzz())) {
            return false;
        }
        if (Double.isNaN(t.getTx())) {
            return false;
        }
        if (Double.isNaN(t.getTy())) {
            return false;
        }
        return !Double.isNaN(t.getTz());
    }

    protected abstract void localToParentTransformChanged(Node var1, Transform var2, Transform var3);

    public void register(Node observed, Node observer) {
        if (observed == null) {
            throw new IllegalArgumentException("Observed may not be null.");
        }
        if (observer == null) {
            throw new IllegalArgumentException("Observer not be null.");
        }
        Node commonAncestor = this.getNearestCommonAncestor(observed, observer);
        if (commonAncestor == null) {
            throw new IllegalArgumentException("Source and target do not share a common ancestor.");
        }
        Node tmp = observed;
        while (tmp != null && tmp != commonAncestor) {
            tmp = tmp.getParent();
        }
        if (tmp == null) {
            throw new IllegalArgumentException("TransformReference needs to be ancestor of the given observed node.");
        }
        if (this.observed != null) {
            this.unregister();
        }
        this.observed = observed;
        this.parent = commonAncestor;
        observed.boundsInLocalProperty().addListener(this.boundsInLocalListener);
        tmp = observed;
        while (tmp != null && tmp != this.parent) {
            final Node current = tmp;
            ChangeListener<Transform> transformChangeListener = new ChangeListener<Transform>(){

                public void changed(ObservableValue<? extends Transform> observable, Transform oldValue, Transform newValue) {
                    if (VisualChangeListener.this.isValidTransform(newValue)) {
                        VisualChangeListener.this.localToParentTransformChanged(current, oldValue, newValue);
                    }
                }
            };
            tmp.localToParentTransformProperty().addListener((ChangeListener)transformChangeListener);
            this.localToParentTransformListeners.put(transformChangeListener, tmp);
            tmp = tmp.getParent();
        }
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.observed.boundsInLocalProperty().removeListener(this.boundsInLocalListener);
        for (ChangeListener<Transform> l : this.localToParentTransformListeners.keySet()) {
            this.localToParentTransformListeners.get(l).localToParentTransformProperty().removeListener(l);
        }
        this.parent = null;
        this.observed = null;
        this.localToParentTransformListeners.clear();
    }
}

