/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import javafx.geometry.Bounds;
import javafx.scene.shape.Path;
import org.eclipse.gef4.geometry.convert.fx.Geometry2JavaFX;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Arc;
import org.eclipse.gef4.geometry.planar.Ellipse;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.Pie;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.RoundedRectangle;

public class FXGeometryNode<T extends IGeometry>
extends Path {
    private T geometry;

    public FXGeometryNode() {
    }

    public FXGeometryNode(T geom) {
        this.setGeometry(geom);
    }

    public T getGeometry() {
        return this.geometry;
    }

    protected Bounds impl_computeLayoutBounds() {
        return Geometry2JavaFX.toFXBounds((Rectangle)(this.geometry == null ? new Rectangle() : this.geometry.getBounds()));
    }

    public boolean isResizable() {
        return true;
    }

    public double maxHeight(double width) {
        return this.prefHeight(width);
    }

    public double maxWidth(double height) {
        return this.prefWidth(height);
    }

    public double minHeight(double width) {
        return this.prefHeight(width);
    }

    public double minWidth(double height) {
        return this.prefWidth(height);
    }

    public double prefHeight(double width) {
        return this.geometry.getBounds().getHeight();
    }

    public double prefWidth(double height) {
        return this.geometry.getBounds().getWidth();
    }

    public void resize(double width, double height) {
        if (width < 0.0) {
            throw new IllegalArgumentException("Cannot resize: width < 0.");
        }
        if (height < 0.0) {
            throw new IllegalArgumentException("Cannot resize: height < 0.");
        }
        Bounds layoutBounds = this.getLayoutBounds();
        if (layoutBounds.getWidth() == width && layoutBounds.getHeight() == height) {
            return;
        }
        if (this.geometry instanceof Rectangle) {
            ((Rectangle)this.geometry).setSize(width, height);
        } else if (this.geometry instanceof RoundedRectangle) {
            ((RoundedRectangle)this.geometry).setSize(width, height);
        } else if (this.geometry instanceof Ellipse) {
            ((Ellipse)this.geometry).setSize(width, height);
        } else if (this.geometry instanceof Pie) {
            ((Pie)this.geometry).setSize(width, height);
        } else if (this.geometry instanceof Arc) {
            ((Arc)this.geometry).setSize(width, height);
        } else {
            Rectangle geometricBounds = this.geometry.getBounds();
            double sx = width / geometricBounds.getWidth();
            double sy = height / geometricBounds.getHeight();
            if (this.geometry instanceof IScalable) {
                ((IScalable)this.geometry).scale(sx, sy, geometricBounds.getX(), geometricBounds.getY());
            } else {
                Point boundsOrigin = new Point(geometricBounds.getX(), geometricBounds.getY());
                this.geometry = this.geometry.getTransformed(new AffineTransform(1.0, 0.0, 0.0, 1.0, -boundsOrigin.x, -boundsOrigin.y)).getTransformed(new AffineTransform(sx, 0.0, 0.0, sy, 0.0, 0.0)).getTransformed(new AffineTransform(1.0, 0.0, 0.0, 1.0, boundsOrigin.x, boundsOrigin.y));
            }
        }
        this.updatePathElements();
    }

    public void setGeometry(T geometry) {
        this.geometry = geometry;
        this.updatePathElements();
    }

    private void updatePathElements() {
        this.getElements().setAll((Object[])Geometry2JavaFX.toPathElements((org.eclipse.gef4.geometry.planar.Path)this.geometry.toPath()));
    }
}

