/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.AbstractRectangleBasedGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;
import org.eclipse.gef4.geometry.planar.Polyline;
import org.eclipse.gef4.geometry.planar.ShapeUtils;
import org.eclipse.gef4.internal.geometry.utils.PrecisionUtils;

public final class Rectangle
extends AbstractRectangleBasedGeometry<Rectangle, Polygon>
implements IShape {
    private static final long serialVersionUID = 1L;

    public Rectangle() {
        super(0.0, 0.0, 0.0, 0.0);
    }

    public Rectangle(double x, double y, double width, double height) {
        super(x, y, width < 0.0 ? 0.0 : width, height < 0.0 ? 0.0 : height);
    }

    public Rectangle(Point location, Dimension size) {
        this(location.x, location.y, size.width, size.height);
    }

    public Rectangle(Point p1, Point p2) {
        this(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
    }

    public Rectangle(Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public boolean contains(double x, double y) {
        return PrecisionUtils.greaterEqual(y, this.y) && PrecisionUtils.smallerEqual(y, this.y + this.height) && PrecisionUtils.greaterEqual(x, this.x) && PrecisionUtils.smallerEqual(x, this.x + this.width);
    }

    public boolean contains(double x, double y, double width, double height) {
        return PrecisionUtils.smallerEqual(this.x, x) && PrecisionUtils.smallerEqual(this.y, y) && PrecisionUtils.greaterEqual(this.x + this.width, x + width) && PrecisionUtils.greaterEqual(this.y + this.height, y + height);
    }

    @Override
    public boolean contains(IGeometry g) {
        if (g instanceof Rectangle) {
            return this.contains((Rectangle)g);
        }
        return ShapeUtils.contains((IShape)this, g);
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.x(), p.y());
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public boolean equals(double x, double y, double width, double height) {
        return PrecisionUtils.equal(this.x, x) && PrecisionUtils.equal(this.y, y) && PrecisionUtils.equal(this.width, width) && PrecisionUtils.equal(this.height, height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Rectangle) {
            Rectangle r = (Rectangle)o;
            return this.equals(r.x, r.y, r.width, r.height);
        }
        return false;
    }

    public double getArea() {
        return this.width * this.height;
    }

    public Point getBottom() {
        return new Point(this.x + this.width / 2.0, this.y + this.height);
    }

    public Point getBottomLeft() {
        return new Point(this.x, this.y + this.height);
    }

    public Point getBottomRight() {
        return new Point(this.x + this.width, this.y + this.height);
    }

    @Override
    public Rectangle getCopy() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getIntersected(Rectangle rect) {
        return this.getCopy().intersect(rect);
    }

    public Point getLeft() {
        return new Point(this.x, this.y + this.height / 2.0);
    }

    @Override
    public Polyline getOutline() {
        return new Polyline(this.x, this.y, this.x + this.width, this.y, this.x + this.width, this.y + this.height, this.x, this.y + this.height, this.x, this.y);
    }

    public Line[] getOutlineSegments() {
        Line[] segments = new Line[]{new Line(this.x, this.y, this.x + this.width, this.y), new Line(this.x + this.width, this.y, this.x + this.width, this.y + this.height), new Line(this.x + this.width, this.y + this.height, this.x, this.y + this.height), new Line(this.x, this.y + this.height, this.x, this.y)};
        return segments;
    }

    public Point[] getPoints() {
        return new Point[]{this.getTopLeft(), this.getTopRight(), this.getBottomRight(), this.getBottomLeft()};
    }

    public Point getRight() {
        return new Point(this.x + this.width, this.y + this.height / 2.0);
    }

    @Override
    public Polygon getRotatedCCW(Angle alpha) {
        Point centroid = this.getCenter();
        return (Polygon)this.toPolygon().rotateCCW(alpha, centroid.x, centroid.y);
    }

    @Override
    public Polygon getRotatedCCW(Angle alpha, double cx, double cy) {
        return (Polygon)this.toPolygon().rotateCCW(alpha, cx, cy);
    }

    @Override
    public Polygon getRotatedCCW(Angle alpha, Point center) {
        return (Polygon)this.toPolygon().rotateCCW(alpha, center.x, center.y);
    }

    @Override
    public Polygon getRotatedCW(Angle alpha) {
        Point centroid = this.getCenter();
        return (Polygon)this.toPolygon().rotateCW(alpha, centroid.x, centroid.y);
    }

    @Override
    public Polygon getRotatedCW(Angle alpha, double cx, double cy) {
        return (Polygon)this.toPolygon().rotateCW(alpha, cx, cy);
    }

    @Override
    public Polygon getRotatedCW(Angle alpha, Point center) {
        return (Polygon)this.toPolygon().rotateCW(alpha, center.x, center.y);
    }

    public Point getTop() {
        return new Point(this.x + this.width / 2.0, this.y);
    }

    public Point getTopLeft() {
        return new Point(this.x, this.y);
    }

    public Point getTopRight() {
        return new Point(this.x + this.width, this.y);
    }

    @Override
    public Polygon getTransformed(AffineTransform t) {
        return new Polygon(t.getTransformed(this.getPoints()));
    }

    public Rectangle getTransposed() {
        return this.getCopy().transpose();
    }

    public Rectangle getUnioned(Point p) {
        return this.getCopy().union(p);
    }

    public Rectangle getUnioned(Rectangle rect) {
        return this.getCopy().union(rect);
    }

    public Rectangle intersect(Rectangle r) {
        double x1 = Math.max(this.x, r.x);
        double x2 = Math.min(this.x + this.width, r.x + r.width);
        double y1 = Math.max(this.y, r.y);
        double y2 = Math.min(this.y + this.height, r.y + r.height);
        if (PrecisionUtils.greaterEqual(x2 - x1, 0.0) && PrecisionUtils.greaterEqual(y2 - y1, 0.0)) {
            this.setBounds(x1, y1, x2 - x1 < 0.0 ? 0.0 : x2 - x1, y2 - y1 < 0.0 ? 0.0 : y2 - y1);
            return this;
        }
        this.setBounds(0.0, 0.0, 0.0, 0.0);
        return this;
    }

    public boolean isEmpty() {
        return PrecisionUtils.smallerEqual(this.width, 0.0) || PrecisionUtils.smallerEqual(this.height, 0.0);
    }

    @Override
    public Path toPath() {
        Path path = new Path();
        path.moveTo(this.x, this.y);
        path.lineTo(this.x + this.width, this.y);
        path.lineTo(this.x + this.width, this.y + this.height);
        path.lineTo(this.x, this.y + this.height);
        path.close();
        return path;
    }

    public Polygon toPolygon() {
        return new Polygon(Point.getCopy(this.getPoints()));
    }

    public String toString() {
        return "Rectangle: (" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }

    @Override
    public boolean touches(IGeometry g) {
        if (g instanceof Line) {
            return this.touches((Line)g);
        }
        if (g instanceof Rectangle) {
            return this.touches((Rectangle)g);
        }
        return super.touches(g);
    }

    public boolean touches(Line l) {
        if (this.contains(l.getP1()) || this.contains(l.getP2())) {
            return true;
        }
        Line[] lineArray = this.getOutlineSegments();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line segment = lineArray[n2];
            if (segment.intersects(l)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean touches(Rectangle r) {
        return PrecisionUtils.smallerEqual(r.x, this.x + this.width) && PrecisionUtils.smallerEqual(r.y, this.y + this.height) && PrecisionUtils.greaterEqual(r.x + r.width, this.x) && PrecisionUtils.greaterEqual(r.y + r.height, this.y);
    }

    public Rectangle transpose() {
        double temp = this.x;
        this.x = this.y;
        this.y = temp;
        temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public Rectangle union(double x, double y) {
        if (x < this.x) {
            this.width += this.x - x;
            this.x = x;
        } else if (x > this.x + this.width) {
            this.width += x - this.x - this.width;
        }
        if (y < this.y) {
            this.height += this.y - y;
            this.y = y;
        } else if (y > this.y + this.height) {
            this.height += y - this.y - this.height;
        }
        return this;
    }

    public Rectangle union(double x, double y, double w, double h) {
        double right = Math.max(this.x + this.width, x + w);
        double bottom = Math.max(this.y + this.height, y + h);
        this.x = Math.min(this.x, x);
        this.y = Math.min(this.y, y);
        this.width = right - this.x;
        this.height = bottom - this.y;
        return this;
    }

    public Rectangle union(Point p) {
        return this.union(p.x, p.y);
    }

    public Rectangle union(Rectangle r) {
        return this.union(r.x, r.y, r.width, r.height);
    }
}

