/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public final class GraphCopier {
    private Graph sourceGraph;
    private String attributeNameForId = "ID";

    public GraphCopier(Graph sourceGraph, String attributeNameForId) {
        this.sourceGraph = sourceGraph;
        this.attributeNameForId = attributeNameForId;
    }

    private Edge copy(Edge edge, Graph.Builder targetGraph, Map<Node, Node> copiedNodes, Map<Object, Node> ids) {
        Node srcTarget;
        Node target;
        Node srcSource = edge.getSource();
        Node source = this.find(ids, srcSource);
        if (source == null) {
            source = copiedNodes.get(srcSource);
        }
        if ((target = this.find(ids, srcTarget = edge.getTarget())) == null) {
            target = copiedNodes.get(srcTarget);
        }
        Edge.Builder copy = new Edge.Builder(source, target);
        for (Map.Entry<String, Object> attr : edge.getAttrs().entrySet()) {
            copy.attr(attr.getKey(), attr.getValue());
        }
        Edge build = copy.build();
        targetGraph.edges(build);
        return build;
    }

    private Node copy(Node node, Graph.Builder targetGraph) {
        Node.Builder copy = new Node.Builder();
        for (Map.Entry<String, Object> attr : node.getAttrs().entrySet()) {
            copy.attr(attr.getKey(), attr.getValue());
        }
        Node copiedNode = copy.build();
        targetGraph.nodes(copiedNode);
        return copiedNode;
    }

    private Node find(Map<Object, Node> ids, Node n) {
        Object id = n.getAttrs().get(this.attributeNameForId);
        if (id != null && !ids.containsKey(id)) {
            ids.put(id, n);
            return null;
        }
        return ids.get(id);
    }

    public void into(Graph.Builder targetGraph) {
        for (Map.Entry<String, Object> attr : this.sourceGraph.getAttrs().entrySet()) {
            targetGraph.attr(attr.getKey(), attr.getValue());
        }
        Graph targetGraphBuilt = targetGraph.build();
        List<Node> nodes = targetGraphBuilt.getNodes();
        HashMap<Object, Node> ids = new HashMap<Object, Node>();
        for (Node n : nodes) {
            this.find(ids, n);
        }
        HashMap<Node, Node> copiedNodes = new HashMap<Node, Node>();
        for (Node node : this.sourceGraph.getNodes()) {
            if (this.find(ids, node) != null) continue;
            copiedNodes.put(node, this.copy(node, targetGraph));
        }
        for (Edge edge : this.sourceGraph.getEdges()) {
            this.copy(edge, targetGraph, copiedNodes, ids);
        }
    }
}

