/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef4.common.properties.IPropertyStore;
import org.eclipse.gef4.common.properties.PropertyStoreSupport;
import org.eclipse.gef4.layout.IConnectionLayout;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.ILayoutFilter;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.ISubgraphLayout;
import org.eclipse.gef4.layout.listeners.IContextListener;
import org.eclipse.gef4.layout.listeners.IGraphStructureListener;
import org.eclipse.gef4.layout.listeners.ILayoutListener;
import org.eclipse.gef4.layout.listeners.IPruningListener;
import org.eclipse.gef4.layout.listeners.LayoutListenerSupport;

public abstract class AbstractLayoutContext
implements ILayoutContext {
    private LayoutListenerSupport lls = new LayoutListenerSupport(this);
    private ILayoutAlgorithm dynamicLayoutAlgorithm = null;
    private ILayoutAlgorithm staticLayoutAlgorithm = null;
    private final List<INodeLayout> layoutNodes = new ArrayList<INodeLayout>();
    private final List<IConnectionLayout> layoutEdges = new ArrayList<IConnectionLayout>();
    private final List<ISubgraphLayout> subgraphs = new ArrayList<ISubgraphLayout>();
    private boolean flushChangesInvocation = false;
    private final List<Runnable> postLayoutPass = new ArrayList<Runnable>();
    private final List<Runnable> preLayoutPass = new ArrayList<Runnable>();
    private final List<ILayoutFilter> layoutFilters = new ArrayList<ILayoutFilter>();
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected PropertyStoreSupport pss = new PropertyStoreSupport((IPropertyStore)this, this.pcs);

    public void addContextListener(IContextListener listener) {
        this.lls.addContextListener(listener);
    }

    protected void addEdge(IConnectionLayout edge) {
        this.layoutEdges.add(edge);
        this.fireConnectionAddedEvent(edge);
    }

    public void addGraphStructureListener(IGraphStructureListener listener) {
        this.lls.addGraphStructureListener(listener);
    }

    public void addLayoutFilter(ILayoutFilter layoutFilter) {
        this.layoutFilters.add(layoutFilter);
    }

    public void addLayoutListener(ILayoutListener listener) {
        this.lls.addLayoutListener(listener);
    }

    protected void addNode(INodeLayout node) {
        this.layoutNodes.add(node);
        this.fireNodeAddedEvent(node);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPruningListener(IPruningListener listener) {
        this.lls.addPruningListener(listener);
    }

    public void applyDynamicLayout(boolean clear) {
        if (this.dynamicLayoutAlgorithm != null) {
            for (Runnable r : this.preLayoutPass) {
                r.run();
            }
            this.dynamicLayoutAlgorithm.applyLayout(clear);
        }
    }

    public void applyStaticLayout(boolean clear) {
        if (this.staticLayoutAlgorithm != null) {
            for (Runnable r : this.preLayoutPass) {
                r.run();
            }
            this.staticLayoutAlgorithm.setLayoutContext(this);
            this.staticLayoutAlgorithm.applyLayout(clear);
        }
    }

    protected void clearEdges() {
        for (IConnectionLayout edge : new ArrayList<IConnectionLayout>(this.layoutEdges)) {
            this.removeEdge(edge);
        }
    }

    protected void clearNodes() {
        for (INodeLayout node : new ArrayList<INodeLayout>(this.layoutNodes)) {
            this.removeNode(node);
        }
    }

    protected void doFlushChanges(boolean animationHint) {
        for (Runnable r : new ArrayList<Runnable>(this.postLayoutPass)) {
            r.run();
        }
    }

    public void fireBackgroundEnableChangedEvent() {
        this.lls.fireBackgroundEnableChangedEvent();
    }

    public void fireBoundsChangedEvent() {
        if (!this.flushChangesInvocation) {
            this.lls.fireBoundsChangedEvent();
        }
    }

    public void fireConnectionAddedEvent(IConnectionLayout connection) {
        if (!this.flushChangesInvocation) {
            this.lls.fireConnectionAddedEvent(connection);
        }
    }

    public void fireConnectionRemovedEvent(IConnectionLayout connection) {
        if (!this.flushChangesInvocation) {
            this.lls.fireConnectionRemovedEvent(connection);
        }
    }

    public void fireNodeAddedEvent(INodeLayout node) {
        if (!this.flushChangesInvocation) {
            this.lls.fireNodeAddedEvent(node);
        }
    }

    public void fireNodeMovedEvent(INodeLayout node) {
        if (!this.flushChangesInvocation) {
            this.lls.fireNodeMovedEvent(node);
        }
    }

    public void fireNodeRemovedEvent(INodeLayout node) {
        if (!this.flushChangesInvocation) {
            this.lls.fireNodeRemovedEvent(node);
        }
    }

    public void fireNodeResizedEvent(INodeLayout node) {
        if (!this.flushChangesInvocation) {
            this.lls.fireNodeResizedEvent(node);
        }
    }

    public void firePruningEnableChangedEvent() {
        this.lls.firePruningEnableChangedEvent();
    }

    public void fireSubgraphMovedEvent(ISubgraphLayout subgraph) {
        if (!this.flushChangesInvocation) {
            this.lls.fireSubgraphMovedEvent(subgraph);
        }
    }

    public void fireSubgraphResizedEvent(ISubgraphLayout subgraph) {
        if (!this.flushChangesInvocation) {
            this.lls.fireSubgraphResizedEvent(subgraph);
        }
    }

    public void flushChanges(boolean animationHint) {
        this.flushChangesInvocation = true;
        this.doFlushChanges(animationHint);
        this.flushChangesInvocation = false;
    }

    public IConnectionLayout[] getConnections() {
        return this.layoutEdges.toArray(new IConnectionLayout[0]);
    }

    public IConnectionLayout[] getConnections(IEntityLayout layoutEntity1, IEntityLayout layoutEntity2) {
        IConnectionLayout c;
        ArrayList<IConnectionLayout> connections = new ArrayList<IConnectionLayout>();
        IConnectionLayout[] iConnectionLayoutArray = ((INodeLayout)layoutEntity1).getOutgoingConnections();
        int n = iConnectionLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = iConnectionLayoutArray[n2];
            if (c.getTarget() == layoutEntity2) {
                connections.add(c);
            }
            ++n2;
        }
        iConnectionLayoutArray = ((INodeLayout)layoutEntity2).getOutgoingConnections();
        n = iConnectionLayoutArray.length;
        n2 = 0;
        while (n2 < n) {
            c = iConnectionLayoutArray[n2];
            if (c.getTarget() == layoutEntity1) {
                connections.add(c);
            }
            ++n2;
        }
        return connections.toArray(new IConnectionLayout[0]);
    }

    public ILayoutAlgorithm getDynamicLayoutAlgorithm() {
        return this.dynamicLayoutAlgorithm;
    }

    public INodeLayout[] getNodes() {
        return this.layoutNodes.toArray(new INodeLayout[0]);
    }

    public Object getProperty(String name) {
        return this.pss.getProperty(name);
    }

    public ILayoutAlgorithm getStaticLayoutAlgorithm() {
        return this.staticLayoutAlgorithm;
    }

    public ISubgraphLayout[] getSubgraphs() {
        return this.subgraphs.toArray(new ISubgraphLayout[0]);
    }

    public boolean isLayoutIrrelevant(IConnectionLayout connLayout) {
        for (ILayoutFilter filter : this.layoutFilters) {
            if (!filter.isLayoutIrrelevant(connLayout)) continue;
            return true;
        }
        return false;
    }

    public boolean isLayoutIrrelevant(INodeLayout nodeLayout) {
        for (ILayoutFilter filter : this.layoutFilters) {
            if (!filter.isLayoutIrrelevant(nodeLayout)) continue;
            return true;
        }
        return false;
    }

    public void removeContextListener(IContextListener listener) {
        this.lls.removeContextListener(listener);
    }

    protected void removeEdge(IConnectionLayout edge) {
        this.layoutEdges.remove(edge);
        this.fireConnectionRemovedEvent(edge);
    }

    public void removeGraphStructureListener(IGraphStructureListener listener) {
        this.lls.removeGraphStructureListener(listener);
    }

    public void removeLayoutFilter(ILayoutFilter layoutFilter) {
        this.layoutFilters.remove(layoutFilter);
    }

    public void removeLayoutListener(ILayoutListener listener) {
        this.lls.removeLayoutListener(listener);
    }

    protected void removeNode(INodeLayout node) {
        this.layoutNodes.remove(node);
        this.fireNodeRemovedEvent(node);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePruningListener(IPruningListener listener) {
        this.lls.removePruningListener(listener);
    }

    public void schedulePostLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        this.postLayoutPass.add(runnable);
    }

    public void schedulePreLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        this.preLayoutPass.add(runnable);
    }

    public void setDynamicLayoutAlgorithm(ILayoutAlgorithm dynamicLayoutAlgorithm) {
        ILayoutAlgorithm oldDynamicLayoutAlgorithm = this.dynamicLayoutAlgorithm;
        if (oldDynamicLayoutAlgorithm != dynamicLayoutAlgorithm) {
            this.dynamicLayoutAlgorithm = dynamicLayoutAlgorithm;
            dynamicLayoutAlgorithm.setLayoutContext(this);
            this.pcs.firePropertyChange("dynamicLayoutAlgorithm", oldDynamicLayoutAlgorithm, dynamicLayoutAlgorithm);
        }
    }

    public void setProperty(String name, Object value) {
        Object oldValue = this.pss.getProperty(name);
        this.pss.setProperty(name, value);
        if (!(oldValue == value || value != null && value.equals(oldValue))) {
            if ("bounds".equals(name)) {
                this.fireBoundsChangedEvent();
            } else if ("dynamic-layout-enabled".equals(name)) {
                this.fireBackgroundEnableChangedEvent();
            } else if ("pruning-enabled".equals(name)) {
                this.firePruningEnableChangedEvent();
            }
        }
        this.pcs.firePropertyChange(name, oldValue, value);
    }

    public void setStaticLayoutAlgorithm(ILayoutAlgorithm staticLayoutAlgorithm) {
        ILayoutAlgorithm oldStaticLayoutAlgorithm = this.staticLayoutAlgorithm;
        if (oldStaticLayoutAlgorithm != staticLayoutAlgorithm) {
            this.staticLayoutAlgorithm = staticLayoutAlgorithm;
            staticLayoutAlgorithm.setLayoutContext(this);
            this.pcs.firePropertyChange("staticLayoutAlgorithm", oldStaticLayoutAlgorithm, staticLayoutAlgorithm);
        }
    }

    public void unschedulePostLayoutPass(Runnable runnable) {
        if (!this.postLayoutPass.contains(runnable)) {
            new IllegalArgumentException("Given Runnable is not contained in the list.").printStackTrace();
        }
        this.postLayoutPass.remove(runnable);
    }

    public void unschedulePreLayoutPass(Runnable runnable) {
        if (!this.preLayoutPass.contains(runnable)) {
            new IllegalArgumentException("Given Runnable is not contained in the list.").printStackTrace();
        }
        this.preLayoutPass.remove(runnable);
    }
}

